/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

class UnderReplicatedBlocks
implements Iterable<Block> {
    static final int LEVEL = 5;
    static final int QUEUE_HIGHEST_PRIORITY = 0;
    static final int QUEUE_VERY_UNDER_REPLICATED = 1;
    static final int QUEUE_UNDER_REPLICATED = 2;
    static final int QUEUE_REPLICAS_BADLY_DISTRIBUTED = 3;
    static final int QUEUE_WITH_CORRUPT_BLOCKS = 4;

    UnderReplicatedBlocks() {
    }

    void clear() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.DEL_ALL_UNDER_REPLICATED_BLKS){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    int size() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_ALL_UNDER_REPLICATED_BLKS){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                return da.countAll();
            }
        }.handle();
    }

    int getUnderReplicatedBlockCount() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_UNDER_REPLICATED_BLKS_LESS_THAN_LVL4){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                return da.countLessThanALevel(4);
            }
        }.handle();
    }

    int getCorruptBlockSize() throws IOException {
        return this.count(4);
    }

    synchronized int getCorruptReplOneBlockSize() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_CORRUPT_REPL_ONE_BLOCKS){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                return da.countReplOneBlocks(4);
            }
        }.handle();
    }

    boolean contains(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        return this.getUnderReplicatedBlock(block) != null;
    }

    private int getPriority(Block block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        if (curReplicas >= expectedReplicas) {
            return 3;
        }
        if (curReplicas == 0) {
            if (decommissionedReplicas > 0) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    boolean add(BlockInfoContiguous block, int curReplicas, int decomissionedReplicas, int expectedReplicas) throws StorageException, TransactionContextException {
        assert (curReplicas >= 0) : "Negative replicas!";
        int priLevel = this.getPriority(block, curReplicas, decomissionedReplicas, expectedReplicas);
        if (this.add(block, priLevel, expectedReplicas)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.add: {} has only {} replicas and need {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, expectedReplicas, priLevel});
            return true;
        }
        return false;
    }

    synchronized boolean remove(BlockInfoContiguous block, int oldReplicas, int decommissionedReplicas, int oldExpectedReplicas) throws IOException {
        boolean removedBlock = this.remove(block);
        return removedBlock;
    }

    boolean remove(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        UnderReplicatedBlock urb = this.getUnderReplicatedBlock(block);
        if (this.remove(urb)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)urb.getLevel());
            return true;
        }
        return false;
    }

    void update(BlockInfoContiguous block, int curReplicas, int decommissionedReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) throws StorageException, TransactionContextException {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, decommissionedReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("UnderReplicationBlocks.update " + block + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri);
        }
        if (this.add(block, curPri, curExpectedReplicas, true)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.update: {} has only {} replicas and needs {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, curExpectedReplicas, curPri});
        }
    }

    private List<List<Block>> chooseUnderReplicatedBlocksInt(int blocksToProcess) throws IOException {
        ArrayList<List<Block>> blocksToReplicate = new ArrayList<List<Block>>(5);
        for (int i = 0; i < 5; ++i) {
            blocksToReplicate.add(new ArrayList());
        }
        if (this.size() == 0) {
            return blocksToReplicate;
        }
        List<Integer> priorityToReplIdx = this.getReplicationIndex();
        List<List<Block>> priorityQueuestmp = this.createPrioriryQueue();
        int blockCount = 0;
        blocksToProcess = Math.min(blocksToProcess, this.size());
        for (int priority = 0; priority < 5; ++priority) {
            Integer replIndex = priorityToReplIdx.get(priority);
            if (blockCount == blocksToProcess) break;
            int remainingblksToProcess = blocksToProcess - blockCount;
            List<UnderReplicatedBlock> urbs = this.getUnderReplicatedBlocks(priority, replIndex, remainingblksToProcess);
            this.addBlocksInPriorityQueues(urbs, priorityQueuestmp);
            List<Block> blks = priorityQueuestmp.get(priority);
            ((List)blocksToReplicate.get(priority)).addAll(blks);
            blockCount += blks.size();
            replIndex = replIndex + blks.size();
            if (priority == 4 && this.count(priority) <= replIndex) {
                for (int i = 0; i < 5; ++i) {
                    priorityToReplIdx.set(i, 0);
                }
                break;
            }
            priorityToReplIdx.set(priority, replIndex);
        }
        this.setReplicationIndex(priorityToReplIdx);
        return blocksToReplicate;
    }

    BlockIterator iterator(final int level) {
        try {
            return (BlockIterator)new HopsTransactionalRequestHandler(HDFSOperationType.UNDER_REPLICATED_BLKS_ITERATOR){

                public void acquireLock(TransactionLocks locks) throws IOException {
                }

                public Object performTask() throws StorageException, IOException {
                    return new BlockIterator(UnderReplicatedBlocks.this.fillPriorityQueues(level), level);
                }
            }.handle();
        }
        catch (IOException ex) {
            BlockManager.LOG.error("Error while filling the priorityQueues from db", (Throwable)ex);
            return null;
        }
    }

    public BlockIterator iterator() {
        try {
            return (BlockIterator)new HopsTransactionalRequestHandler(HDFSOperationType.UNDER_REPLICATED_BLKS_ITERATOR){

                public void acquireLock(TransactionLocks locks) throws IOException {
                }

                public Object performTask() throws StorageException, IOException {
                    return new BlockIterator(UnderReplicatedBlocks.this.fillPriorityQueues());
                }
            }.handle();
        }
        catch (IOException ex) {
            BlockManager.LOG.error("Error while filling the priorityQueues from db", (Throwable)ex);
            return null;
        }
    }

    public void decrementReplicationIndex(int priority) throws StorageException, TransactionContextException {
        List<Integer> priorityToReplIdx = this.getReplicationIndex();
        Integer replIdx = priorityToReplIdx.get(priority);
        replIdx = replIdx <= 0 ? 0 : replIdx - 1;
        priorityToReplIdx.set(priority, replIdx);
        this.setReplicationIndex(priorityToReplIdx);
    }

    public List<List<Block>> chooseUnderReplicatedBlocks(final int blocksToProcess) throws IOException {
        return (List)new HopsTransactionalRequestHandler(HDFSOperationType.CHOOSE_UNDER_REPLICATED_BLKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.ReplicationIndex, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                return UnderReplicatedBlocks.this.chooseUnderReplicatedBlocksInt(blocksToProcess);
            }
        }.handle();
    }

    private boolean remove(UnderReplicatedBlock urb) throws StorageException, TransactionContextException {
        if (urb != null) {
            this.removeUnderReplicatedBlock(urb);
            return true;
        }
        return false;
    }

    private boolean add(BlockInfoContiguous block, int priLevel, int expectedReplicas, boolean update) throws StorageException, TransactionContextException {
        UnderReplicatedBlock urb = this.getUnderReplicatedBlock(block);
        if (urb == null) {
            this.addUnderReplicatedBlock(new UnderReplicatedBlock(priLevel, block.getBlockId(), block.getInodeId(), expectedReplicas));
            return true;
        }
        if (update) {
            this.addUnderReplicatedBlock(new UnderReplicatedBlock(priLevel, block.getBlockId(), block.getInodeId(), expectedReplicas));
        }
        return false;
    }

    private boolean add(BlockInfoContiguous block, int priLevel, int expectedReplicas) throws StorageException, TransactionContextException {
        return this.add(block, priLevel, expectedReplicas, false);
    }

    private List<List<Block>> fillPriorityQueues() throws IOException {
        return this.fillPriorityQueues(-1);
    }

    private List<List<Block>> fillPriorityQueues(int level) throws IOException {
        List<List<Block>> priorityQueuestmp = this.createPrioriryQueue();
        List<UnderReplicatedBlock> allUrb = this.getUnderReplicatedBlocks(level);
        if (!allUrb.isEmpty()) {
            this.addBlocksInPriorityQueues(allUrb, priorityQueuestmp);
        }
        return priorityQueuestmp;
    }

    private List<List<Block>> createPrioriryQueue() {
        ArrayList<List<Block>> priorityQueuestmp = new ArrayList<List<Block>>();
        for (int i = 0; i < 5; ++i) {
            priorityQueuestmp.add(new ArrayList());
        }
        return priorityQueuestmp;
    }

    private List<UnderReplicatedBlock> getUnderReplicatedBlocks(final int level) throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.GET_ALL_UNDER_REPLICATED_BLKS){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                if (level == -1) {
                    return da.findAll();
                }
                return da.findByLevel(level);
            }
        }.handle();
    }

    private List<UnderReplicatedBlock> getUnderReplicatedBlocks(final int level, final int offset, final int count) throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.GET_UNDER_REPLICATED_BLKS_By_LEVEL_LIMITED){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                return da.findByLevel(level, offset, count);
            }
        }.handle();
    }

    private void addBlocksInPriorityQueues(List<UnderReplicatedBlock> allUrb, final List<List<Block>> priorityQueuestmp) throws IOException {
        final long[] blockIds = new long[allUrb.size()];
        final long[] inodeIds = new long[allUrb.size()];
        final HashMap<Long, UnderReplicatedBlock> allUrbHashMap = new HashMap<Long, UnderReplicatedBlock>();
        for (int i = 0; i < allUrb.size(); ++i) {
            UnderReplicatedBlock b = allUrb.get(i);
            blockIds[i] = b.getBlockId();
            inodeIds[i] = b.getInodeId();
            allUrbHashMap.put(b.getBlockId(), b);
        }
        new LightWeightRequestHandler(HDFSOperationType.GET_BLOCKS){

            public Object performTask() throws StorageException, IOException {
                BlockInfoDataAccess bda = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                List blks = bda.findByIds(blockIds, inodeIds);
                for (BlockInfoContiguous blk : blks) {
                    UnderReplicatedBlock urb = (UnderReplicatedBlock)allUrbHashMap.remove(blk.getBlockId());
                    assert (urb.getInodeId() == blk.getInodeId());
                    ((List)priorityQueuestmp.get(urb.getLevel())).add(blk);
                }
                Collection toRemove = allUrbHashMap.values();
                if (!toRemove.isEmpty()) {
                    UnderReplicatedBlockDataAccess uda = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                    uda.prepare(toRemove, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST);
                }
                return null;
            }
        }.handle();
    }

    int count(final int level) throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_UNDER_REPLICATED_BLKS_AT_LVL){

            public Object performTask() throws StorageException, IOException {
                UnderReplicatedBlockDataAccess da = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
                return da.countByLevel(level);
            }
        }.handle();
    }

    private UnderReplicatedBlock getUnderReplicatedBlock(BlockInfoContiguous blk) throws StorageException, TransactionContextException {
        return (UnderReplicatedBlock)EntityManager.find((FinderType)UnderReplicatedBlock.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{blk.getBlockId(), blk.getInodeId()});
    }

    private void addUnderReplicatedBlock(UnderReplicatedBlock urb) throws StorageException, TransactionContextException {
        EntityManager.add((Object)urb);
    }

    private void removeUnderReplicatedBlock(UnderReplicatedBlock urb) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)urb);
    }

    private List<Integer> getReplicationIndex() throws StorageException, TransactionContextException {
        return HdfsVariables.getReplicationIndex();
    }

    private void setReplicationIndex(List<Integer> replicationIndex) throws StorageException, TransactionContextException {
        HdfsVariables.setReplicationIndex(replicationIndex);
    }

    class BlockIterator
    implements Iterator<Block> {
        private int level;
        private boolean isIteratorForLevel = false;
        private final List<Iterator<Block>> iterators = new ArrayList<Iterator<Block>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BlockIterator(List<List<Block>> priorityQueuestmp) {
            this.level = 0;
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                for (int i = 0; i < 5; ++i) {
                    this.iterators.add(priorityQueuestmp.get(i).iterator());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BlockIterator(List<List<Block>> priorityQueuestmp, int l) {
            this.level = l;
            this.isIteratorForLevel = true;
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                this.iterators.add(priorityQueuestmp.get(this.level).iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            if (this.isIteratorForLevel) {
                return;
            }
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                while (this.level < 4 && !this.iterators.get(this.level).hasNext()) {
                    ++this.level;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Block next() {
            if (this.isIteratorForLevel) {
                List<Iterator<Block>> list = this.iterators;
                synchronized (list) {
                    return this.iterators.get(0).next();
                }
            }
            this.update();
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                return this.iterators.get(this.level).next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.isIteratorForLevel) {
                List<Iterator<Block>> list = this.iterators;
                synchronized (list) {
                    return this.iterators.get(0).hasNext();
                }
            }
            this.update();
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                return this.iterators.get(this.level).hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.isIteratorForLevel) {
                List<Iterator<Block>> list = this.iterators;
                synchronized (list) {
                    this.iterators.get(0).remove();
                }
            }
            List<Iterator<Block>> list = this.iterators;
            synchronized (list) {
                this.iterators.get(this.level).remove();
            }
        }

        int getPriority() {
            return this.level;
        }
    }
}

