/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationHandlerUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.CompositeAuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MultiSchemeAuthenticationHandler
implements CompositeAuthenticationHandler {
    private static Logger logger = LoggerFactory.getLogger(MultiSchemeAuthenticationHandler.class);
    public static final String SCHEMES_PROPERTY = "multi-scheme-auth-handler.schemes";
    public static final String AUTH_HANDLER_PROPERTY = "multi-scheme-auth-handler.schemes.%s.handler";
    private static final Splitter STR_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final Map<String, AuthenticationHandler> schemeToAuthHandlerMapping = new HashMap<String, AuthenticationHandler>();
    private final Collection<String> types = new HashSet<String>();
    private final String authType;
    public static final String TYPE = "multi-scheme";

    public MultiSchemeAuthenticationHandler() {
        this(TYPE);
    }

    public MultiSchemeAuthenticationHandler(String authType) {
        this.authType = authType;
    }

    @Override
    public String getType() {
        return this.authType;
    }

    @Override
    public Collection<String> getTokenTypes() {
        return this.types;
    }

    @Override
    public void init(Properties config) throws ServletException {
        for (Map.Entry<Object, Object> prop : config.entrySet()) {
            logger.info("{} : {}", prop.getKey(), prop.getValue());
        }
        this.types.clear();
        String schemesProperty = (String)Preconditions.checkNotNull((Object)config.getProperty(SCHEMES_PROPERTY), (String)"%s system property is not specified.", (Object)SCHEMES_PROPERTY);
        for (String scheme : STR_SPLITTER.split((CharSequence)schemesProperty)) {
            if (this.schemeToAuthHandlerMapping.containsKey(scheme = AuthenticationHandlerUtil.checkAuthScheme(scheme))) {
                throw new IllegalArgumentException("Handler is already specified for " + scheme + " authentication scheme.");
            }
            String authHandlerPropName = String.format(AUTH_HANDLER_PROPERTY, scheme).toLowerCase();
            String authHandlerName = config.getProperty(authHandlerPropName);
            Preconditions.checkNotNull((Object)authHandlerName, (String)"No auth handler configured for scheme %s.", (Object)scheme);
            String authHandlerClassName = AuthenticationHandlerUtil.getAuthenticationHandlerClassName(authHandlerName);
            AuthenticationHandler handler = this.initializeAuthHandler(authHandlerClassName, config);
            this.schemeToAuthHandlerMapping.put(scheme, handler);
            this.types.add(handler.getType());
        }
        logger.info("Successfully initialized MultiSchemeAuthenticationHandler");
    }

    protected AuthenticationHandler initializeAuthHandler(String authHandlerClassName, Properties config) throws ServletException {
        try {
            Preconditions.checkNotNull((Object)authHandlerClassName);
            logger.debug("Initializing Authentication handler of type " + authHandlerClassName);
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(authHandlerClassName);
            AuthenticationHandler authHandler = (AuthenticationHandler)klass.newInstance();
            authHandler.init(config);
            logger.info("Successfully initialized Authentication handler of type " + authHandlerClassName);
            return authHandler;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            logger.error("Failed to initialize authentication handler " + authHandlerClassName, (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        for (AuthenticationHandler handler : this.schemeToAuthHandlerMapping.values()) {
            handler.destroy();
        }
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String authorization = request.getHeader("Authorization");
        if (authorization != null) {
            for (Map.Entry entry : this.schemeToAuthHandlerMapping.entrySet()) {
                if (!AuthenticationHandlerUtil.matchAuthScheme((String)entry.getKey(), authorization)) continue;
                AuthenticationToken token = ((AuthenticationHandler)entry.getValue()).authenticate(request, response);
                logger.trace("Token generated with type {}", (Object)token.getType());
                return token;
            }
        }
        response.setStatus(401);
        for (String string : this.schemeToAuthHandlerMapping.keySet()) {
            response.addHeader("WWW-Authenticate", string);
        }
        return null;
    }
}

