/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import io.hops.hadoop.shaded.org.apache.commons.io.Charsets;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSUtilClient {
    private static final Logger LOG = LoggerFactory.getLogger(DFSUtilClient.class);

    public static byte[] string2Bytes(String str) {
        return str.getBytes(Charsets.UTF_8);
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtilClient.bytes2String(bytes, 0, bytes.length);
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static String percent2String(double percentage) {
        return StringUtils.format("%.2f%%", percentage);
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getTrimmedStringCollection("dfs.nameservices");
    }

    public static Collection<String> getNameNodeIds(Configuration conf, String nsId) {
        String key = DFSUtilClient.addSuffix("dfs.ha.namenodes", nsId);
        return conf.getTrimmedStringCollection(key);
    }

    static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnWebHdfsAddresses(Configuration conf, String scheme) {
        if ("webhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.http-address");
        }
        if ("swebhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.https-address");
        }
        throw new IllegalArgumentException("Unsupported scheme: " + scheme);
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        return DFSUtilClient.locatedBlocks2Locations(blocks.getLocatedBlocks());
    }

    public static BlockLocation[] locatedBlocks2Locations(List<LocatedBlock> blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.size();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] xferAddrs = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                xferAddrs[hCnt] = locations[hCnt].getXferAddr();
                NodeBase node = new NodeBase(xferAddrs[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            DatanodeInfo[] cachedLocations = blk.getCachedLocations();
            String[] cachedHosts = new String[cachedLocations.length];
            for (int i = 0; i < cachedLocations.length; ++i) {
                cachedHosts[i] = cachedLocations[i].getHostName();
            }
            blkLocations[idx] = new BlockLocation(xferAddrs, hosts, cachedHosts, racks, blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    private static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on((String)".").skipNulls().join((Object[])suffixes);
    }

    static Map<String, Map<String, InetSocketAddress>> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtilClient.getNameServiceIds(conf);
        return DFSUtilClient.getAddressesForNsIds(conf, nameserviceIds, defaultAddress, keys);
    }

    static Map<String, Map<String, InetSocketAddress>> getAddressesForNsIds(Configuration conf, Collection<String> nsIds, String defaultAddress, String ... keys) {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nsId : DFSUtilClient.emptyAsSingletonNull(nsIds)) {
            Map<String, InetSocketAddress> isas = DFSUtilClient.getAddressesForNameserviceId(conf, nsId, defaultAddress, keys);
            if (isas.isEmpty()) continue;
            ret.put(nsId, isas);
        }
        return ret;
    }

    static Map<String, InetSocketAddress> getAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue, String ... keys) {
        Collection<String> nnIds = DFSUtilClient.getNameNodeIds(conf, nsId);
        HashMap ret = Maps.newHashMap();
        for (String nnId : DFSUtilClient.emptyAsSingletonNull(nnIds)) {
            String suffix = DFSUtilClient.concatSuffixes(nsId, nnId);
            String address = DFSUtilClient.getConfValue(defaultValue, suffix, conf, keys);
            if (address == null) continue;
            InetSocketAddress isa = NetUtils.createSocketAddr(address);
            if (isa.isUnresolved()) {
                LOG.warn("Namenode for " + nsId + " remains unresolved for ID " + nnId + ".  Check your hdfs-site.xml file to ensure namenodes are configured properly.");
            }
            ret.put(nnId, isa);
        }
        return ret;
    }

    private static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            value = conf.get(key = DFSUtilClient.addSuffix(key, keySuffix));
            if (value != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = StringUtils.split(src, '/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (element.equals(".") || element.contains(":") || element.contains("/")) {
                return false;
            }
            if (element.equals("..")) {
                if (components.length > 4 && components[1].equals(".reserved") && components[2].equals(".inodes")) continue;
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }
}

