/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.hadoop.shaded.com.google.gson.FieldNamingPolicy;
import io.hops.hadoop.shaded.com.google.gson.Gson;
import io.hops.hadoop.shaded.com.google.gson.GsonBuilder;
import io.hops.hadoop.shaded.org.apache.http.HttpHost;
import io.hops.hadoop.shaded.org.apache.http.HttpRequest;
import io.hops.hadoop.shaded.org.apache.http.HttpResponse;
import io.hops.hadoop.shaded.org.apache.http.conn.HttpClientConnectionManager;
import io.hops.hadoop.shaded.org.apache.http.entity.ContentType;
import io.hops.hadoop.shaded.org.apache.http.impl.client.CloseableHttpClient;
import io.hops.hadoop.shaded.org.apache.http.impl.client.HttpClients;
import io.hops.hadoop.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;

public abstract class AbstractSecurityActions
extends CompositeService {
    protected static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    public static final String API_KEY_AUTH_HEADER_CONTENT = "ApiKey %s";
    public static final String HOPSWORKS_API_kEY_PROP = "hops.hopsworks-api-key";
    private static final Set<Integer> ACCEPTABLE_HTTP_RESPONSES = new HashSet<Integer>(2);
    protected CloseableHttpClient httpClient;
    protected HttpHost remoteHost;
    protected Gson parser = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    private PoolingHttpClientConnectionManager httpConnectionManager;
    private String apiKey;

    public AbstractSecurityActions(String name) {
        super(name);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        Configuration sslConf = new Configuration(false);
        String sslServer = conf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        sslConf.addResource(sslServer);
        this.apiKey = sslConf.get(HOPSWORKS_API_kEY_PROP);
        if (this.apiKey == null) {
            throw new IllegalArgumentException("Hopsworks API key is empty. Have you set hops.hopsworks-api-key at " + sslServer);
        }
        this.remoteHost = HttpHost.create((String)conf.get("hops.hopsworks.host", "https://127.0.0.1"));
        super.serviceInit(conf);
    }

    protected PoolingHttpClientConnectionManager createHTTPConnectionManager() throws GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(50);
        return connectionManager;
    }

    @Override
    protected void serviceStart() throws Exception {
        this.httpConnectionManager = this.createHTTPConnectionManager();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        super.serviceStop();
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    protected void checkHTTPResponseCode(HttpResponse response, String extraMessage) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (!ACCEPTABLE_HTTP_RESPONSES.contains(code)) {
            throw new IOException("HTTP error, response code " + code + " Reason: " + response.getStatusLine().getReasonPhrase() + " Message: " + extraMessage);
        }
    }

    protected void setAuthenticationHeader(HttpRequest request) {
        String authHeader = String.format(API_KEY_AUTH_HEADER_CONTENT, this.apiKey);
        request.addHeader("Authorization", authHeader);
    }

    protected void addJSONContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.APPLICATION_JSON.toString());
    }

    protected void addTextPlainContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.TEXT_PLAIN.toString());
    }

    private void addContentTypeHeader(HttpRequest request, String contentType) {
        request.addHeader("Content-Type", contentType);
    }

    static {
        ACCEPTABLE_HTTP_RESPONSES.add(200);
        ACCEPTABLE_HTTP_RESPONSES.add(204);
    }
}

