/*
 * Decompiled with CFR 0.152.
 */
package io.hops.net;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.Builder;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hadoop.shaded.org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CommonConfigurationKeys;

public class ServiceDiscoveryClientFactory {
    private static volatile ServiceDiscoveryClientFactory SELF;
    private ServiceDiscoveryClient testClient;

    private ServiceDiscoveryClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDiscoveryClientFactory getInstance() {
        if (SELF != null) return SELF;
        Class<ServiceDiscoveryClientFactory> clazz = ServiceDiscoveryClientFactory.class;
        synchronized (ServiceDiscoveryClientFactory.class) {
            if (SELF != null) return SELF;
            SELF = new ServiceDiscoveryClientFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SELF;
        }
    }

    public ServiceDiscoveryClient getClient(Builder builder) throws ServiceDiscoveryException {
        return this.testClient != null ? this.testClient : builder.build();
    }

    public Pair<String, Integer> getNameserver(Configuration conf) {
        Integer dnsPort;
        String dnsHost = conf.get("hops.service-discovery.dns-host", "");
        if (dnsHost.isEmpty()) {
            dnsHost = null;
        }
        if ((dnsPort = Integer.valueOf(conf.getInt("hops.service-discovery.dns-port", CommonConfigurationKeys.DEFAULT_SERVICE_DISCOVERY_DNS_PORT))) == -1) {
            dnsPort = null;
        }
        return new Pair((Object)dnsHost, (Object)dnsPort);
    }

    @VisibleForTesting
    public void setClient(ServiceDiscoveryClient sdClient) {
        this.testClient = sdClient;
    }
}

