/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class BlockTokenSecretManager
extends SecretManager<BlockTokenIdentifier> {
    public static final Log LOG = LogFactory.getLog(BlockTokenSecretManager.class);
    public static final Token<BlockTokenIdentifier> DUMMY_TOKEN = new Token();
    protected final boolean isMaster;
    protected long keyUpdateInterval;
    protected volatile long tokenLifetime;
    protected int serialNo;
    protected BlockKey currentKey;
    protected BlockKey nextKey;
    protected Map<Integer, BlockKey> allKeys;
    protected String blockPoolId;
    protected String encryptionAlgorithm;
    protected SecureRandom nonceGenerator = new SecureRandom();

    public BlockTokenSecretManager(long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm) throws IOException {
        this(false, keyUpdateInterval, tokenLifetime, blockPoolId, encryptionAlgorithm);
    }

    protected BlockTokenSecretManager(boolean isMaster, long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm) throws IOException {
        this.isMaster = isMaster;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenLifetime = tokenLifetime;
        this.allKeys = new HashMap<Integer, BlockKey>();
        this.blockPoolId = blockPoolId;
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (isMaster) {
            this.setSerialNo(new SecureRandom().nextInt());
        }
        this.generateKeys();
    }

    @VisibleForTesting
    public synchronized void setSerialNo(int serialNo) {
        this.serialNo = serialNo;
    }

    public void setBlockPoolId(String blockPoolId) {
        this.blockPoolId = blockPoolId;
    }

    private synchronized void generateKeys() {
        if (!this.isMaster) {
            return;
        }
        this.setSerialNo(this.serialNo + 1);
        this.currentKey = new BlockKey(this.serialNo, Time.now() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret(), BlockKey.KeyType.CurrKey);
        this.setSerialNo(this.serialNo + 1);
        this.nextKey = new BlockKey(this.serialNo, Time.now() + 4L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret(), BlockKey.KeyType.NextKey);
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
    }

    public synchronized ExportedBlockKeys exportKeys() throws IOException {
        if (!this.isMaster) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exporting access keys");
        }
        return new ExportedBlockKeys(true, this.keyUpdateInterval, this.tokenLifetime, this.currentKey, this.allKeys.values().toArray(new BlockKey[0]));
    }

    protected synchronized void removeExpiredKeys() {
        long now = Time.now();
        Iterator<Map.Entry<Integer, BlockKey>> it = this.allKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BlockKey> e = it.next();
            if (e.getValue().getExpiryDate() >= now) continue;
            it.remove();
        }
    }

    public synchronized void addKeys(ExportedBlockKeys exportedKeys) throws IOException {
        BlockKey[] receivedKeys;
        if (this.isMaster || exportedKeys == null) {
            return;
        }
        LOG.info((Object)"Setting block keys");
        this.removeExpiredKeys();
        this.currentKey = exportedKeys.getCurrentKey();
        for (BlockKey receivedKey : receivedKeys = exportedKeys.getAllKeys()) {
            if (receivedKey == null) continue;
            this.allKeys.put(receivedKey.getKeyId(), receivedKey);
        }
    }

    public synchronized boolean updateKeys(long updateTime) throws IOException {
        if (updateTime > this.keyUpdateInterval) {
            return this.updateKeys();
        }
        return false;
    }

    public synchronized boolean updateKeys() throws IOException {
        if (!this.isMaster) {
            return false;
        }
        LOG.info((Object)"Updating block keys");
        this.removeExpiredKeys();
        this.allKeys.put(this.currentKey.getKeyId(), new BlockKey(this.currentKey.getKeyId(), Time.now() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.currentKey.getKey(), BlockKey.KeyType.SimpleKey));
        this.currentKey = new BlockKey(this.nextKey.getKeyId(), Time.now() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.nextKey.getKey(), BlockKey.KeyType.CurrKey);
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        this.setSerialNo(this.serialNo + 1);
        this.nextKey = new BlockKey(this.serialNo, Time.now() + 4L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret(), BlockKey.KeyType.NextKey);
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
        return true;
    }

    public Token<BlockTokenIdentifier> generateToken(ExtendedBlock block, EnumSet<BlockTokenIdentifier.AccessMode> modes) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, block, modes);
    }

    public Token<BlockTokenIdentifier> generateToken(String userId, ExtendedBlock block, EnumSet<BlockTokenIdentifier.AccessMode> modes) throws IOException {
        BlockTokenIdentifier id = new BlockTokenIdentifier(userId, block.getBlockPoolId(), block.getBlockId(), modes);
        return new Token<BlockTokenIdentifier>(id, this);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode) throws SecretManager.InvalidToken {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking access for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode) + " using " + id.toString()));
        }
        if (userId != null && !userId.equals(id.getUserId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't belong to user " + userId);
        }
        if (!id.getBlockPoolId().equals(block.getBlockPoolId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't apply to block " + block);
        }
        if (id.getBlockId() != block.getBlockId()) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't apply to block " + block);
        }
        if (BlockTokenSecretManager.isExpired(id.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " is expired.");
        }
        if (!id.getAccessModes().contains((Object)mode)) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have " + (Object)((Object)mode) + " permission");
        }
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode) throws SecretManager.InvalidToken {
        BlockTokenIdentifier id = new BlockTokenIdentifier();
        try {
            id.readFields(new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        }
        catch (IOException e) {
            throw new SecretManager.InvalidToken("Unable to de-serialize block token identifier for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode));
        }
        this.checkAccess(id, userId, block, mode);
        if (!Arrays.equals(this.retrievePassword(id), token.getPassword())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have the correct token password");
        }
    }

    protected static boolean isExpired(long expiryDate) {
        return Time.now() > expiryDate;
    }

    static boolean isTokenExpired(Token<BlockTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        long expiryDate = WritableUtils.readVLong(in);
        return BlockTokenSecretManager.isExpired(expiryDate);
    }

    public void setTokenLifetime(long tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    @Override
    public BlockTokenIdentifier createIdentifier() {
        return new BlockTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createPassword(BlockTokenIdentifier identifier) {
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.currentKey;
        }
        if (key == null) {
            throw new IllegalStateException("currentKey hasn't been initialized.");
        }
        identifier.setExpiryDate(Time.now() + this.tokenLifetime);
        identifier.setKeyId(key.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating block token for " + identifier.toString()));
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        if (BlockTokenSecretManager.isExpired(identifier.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + identifier.toString() + " is expired.");
        }
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.allKeys.get(identifier.getKeyId());
        }
        if (key == null) {
            throw new SecretManager.InvalidToken("Can't re-compute password for " + identifier.toString() + ", since the required block key (keyID=" + identifier.getKeyId() + ") doesn't exist.");
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataEncryptionKey generateDataEncryptionKey() throws IOException {
        byte[] nonce = new byte[8];
        this.nonceGenerator.nextBytes(nonce);
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.currentKey;
        }
        byte[] encryptionKey = BlockTokenSecretManager.createPassword(nonce, key.getKey());
        return new DataEncryptionKey(key.getKeyId(), this.blockPoolId, nonce, encryptionKey, Time.now() + this.tokenLifetime, this.encryptionAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveDataEncryptionKey(int keyId, byte[] nonce) throws InvalidEncryptionKeyException {
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.allKeys.get(keyId);
            if (key == null) {
                throw new InvalidEncryptionKeyException("Can't re-compute encryption key for nonce, since the required block key (keyID=" + keyId + ") doesn't exist. Current key: " + this.currentKey.getKeyId());
            }
        }
        return BlockTokenSecretManager.createPassword(nonce, key.getKey());
    }

    @VisibleForTesting
    public synchronized void setKeyUpdateIntervalForTesting(long millis) {
        this.keyUpdateInterval = millis;
    }

    @VisibleForTesting
    public void clearAllKeysForTesting() {
        this.allKeys.clear();
    }

    @VisibleForTesting
    public synchronized int getSerialNoForTesting() {
        return this.serialNo;
    }
}

