/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import io.hops.hadoop.shaded.com.sun.jersey.api.client.Client;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import io.hops.hadoop.shaded.com.sun.jersey.api.json.JSONJAXBContext;
import io.hops.hadoop.shaded.com.sun.jersey.api.json.JSONMarshaller;
import io.hops.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public final class YarnWebServiceUtils {
    private YarnWebServiceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getNodeInfoFromRMWebService(Configuration conf, String nodeId) throws ClientHandlerException, UniformInterfaceException {
        Client webServiceClient = Client.create();
        String webAppAddress = WebAppUtils.getRMWebAppURLWithScheme(conf);
        WebResource webResource = webServiceClient.resource(webAppAddress);
        ClientResponse response = null;
        try {
            response = (ClientResponse)webResource.path("ws").path("v1").path("cluster").path("nodes").path(nodeId).accept(new String[]{"application/json"}).get(ClientResponse.class);
            JSONObject jSONObject = (JSONObject)response.getEntity(JSONObject.class);
            return jSONObject;
        }
        finally {
            if (response != null) {
                response.close();
            }
            webServiceClient.destroy();
        }
    }

    public static String toJson(Object nsli, Class klass) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON(nsli, (Writer)sw);
        return sw.toString();
    }
}

