/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
class BlockPoolManager {
    private static final Log LOG = DataNode.LOG;
    private final Map<String, BPOfferService> bpByNameserviceId = Maps.newHashMap();
    private final Map<String, BPOfferService> bpByBlockPoolId = Maps.newHashMap();
    private final List<BPOfferService> offerServices = new CopyOnWriteArrayList<BPOfferService>();
    private final DataNode dn;
    private final Object refreshNamenodesLock = new Object();

    BlockPoolManager(DataNode dn) {
        this.dn = dn;
    }

    synchronized void addBlockPool(BPOfferService bpos) {
        Preconditions.checkArgument((boolean)this.offerServices.contains(bpos), (String)"Unknown BPOS: %s", (Object)bpos);
        if (bpos.getBlockPoolId() == null) {
            throw new IllegalArgumentException("Null blockpool id");
        }
        this.bpByBlockPoolId.put(bpos.getBlockPoolId(), bpos);
    }

    synchronized List<BPOfferService> getAllNamenodeThreads() {
        return Collections.unmodifiableList(this.offerServices);
    }

    synchronized BPOfferService get(String bpid) {
        return this.bpByBlockPoolId.get(bpid);
    }

    synchronized void remove(BPOfferService t) {
        this.offerServices.remove(t);
        if (t.hasBlockPoolId()) {
            this.bpByBlockPoolId.remove(t.getBlockPoolId());
        }
        boolean removed = false;
        Iterator<BPOfferService> it = this.bpByNameserviceId.values().iterator();
        while (it.hasNext() && !removed) {
            BPOfferService bpos = it.next();
            if (bpos != t) continue;
            it.remove();
            LOG.info((Object)("Removed " + bpos));
            removed = true;
        }
        if (!removed) {
            LOG.warn((Object)("Couldn't remove BPOS " + t + " from bpByNameserviceId map"));
        }
    }

    void shutDownAll(List<BPOfferService> bposList) throws InterruptedException {
        for (BPOfferService bpos : bposList) {
            bpos.stop();
        }
        for (BPOfferService bpos : bposList) {
            bpos.join();
        }
    }

    synchronized void startAll() throws IOException {
        try {
            UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    for (BPOfferService bpos : BlockPoolManager.this.offerServices) {
                        bpos.start();
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex.getCause());
            throw ioe;
        }
    }

    void joinAll() {
        for (BPOfferService bpos : this.getAllNamenodeThreads()) {
            bpos.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNamenodes(Configuration conf) throws IOException {
        Object object = this.refreshNamenodesLock;
        synchronized (object) {
            List<InetSocketAddress> namenodes = DFSUtil.getNameNodesServiceRpcAddresses(conf);
            this.offerServices.add(this.createBPOS(namenodes));
            this.startAll();
        }
    }

    protected BPOfferService createBPOS(List<InetSocketAddress> nnAddrs) {
        return new BPOfferService(nnAddrs, this.dn);
    }
}

