/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import io.hops.hadoop.shaded.org.apache.http.config.RegistryBuilder;
import io.hops.hadoop.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import io.hops.hadoop.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import io.hops.hadoop.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import io.hops.hadoop.shaded.org.apache.http.ssl.SSLContexts;
import io.hops.hadoop.shaded.org.apache.http.ssl.TrustStrategy;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.conf.Configuration;

public class HttpUtils {
    static final String POLL_ENDPOINT = "hops.alive-watchdog.http-poll.url";
    static final String POLL_TRUSTSTORE = "hops.alive-watchdog.http-poll.truststore";
    static final String POLL_TRUSTSTORE_PASSWORD = "hops.alive-watchdog.http-poll.truststore-password";

    protected static PoolingHttpClientConnectionManager createHTTPConnectionManager(Configuration conf, int maxConnectionsPerRoute) throws IOException, GeneralSecurityException {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        String trustStoreLocation = conf.get(POLL_TRUSTSTORE);
        String trustStorePassword = conf.get(POLL_TRUSTSTORE_PASSWORD);
        if (trustStoreLocation != null) {
            TrustStrategy acceptAll = (certChain, authType) -> true;
            SSLContext sslCtx = SSLContexts.custom().loadTrustMaterial(new File(trustStoreLocation), trustStorePassword.toCharArray(), acceptAll).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslCtx);
            registryBuilder.register("https", (Object)sslSocketFactory);
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registryBuilder.build());
        connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        return connectionManager;
    }
}

