/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.impl.pb.client;

import io.hops.hadoop.shaded.com.google.protobuf.ServiceException;
import io.hops.util.GroupMembership;
import io.hops.util.GroupMembershipPB;
import io.hops.util.LiveRMsResponse;
import io.hops.util.impl.pb.LiveRMsResponsePBImpl;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.GroupMembership;

public class GroupMembershipPBClientImpl
implements GroupMembership,
Closeable {
    private GroupMembershipPB proxy;

    public GroupMembershipPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine(conf, GroupMembershipPB.class, ProtobufRpcEngine.class);
        this.proxy = RPC.getProxy(GroupMembershipPB.class, clientVersion, addr, conf);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy(this.proxy);
        }
    }

    @Override
    public LiveRMsResponse getLiveRMList() throws IOException, YarnException {
        GroupMembership.ActiveRMListRequestProto requestProto = GroupMembership.ActiveRMListRequestProto.getDefaultInstance();
        try {
            return new LiveRMsResponsePBImpl(this.proxy.getLiveRMList(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }
}

