/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSOutputStream;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsDataOutputStream
extends FSDataOutputStream {
    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super(out, stats, startPosition);
    }

    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public HdfsDataOutputStream(CryptoOutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super(out, stats, startPosition);
        Preconditions.checkArgument((boolean)(out.getWrappedStream() instanceof DFSOutputStream), (Object)"CryptoOutputStream should wrap a DFSOutputStream");
    }

    public HdfsDataOutputStream(CryptoOutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        OutputStream wrappedStream = this.getWrappedStream();
        if (wrappedStream instanceof CryptoOutputStream) {
            wrappedStream = ((CryptoOutputStream)wrappedStream).getWrappedStream();
        }
        return ((DFSOutputStream)wrappedStream).getCurrentBlockReplication();
    }

    public void hsync(EnumSet<SyncFlag> syncFlags) throws IOException {
        OutputStream wrappedStream = this.getWrappedStream();
        if (wrappedStream instanceof CryptoOutputStream) {
            ((CryptoOutputStream)wrappedStream).flush();
            wrappedStream = ((CryptoOutputStream)wrappedStream).getWrappedStream();
        }
        ((DFSOutputStream)wrappedStream).hsync(syncFlags);
    }

    public static enum SyncFlag {
        UPDATE_LENGTH,
        END_BLOCK;

    }
}

