/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.hops.hadoop.shaded.com.google.protobuf.RpcController;
import io.hops.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

public class NamenodeProtocolServerSideTranslatorPB
implements NamenodeProtocolPB {
    private final NamenodeProtocol impl;

    public NamenodeProtocolServerSideTranslatorPB(NamenodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public NamenodeProtocolProtos.GetBlocksResponseProto getBlocks(RpcController unused, NamenodeProtocolProtos.GetBlocksRequestProto request) throws ServiceException {
        BlocksWithLocations blocks;
        DatanodeInfo dnInfo = new DatanodeInfo(PBHelper.convert(request.getDatanode()));
        try {
            blocks = this.impl.getBlocks(dnInfo, request.getSize());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return NamenodeProtocolProtos.GetBlocksResponseProto.newBuilder().setBlocks(PBHelper.convert(blocks)).build();
    }

    @Override
    public NamenodeProtocolProtos.GetBlockKeysResponseProto getBlockKeys(RpcController unused, NamenodeProtocolProtos.GetBlockKeysRequestProto request) throws ServiceException {
        ExportedBlockKeys keys;
        try {
            keys = this.impl.getBlockKeys();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        NamenodeProtocolProtos.GetBlockKeysResponseProto.Builder builder = NamenodeProtocolProtos.GetBlockKeysResponseProto.newBuilder();
        if (keys != null) {
            builder.setKeys(PBHelper.convert(keys));
        }
        return builder.build();
    }

    @Override
    public HdfsProtos.VersionResponseProto versionRequest(RpcController controller, HdfsProtos.VersionRequestProto request) throws ServiceException {
        NamespaceInfo info;
        try {
            info = this.impl.versionRequest();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return HdfsProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert(info)).build();
    }
}

