/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
public class ExportedBlockKeys
implements Writable {
    public static final ExportedBlockKeys DUMMY_KEYS = new ExportedBlockKeys();
    private boolean isBlockTokenEnabled;
    private long keyUpdateInterval;
    private long tokenLifetime;
    private BlockKey currentKey;
    private BlockKey[] allKeys;

    public ExportedBlockKeys() {
        this(false, 0L, 0L, new BlockKey(), new BlockKey[0]);
    }

    public ExportedBlockKeys(boolean isBlockTokenEnabled, long keyUpdateInterval, long tokenLifetime, BlockKey currentKey, BlockKey[] allKeys) {
        this.isBlockTokenEnabled = isBlockTokenEnabled;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenLifetime = tokenLifetime;
        this.currentKey = currentKey == null ? new BlockKey() : currentKey;
        this.allKeys = allKeys == null ? new BlockKey[]{} : allKeys;
    }

    public boolean isBlockTokenEnabled() {
        return this.isBlockTokenEnabled;
    }

    public long getKeyUpdateInterval() {
        return this.keyUpdateInterval;
    }

    public long getTokenLifetime() {
        return this.tokenLifetime;
    }

    public BlockKey getCurrentKey() {
        return this.currentKey;
    }

    public BlockKey[] getAllKeys() {
        return this.allKeys;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isBlockTokenEnabled);
        out.writeLong(this.keyUpdateInterval);
        out.writeLong(this.tokenLifetime);
        this.currentKey.write(out);
        out.writeInt(this.allKeys.length);
        for (BlockKey allKey : this.allKeys) {
            allKey.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.isBlockTokenEnabled = in.readBoolean();
        this.keyUpdateInterval = in.readLong();
        this.tokenLifetime = in.readLong();
        this.currentKey.readFields(in);
        this.allKeys = new BlockKey[in.readInt()];
        for (int i = 0; i < this.allKeys.length; ++i) {
            this.allKeys[i] = new BlockKey();
            this.allKeys[i].readFields(in);
        }
    }

    static {
        WritableFactories.setFactory(ExportedBlockKeys.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new ExportedBlockKeys();
            }
        });
    }
}

