/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.util.EnumCounters;

public class DirectoryWithQuotaFeature
implements INode.Feature {
    public static final long DEFAULT_NAMESPACE_QUOTA = Long.MAX_VALUE;
    public static final long DEFAULT_STORAGE_SPACE_QUOTA = -1L;
    private QuotaCounts quota;
    private QuotaCounts usage;
    private Long inodeId;

    private DirectoryWithQuotaFeature(Builder builder) {
        this.inodeId = builder.inodeId;
        this.quota = builder.quota;
        this.usage = builder.usage;
    }

    private DirectoryWithQuotaFeature(Builder builder, boolean save) throws TransactionContextException, StorageException {
        this.inodeId = builder.inodeId;
        this.quota = builder.quota;
        this.usage = builder.usage;
        if (save) {
            this.save();
        }
    }

    public QuotaCounts getQuota() {
        return new QuotaCounts.Builder().quotaCount(this.quota).build();
    }

    void setQuota(long nsQuota, long ssQuota, StorageType type) throws StorageException, TransactionContextException {
        if (type != null) {
            this.quota.setTypeSpace(type, ssQuota);
        } else {
            this.setQuota(nsQuota, ssQuota);
        }
        this.save();
    }

    void setQuota(long nsQuota, long ssQuota) throws TransactionContextException, StorageException {
        this.quota.setNameSpace(nsQuota);
        this.quota.setStorageSpace(ssQuota);
        this.save();
    }

    void setQuota(long quota, StorageType type) throws TransactionContextException, StorageException {
        this.quota.setTypeSpace(type, quota);
        this.save();
    }

    void setQuota(EnumCounters<StorageType> tsQuotas) throws TransactionContextException, StorageException {
        this.quota.setTypeSpaces(tsQuotas);
        this.save();
    }

    QuotaCounts AddCurrentSpaceUsage(QuotaCounts counts) {
        counts.add(this.usage);
        return counts;
    }

    ContentSummaryComputationContext computeContentSummary(INodeDirectory dir, ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        long original = summary.getCounts().getStoragespace();
        long oldYieldCount = summary.getYieldCount();
        dir.computeDirectoryContentSummary(summary);
        if (oldYieldCount == summary.getYieldCount()) {
            this.checkStoragespace(dir, summary.getCounts().getStoragespace() - original);
        }
        return summary;
    }

    private void checkStoragespace(INodeDirectory dir, long computed) throws StorageException, TransactionContextException {
        if (-1L != this.quota.getStorageSpace() && this.usage.getStorageSpace() != computed) {
            NameNode.LOG.error("BUG: Inconsistent storagespace for directory " + dir.getFullPathName() + ". Cached = " + this.usage.getStorageSpace() + " != Computed = " + computed);
        }
    }

    void addSpaceConsumed(INodeDirectory dir, QuotaCounts counts) throws StorageException, TransactionContextException {
        if (dir.isQuotaSet()) {
            this.addSpaceConsumed2Cache(counts);
        }
    }

    public void addSpaceConsumed2Cache(QuotaCounts delta) throws TransactionContextException, StorageException {
        this.usage.add(delta);
        this.save();
    }

    void setSpaceConsumed(long namespace, long storagespace, EnumCounters<StorageType> typespaces) {
        this.usage.setNameSpace(namespace);
        this.usage.setStorageSpace(storagespace);
        this.usage.setTypeSpaces(typespaces);
    }

    void setSpaceConsumed(QuotaCounts c) {
        this.usage.setNameSpace(c.getNameSpace());
        this.usage.setStorageSpace(c.getStorageSpace());
        this.usage.setTypeSpaces(c.getTypeSpaces());
    }

    public QuotaCounts getSpaceConsumed() {
        return new QuotaCounts.Builder().quotaCount(this.usage).build();
    }

    private void verifyNamespaceQuota(long delta) throws NSQuotaExceededException {
        if (Quota.isViolated(this.quota.getNameSpace(), this.usage.getNameSpace(), delta)) {
            throw new NSQuotaExceededException(this.quota.getNameSpace(), this.usage.getNameSpace() + delta);
        }
    }

    private void verifyStoragespaceQuota(long delta) throws DSQuotaExceededException {
        if (Quota.isViolated(this.quota.getStorageSpace(), this.usage.getStorageSpace(), delta)) {
            throw new DSQuotaExceededException(this.quota.getStorageSpace(), this.usage.getStorageSpace() + delta);
        }
    }

    private void verifyQuotaByStorageType(EnumCounters<StorageType> typeDelta) throws QuotaByStorageTypeExceededException {
        if (!this.isQuotaByStorageTypeSet()) {
            return;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (!this.isQuotaByStorageTypeSet(t) || !Quota.isViolated(this.quota.getTypeSpace(t), this.usage.getTypeSpace(t), typeDelta.get(t))) continue;
            throw new QuotaByStorageTypeExceededException(this.quota.getTypeSpace(t), this.usage.getTypeSpace(t) + typeDelta.get(t), t);
        }
    }

    void verifyQuota(QuotaCounts counts) throws QuotaExceededException, StorageException, TransactionContextException {
        this.verifyNamespaceQuota(counts.getNameSpace());
        this.verifyStoragespaceQuota(counts.getStorageSpace());
        this.verifyQuotaByStorageType(counts.getTypeSpaces());
    }

    boolean isQuotaSet() {
        return this.quota.anyNsSsCountGreaterOrEqual(0L) || this.quota.anyTypeSpaceCountGreaterOrEqual(0L);
    }

    boolean isQuotaByStorageTypeSet() {
        return this.quota.anyTypeSpaceCountGreaterOrEqual(0L);
    }

    boolean isQuotaByStorageTypeSet(StorageType t) {
        return this.quota.getTypeSpace(t) >= 0L;
    }

    private String namespaceString() {
        return "namespace: " + (this.quota.getNameSpace() < 0L ? "-" : this.usage.getNameSpace() + "/" + this.quota.getNameSpace());
    }

    private String storagespaceString() {
        return "storagespace: " + (this.quota.getStorageSpace() < 0L ? "-" : this.usage.getStorageSpace() + "/" + this.quota.getStorageSpace());
    }

    private String typeSpaceString() {
        StringBuilder sb = new StringBuilder();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            sb.append("StorageType: " + (Object)((Object)t) + (this.quota.getTypeSpace(t) < 0L ? "-" : this.usage.getTypeSpace(t) + "/" + this.usage.getTypeSpace(t)));
        }
        return sb.toString();
    }

    public String toString() {
        return "Quota[" + this.namespaceString() + ", " + this.storagespaceString() + ", " + this.typeSpaceString() + "]";
    }

    void remove() throws StorageException, TransactionContextException {
        EntityManager.remove((Object)this);
    }

    void save() throws TransactionContextException, StorageException {
        EntityManager.update((Object)this);
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public static class Builder {
        private QuotaCounts quota;
        private QuotaCounts usage;
        private Long inodeId;

        public Builder(Long inodeId) {
            this.inodeId = inodeId;
            this.quota = new QuotaCounts.Builder().nameSpace(Long.MAX_VALUE).storageSpace(-1L).typeSpaces(-1L).build();
            this.usage = new QuotaCounts.Builder().nameSpace(1L).build();
        }

        public Builder nameSpaceQuota(long nameSpaceQuota) {
            this.quota.setNameSpace(nameSpaceQuota);
            return this;
        }

        public Builder storageSpaceQuota(long spaceQuota) {
            this.quota.setStorageSpace(spaceQuota);
            return this;
        }

        public Builder typeQuotas(EnumCounters<StorageType> typeQuotas) {
            this.quota.setTypeSpaces(typeQuotas);
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.quota.setTypeSpace(type, quota);
            return this;
        }

        public Builder nameSpaceUsage(long nameSpaceQuota) {
            this.usage.setNameSpace(nameSpaceQuota);
            return this;
        }

        public Builder spaceUsage(long spaceQuota) {
            this.usage.setStorageSpace(spaceQuota);
            return this;
        }

        public Builder typeUsages(EnumCounters<StorageType> typeQuotas) {
            this.usage.setTypeSpaces(typeQuotas);
            return this;
        }

        public Builder typeUsage(StorageType type, long quota) {
            this.usage.setTypeSpace(type, quota);
            return this;
        }

        public DirectoryWithQuotaFeature build() {
            return new DirectoryWithQuotaFeature(this);
        }

        public DirectoryWithQuotaFeature build(boolean save) throws TransactionContextException, StorageException {
            if (save) {
                return new DirectoryWithQuotaFeature(this, save);
            }
            return this.build();
        }
    }

    public static enum Finder implements FinderType<DirectoryWithQuotaFeature>
    {
        ByINodeId,
        ByINodeIds;


        public Class getType() {
            return DirectoryWithQuotaFeature.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByINodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.Batched;
                }
            }
            throw new IllegalStateException();
        }
    }
}

