/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.hadoop.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.EncryptionZoneDataAccess;
import io.hops.metadata.hdfs.entity.EncryptionZone;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionZoneManager {
    public static Logger LOG = LoggerFactory.getLogger(EncryptionZoneManager.class);
    private final FSDirectory dir;
    private final int maxListEncryptionZonesResponses;

    public EncryptionZoneManager(FSDirectory dir, Configuration conf) {
        this.dir = dir;
        this.maxListEncryptionZonesResponses = conf.getInt("dfs.namenode.list.encryption.zones.num.responses", 100);
        Preconditions.checkArgument((this.maxListEncryptionZonesResponses >= 0 ? 1 : 0) != 0, (Object)"dfs.namenode.list.encryption.zones.num.responses must be a positive integer.");
    }

    void addEncryptionZone(Long inodeId, CipherSuite suite, CryptoProtocolVersion version, String keyName) throws TransactionContextException, StorageException {
        this.unprotectedAddEncryptionZone(inodeId, suite, version, keyName);
    }

    void unprotectedAddEncryptionZone(Long inodeId, CipherSuite suite, CryptoProtocolVersion version, String keyName) throws TransactionContextException, StorageException {
        HdfsProtos.ZoneEncryptionInfoProto proto = PBHelper.convert(suite, version, keyName);
        EntityManager.add((Object)new EncryptionZone(inodeId.longValue(), proto.toByteArray()));
    }

    void removeEncryptionZone(Long inodeId) throws StorageException, TransactionContextException {
        EncryptionZone ez = (EncryptionZone)EntityManager.find((FinderType)EncryptionZone.Finder.ByPrimaryKeyInContext, (Object[])new Object[]{inodeId});
        if (ez != null) {
            EntityManager.remove((Object)ez);
        }
    }

    boolean isInAnEZ(INodesInPath iip) throws UnresolvedLinkException, TransactionContextException, StorageException, InvalidProtocolBufferException {
        return this.getEncryptionZoneForPath(iip) != null;
    }

    private String getFullPathName(EncryptionZoneInt ezi) throws IOException {
        return this.dir.getInode(ezi.getINodeId()).getFullPathName();
    }

    String getKeyName(INodesInPath iip) throws TransactionContextException, StorageException, InvalidProtocolBufferException {
        EncryptionZoneInt ezi = this.getEncryptionZoneForPath(iip);
        if (ezi == null) {
            return null;
        }
        return ezi.getKeyName();
    }

    private EncryptionZoneInt getEncryptionZoneForPath(INodesInPath iip) throws TransactionContextException, StorageException, InvalidProtocolBufferException {
        Preconditions.checkNotNull((Object)iip);
        List<INode> inodes = iip.getReadOnlyINodes();
        for (int i = inodes.size() - 1; i >= 0; --i) {
            EncryptionZone ez;
            INode inode = inodes.get(i);
            if (inode == null || (ez = (EncryptionZone)EntityManager.find((FinderType)EncryptionZone.Finder.ByPrimaryKeyInContext, (Object[])new Object[]{inode.getId()})) == null || ez.getZoneInfo() == null) continue;
            HdfsProtos.ZoneEncryptionInfoProto proto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(ez.getZoneInfo());
            return new EncryptionZoneInt(inode.getId(), PBHelper.convert(proto.getSuite()), PBHelper.convert(proto.getCryptoProtocolVersion()), proto.getKeyName());
        }
        return null;
    }

    org.apache.hadoop.hdfs.protocol.EncryptionZone getEZINodeForPath(INodesInPath iip) throws IOException {
        EncryptionZoneInt ezi = this.getEncryptionZoneForPath(iip);
        if (ezi == null) {
            return null;
        }
        return new org.apache.hadoop.hdfs.protocol.EncryptionZone(ezi.getINodeId(), this.getFullPathName(ezi), ezi.getSuite(), ezi.getVersion(), ezi.getKeyName());
    }

    void checkMoveValidity(INodesInPath srcIIP, INodesInPath dstIIP, String src) throws IOException {
        boolean dstInEZ;
        EncryptionZoneInt srcEZI = this.getEncryptionZoneForPath(srcIIP);
        EncryptionZoneInt dstEZI = this.getEncryptionZoneForPath(dstIIP);
        boolean srcInEZ = srcEZI != null;
        boolean bl = dstInEZ = dstEZI != null;
        if (srcInEZ) {
            if (!dstInEZ) {
                if (srcEZI.getINodeId() == srcIIP.getLastINode().getId()) {
                    return;
                }
                throw new IOException(src + " can't be moved from an encryption zone.");
            }
        } else if (dstInEZ) {
            throw new IOException(src + " can't be moved into an encryption zone.");
        }
        if (srcInEZ || dstInEZ) {
            Preconditions.checkState((srcEZI != null ? 1 : 0) != 0, (Object)"couldn't find src EZ?");
            Preconditions.checkState((dstEZI != null ? 1 : 0) != 0, (Object)"couldn't find dst EZ?");
            if (srcEZI.getINodeId() != dstEZI.getINodeId()) {
                String srcEZPath = this.getFullPathName(srcEZI);
                String dstEZPath = this.getFullPathName(dstEZI);
                StringBuilder sb = new StringBuilder(src);
                sb.append(" can't be moved from encryption zone ");
                sb.append(srcEZPath);
                sb.append(" to encryption zone ");
                sb.append(dstEZPath);
                sb.append(".");
                throw new IOException(sb.toString());
            }
        }
    }

    XAttr createEncryptionZone(String src, CipherSuite suite, CryptoProtocolVersion version, String keyName) throws IOException {
        INodesInPath srcIIP = this.dir.getINodesInPath4Write(src, false);
        if (this.dir.isNonEmptyDirectory(srcIIP)) {
            throw new IOException("Attempt to create an encryption zone for a non-empty directory.");
        }
        if (srcIIP != null && srcIIP.getLastINode() != null && !srcIIP.getLastINode().isDirectory()) {
            throw new IOException("Attempt to create an encryption zone for a file.");
        }
        EncryptionZoneInt ezi = this.getEncryptionZoneForPath(srcIIP);
        if (ezi != null) {
            throw new IOException("Directory " + src + " is already in an encryption zone. (" + this.getFullPathName(ezi) + ")");
        }
        HdfsProtos.ZoneEncryptionInfoProto proto = PBHelper.convert(suite, version, keyName);
        XAttr ezXAttr = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", proto.toByteArray());
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(ezXAttr);
        FSDirXAttrOp.unprotectedSetXAttrs(this.dir, src, xattrs, EnumSet.of(XAttrSetFlag.CREATE));
        return ezXAttr;
    }

    BatchedRemoteIterator.BatchedListEntries<org.apache.hadoop.hdfs.protocol.EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        List list = (List)new LightWeightRequestHandler(HDFSOperationType.GET_ALL_EZ){

            public Object performTask() throws IOException {
                EncryptionZoneDataAccess da = (EncryptionZoneDataAccess)HdfsStorageFactory.getDataAccess(EncryptionZoneDataAccess.class);
                return da.getAll();
            }
        }.handle();
        Collections.sort(list);
        int numResponses = Math.min(this.maxListEncryptionZonesResponses, list.size());
        final ArrayList zones = Lists.newArrayListWithExpectedSize((int)numResponses);
        int count = 0;
        int passed = 0;
        for (final EncryptionZone ez : list) {
            if (ez.getInodeId() <= prevId) {
                ++passed;
                continue;
            }
            boolean added = (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.LIST_EZ){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, ez.getInodeId());
                    locks.add((Lock)il);
                    locks.add(lf.getEZLock());
                }

                public Object performTask() throws IOException {
                    String pathName = EncryptionZoneManager.this.dir.getInode(ez.getInodeId()).getFullPathName();
                    INodesInPath iip = EncryptionZoneManager.this.dir.getINodesInPath(pathName, false);
                    INode lastINode = iip.getLastINode();
                    if (lastINode == null || lastINode.getId() != ez.getInodeId()) {
                        return false;
                    }
                    HdfsProtos.ZoneEncryptionInfoProto proto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(ez.getZoneInfo());
                    zones.add(new org.apache.hadoop.hdfs.protocol.EncryptionZone(ez.getInodeId(), pathName, PBHelper.convert(proto.getSuite()), PBHelper.convert(proto.getCryptoProtocolVersion()), proto.getKeyName()));
                    return true;
                }
            }.handle();
            if (!added || ++count < numResponses) continue;
            break;
        }
        boolean hasMore = numResponses < list.size() - passed;
        return new BatchedRemoteIterator.BatchedListEntries<org.apache.hadoop.hdfs.protocol.EncryptionZone>(zones, hasMore);
    }

    private static class EncryptionZoneInt {
        private final long inodeId;
        private final CipherSuite suite;
        private final CryptoProtocolVersion version;
        private final String keyName;

        EncryptionZoneInt(long inodeId, CipherSuite suite, CryptoProtocolVersion version, String keyName) {
            Preconditions.checkArgument((suite != CipherSuite.UNKNOWN ? 1 : 0) != 0);
            Preconditions.checkArgument((version != CryptoProtocolVersion.UNKNOWN ? 1 : 0) != 0);
            this.inodeId = inodeId;
            this.suite = suite;
            this.version = version;
            this.keyName = keyName;
        }

        long getINodeId() {
            return this.inodeId;
        }

        CipherSuite getSuite() {
            return this.suite;
        }

        CryptoProtocolVersion getVersion() {
            return this.version;
        }

        String getKeyName() {
            return this.keyName;
        }
    }
}

