/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.hops.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hadoop.shaded.com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

class JsonUtilClient {
    static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];

    JsonUtilClient() {
    }

    static RemoteException toRemoteException(Map<?, ?> json) {
        Map m = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m.get("message");
        String javaClassName = (String)m.get("javaClassName");
        return new RemoteException(javaClassName, message);
    }

    static Token<? extends TokenIdentifier> toToken(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m.get("urlString"));
        return token;
    }

    static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m) throws IOException {
        return JsonUtilClient.toToken(m);
    }

    static FsPermission toFsPermission(String s, Boolean aclBit, Boolean encBit) {
        boolean eBit;
        FsPermission perm = new FsPermission(Short.parseShort(s, 8));
        boolean aBit = aclBit != null ? aclBit : false;
        boolean bl = eBit = encBit != null ? encBit : false;
        if (aBit || eBit) {
            return new FsPermissionExtension(perm, aBit, eBit);
        }
        return perm;
    }

    static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m.get("pathSuffix");
        WebHdfsConstants.PathType type = WebHdfsConstants.PathType.valueOf((String)m.get("type"));
        byte[] symlink = type != WebHdfsConstants.PathType.SYMLINK ? null : DFSUtilClient.string2Bytes((String)m.get("symlink"));
        long len = ((Number)m.get("length")).longValue();
        String owner = (String)m.get("owner");
        String group = (String)m.get("group");
        FsPermission permission = JsonUtilClient.toFsPermission((String)m.get("permission"), (Boolean)m.get("aclBit"), (Boolean)m.get("encBit"));
        long aTime = ((Number)m.get("accessTime")).longValue();
        long mTime = ((Number)m.get("modificationTime")).longValue();
        long blockSize = ((Number)m.get("blockSize")).longValue();
        short replication = ((Number)m.get("replication")).shortValue();
        long fileId = m.containsKey("fileId") ? ((Number)m.get("fileId")).longValue() : 0L;
        int childrenNum = JsonUtilClient.getInt(m, "childrenNum", -1);
        byte storagePolicy = m.containsKey("storagePolicy") ? (byte)((Number)m.get("storagePolicy")).longValue() : (byte)0;
        return new HdfsFileStatus(len, type == WebHdfsConstants.PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtilClient.string2Bytes(localName), fileId, childrenNum, null, storagePolicy);
    }

    static ExtendedBlock toExtendedBlock(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        String blockPoolId = (String)m.get("blockPoolId");
        long blockId = ((Number)m.get("blockId")).longValue();
        long numBytes = ((Number)m.get("numBytes")).longValue();
        long generationStamp = ((Number)m.get("generationStamp")).longValue();
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static int getInt(Map<?, ?> m, String key, int defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    static long getLong(Map<?, ?> m, String key, long defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    static String getString(Map<?, ?> m, String key, String defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    static List<?> getList(Map<?, ?> m, String key) {
        Object list = m.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        String ipAddr = JsonUtilClient.getString(m, "ipAddr", null);
        int xferPort = JsonUtilClient.getInt(m, "xferPort", -1);
        if (ipAddr == null) {
            String name = JsonUtilClient.getString(m, "name", null);
            if (name == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo(ipAddr, (String)m.get("hostName"), (String)m.get("storageID"), xferPort, ((Number)m.get("infoPort")).intValue(), JsonUtilClient.getInt(m, "infoSecurePort", 0), ((Number)m.get("ipcPort")).intValue(), JsonUtilClient.getLong(m, "capacity", 0L), JsonUtilClient.getLong(m, "dfsUsed", 0L), JsonUtilClient.getLong(m, "remaining", 0L), JsonUtilClient.getLong(m, "blockPoolUsed", 0L), JsonUtilClient.getLong(m, "cacheCapacity", 0L), JsonUtilClient.getLong(m, "cacheUsed", 0L), JsonUtilClient.getLong(m, "lastUpdate", 0L), JsonUtilClient.getLong(m, "lastUpdateMonotonic", 0L), JsonUtilClient.getInt(m, "xceiverCount", 0), JsonUtilClient.getString(m, "networkLocation", ""), DatanodeInfo.AdminStates.valueOf(JsonUtilClient.getString(m, "adminState", "NORMAL")));
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    static DatanodeInfo[] toDatanodeInfoArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = JsonUtilClient.toDatanodeInfo((Map)object);
        }
        return array;
    }

    static LocatedBlock toLocatedBlock(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        ExtendedBlock b = JsonUtilClient.toExtendedBlock((Map)m.get("block"));
        DatanodeInfo[] locations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m, "locations"));
        long startOffset = ((Number)m.get("startOffset")).longValue();
        boolean isCorrupt = (Boolean)m.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m, "cachedLocations"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, null, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtilClient.toBlockToken((Map)m.get("blockToken")));
        return locatedblock;
    }

    static List<LocatedBlock> toLocatedBlockList(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.size());
        for (Object object : objects) {
            list.add(JsonUtilClient.toLocatedBlock((Map)object));
        }
        return list;
    }

    static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = ((Number)m.get("length")).longValue();
        long fileCount = ((Number)m.get("fileCount")).longValue();
        long directoryCount = ((Number)m.get("directoryCount")).longValue();
        long quota = ((Number)m.get("quota")).longValue();
        long spaceConsumed = ((Number)m.get("spaceConsumed")).longValue();
        long spaceQuota = ((Number)m.get("spaceQuota")).longValue();
        return new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
    }

    static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32FileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m.get("algorithm");
        int length = ((Number)m.get("length")).intValue();
        byte[] bytes = StringUtils.hexStringToByte((String)m.get("bytes"));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName(algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields(in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m.get("owner"));
        aclStatusBuilder.group((String)m.get("group"));
        aclStatusBuilder.stickyBit((Boolean)m.get("stickyBit"));
        String permString = (String)m.get("permission");
        if (permString != null) {
            FsPermission permission = JsonUtilClient.toFsPermission(permString, (Boolean)m.get("aclBit"), (Boolean)m.get("encBit"));
            aclStatusBuilder.setPermission(permission);
        }
        List entries = (List)m.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (Object entry : entries) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)entry, true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtilClient.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtilClient.toXAttrMap(JsonUtilClient.getList(json, "XAttrs"));
    }

    static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        ObjectReader reader = new ObjectMapper().reader(List.class);
        List xattrs = (List)reader.readValue(namesInJson);
        ArrayList names = Lists.newArrayListWithCapacity((int)json.keySet().size());
        for (Object xattr : xattrs) {
            names.add((String)xattr);
        }
        return names;
    }

    static Map<String, byte[]> toXAttrMap(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap xAttrs = Maps.newHashMap();
        for (Object object : objects) {
            Map m = (Map)object;
            String name = (String)m.get("name");
            String value = (String)m.get("value");
            xAttrs.put(name, JsonUtilClient.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue(value);
        }
        return new byte[0];
    }

    static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m = (Map)json.get(Token.class.getSimpleName());
        return JsonUtilClient.toToken(m);
    }

    static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = ((Number)m.get("fileLength")).longValue();
        boolean isUnderConstruction = (Boolean)m.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtilClient.toLocatedBlockList(JsonUtilClient.getList(m, "locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtilClient.toLocatedBlock((Map)m.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete, null);
    }
}

