/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.hadoop.shaded.org.apache.log4j.Logger;
import io.hops.leaderElection.LEContext;
import io.hops.leaderElection.LeaderElection;
import io.hops.leaderElection.LeaderElectionRole;
import io.hops.leaderElection.VarsRegister;
import io.hops.leaderElection.exception.LEWeakLocks;
import io.hops.leaderElection.exception.LeaderElectionForceAbort;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.ActiveNodePBImpl;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.LeaderOperationType;
import io.hops.transaction.handler.LeaderTransactionalRequestHandler;
import io.hops.transaction.lock.LeLockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class LETransaction {
    private static final Logger LOG = Logger.getLogger(LETransaction.class);
    private LEContext context;
    private TransactionLockTypes.LockType txLockType = null;
    private List<LeDescriptor> sortedList = null;
    private LeDescriptorFactory leFactory;

    private void LETransaction() {
    }

    protected LEContext doTransaction(final LeDescriptorFactory lef, final LEContext currentContext, final boolean relinquishCurrentId, final LeaderElection le) throws IOException {
        LeaderTransactionalRequestHandler leaderElectionHandler = new LeaderTransactionalRequestHandler(LeaderOperationType.LEADER_ELECTION){

            @Override
            public void preTransactionSetup() throws IOException {
                LETransaction.this.sortedList = null;
                LETransaction.this.leFactory = lef;
                super.preTransactionSetup();
                LETransaction.this.context = new LEContext(currentContext, lef);
                ((LETransaction)LETransaction.this).context.removedNodes.clear();
                if (relinquishCurrentId) {
                    ((LETransaction)LETransaction.this).context.id = -1L;
                }
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LeLockFactory lockFactory = LeLockFactory.getInstance();
                if (currentContext.id == -1L || currentContext.role == LeaderElectionRole.Role.LEADER || currentContext.nextTimeTakeStrongerLocks) {
                    locks.add(lockFactory.getLeVarsLock(LETransaction.this.leFactory.getVarsFinder(), TransactionLockTypes.LockType.WRITE)).add(lockFactory.getLeDescriptorLock(LETransaction.this.leFactory, TransactionLockTypes.LockType.READ_COMMITTED));
                    LETransaction.this.txLockType = TransactionLockTypes.LockType.WRITE;
                } else {
                    locks.add(lockFactory.getLeVarsLock(LETransaction.this.leFactory.getVarsFinder(), TransactionLockTypes.LockType.READ)).add(lockFactory.getLeDescriptorLock(LETransaction.this.leFactory, TransactionLockTypes.LockType.READ_COMMITTED));
                    LETransaction.this.txLockType = TransactionLockTypes.LockType.READ;
                }
            }

            public Object performTask() throws IOException {
                if (((LETransaction)LETransaction.this).context.nextTimeTakeStrongerLocks) {
                    ((LETransaction)LETransaction.this).context.nextTimeTakeStrongerLocks = false;
                }
                if (VarsRegister.getTimePeriod(LETransaction.this.leFactory.getVarsFinder()) == 0L) {
                    VarsRegister.setTimePeriod(LETransaction.this.leFactory.getVarsFinder(), ((LETransaction)LETransaction.this).context.time_period);
                } else {
                    ((LETransaction)LETransaction.this).context.time_period = VarsRegister.getTimePeriod(LETransaction.this.leFactory.getVarsFinder());
                }
                if (((LETransaction)LETransaction.this).context.init_phase) {
                    LETransaction.this.initPhase();
                } else {
                    LETransaction.this.periodicUpdate();
                }
                if (!le.isRunning()) {
                    throw new LeaderElectionForceAbort("Aborting the transaction because the parent thread has stopped");
                }
                return new Boolean(true);
            }
        };
        Boolean retVal = (Boolean)leaderElectionHandler.handle(null);
        if (retVal != null && retVal.equals(true)) {
            return this.context;
        }
        return null;
    }

    private void initPhase() throws IOException {
        LOG.debug((Object)("LE Status: id " + this.context.id + " Executing initial phase of the protocol. "));
        try {
            this.updateCounter();
            this.context.init_phase = false;
        }
        catch (LEWeakLocks wl) {
            this.context.nextTimeTakeStrongerLocks = true;
            LOG.info((Object)("LE Status: id " + this.context.id + " initPhase Stronger locks requested in next round"));
        }
    }

    private void periodicUpdate() throws IOException {
        try {
            this.updateCounter();
            this.leaderCheck();
            this.increaseTimePeriod();
            this.membershipMgm();
        }
        catch (LEWeakLocks wl) {
            this.context.nextTimeTakeStrongerLocks = true;
            LOG.info((Object)("LE Status: id " + this.context.id + " periodic update. Stronger locks requested in next round"));
        }
        this.appendHistory();
        this.context.last_hb_time = System.currentTimeMillis();
    }

    protected void updateCounter() throws IOException, LEWeakLocks {
        if (this.descriptorExists(this.context.id)) {
            this.incrementCounter();
        } else {
            if (this.txLockType == TransactionLockTypes.LockType.READ) {
                String msg = "LE Status: id " + this.context.id + " Id not found. I have shared locks. Retry with stronger lock";
                LOG.info((Object)msg);
                throw new LEWeakLocks(msg);
            }
            if (this.txLockType == TransactionLockTypes.LockType.WRITE) {
                long oldId = this.context.id;
                this.context.id = this.getNewNamenondeID();
                LeDescriptor newDescriptor = this.leFactory.getNewDescriptor(this.context.id, 0L, this.context.rpc_addresses, this.context.http_address, this.context.locationDomainId);
                EntityManager.add((Object)newDescriptor);
                if (oldId != -1L) {
                    LOG.warn((Object)("LE Status: id " + this.context.id + " I was kicked out. Old Id was " + oldId));
                    this.setEvictionFlag();
                }
            } else {
                String msg = "LE Status: id " + this.context.id + " lock type not supported. Got " + this.txLockType + " lock";
                LOG.error((Object)msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    private boolean descriptorExists(long processId) throws TransactionContextException, StorageException {
        LeDescriptor descriptor = this.getDescriptor(processId);
        return descriptor != null;
    }

    private LeDescriptor getDescriptor(long process_id) throws TransactionContextException, StorageException {
        LeDescriptor descriptor = (LeDescriptor)EntityManager.find((FinderType)this.leFactory.getByIdFinder(), (Object[])new Object[]{process_id, 0});
        return descriptor;
    }

    private long getNewNamenondeID() throws TransactionContextException, StorageException {
        long newId = VarsRegister.getMaxID(this.leFactory.getVarsFinder()) + 1L;
        VarsRegister.setMaxID(this.leFactory.getVarsFinder(), newId);
        return newId;
    }

    private void incrementCounter() throws IOException {
        LeDescriptor descriptor = this.getDescriptor(this.context.id);
        descriptor.setCounter(descriptor.getCounter() + 1L);
        EntityManager.add((Object)descriptor);
    }

    List<LeDescriptor> getAllSortedDescriptors() throws TransactionContextException, StorageException {
        if (this.sortedList == null) {
            this.sortedList = (List)EntityManager.findList((FinderType)this.leFactory.getAllFinder(), (Object[])new Object[0]);
            Collections.sort(this.sortedList);
        }
        return this.sortedList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void leaderCheck() throws IOException, LEWeakLocks {
        long smallestAliveProcess = this.getSmallestIdAliveProcess();
        if (smallestAliveProcess == this.context.id) {
            if (this.txLockType != TransactionLockTypes.LockType.WRITE) {
                String msg = "LE Status: id " + this.context.id + " I can be the leader but I have weak locks. Retry with stronger lock";
                LOG.info((Object)msg);
                throw new LEWeakLocks(msg);
            }
            if (this.context.role != LeaderElectionRole.Role.LEADER) {
                LOG.info((Object)("LE Status: id " + this.context.id + " I am the new LEADER. "));
            }
            this.context.role = LeaderElectionRole.Role.LEADER;
            this.removeDeadNameNodes();
            return;
        }
        if (this.context.role != LeaderElectionRole.Role.NON_LEADER || this.context.last_hb_time == 0L) {
            LOG.info((Object)("LE Status: id " + this.context.id + " I am a NON_LEADER process "));
        }
        this.context.role = LeaderElectionRole.Role.NON_LEADER;
        this.context.leader = smallestAliveProcess;
    }

    private long getSmallestIdAliveProcess() throws IOException {
        List<LeDescriptor> sortedList = this.getAllAliveProcesses();
        if (sortedList.size() > 0) {
            return sortedList.get(0).getId();
        }
        LOG.debug((Object)("LE Status: id " + this.context.id + " No namenodes in the system. The first process will be the leader"));
        return -1L;
    }

    private void removeDeadNameNodes() throws IOException {
        HashMap<Long, LeDescriptor> oldDescriptors = null;
        if (this.context.history.size() >= this.context.max_missed_hb_threshold) {
            oldDescriptors = this.context.history.get(0);
        }
        if (oldDescriptors == null) {
            return;
        }
        List<LeDescriptor> newDescriptors = this.getAllSortedDescriptors();
        for (LeDescriptor newDesc : newDescriptors) {
            LeDescriptor oldDesc = oldDescriptors.get(newDesc.getId());
            if (oldDesc == null || newDesc.getCounter() != oldDesc.getCounter()) continue;
            LOG.debug((Object)("LE Status: id " + this.context.id + " removing dead node " + oldDesc.getId()));
            this.removeLeaderRow(oldDesc);
            this.context.removedNodes.add(oldDesc);
        }
    }

    private void removeLeaderRow(LeDescriptor leader) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)leader);
    }

    private void membershipMgm() throws IOException {
        List<LeDescriptor> aliveList = this.getAllAliveProcesses();
        this.makeSortedActiveNodeList(aliveList);
    }

    private List<LeDescriptor> getAllAliveProcesses() throws IOException {
        ArrayList<LeDescriptor> aliveList = new ArrayList<LeDescriptor>();
        HashMap<Long, LeDescriptor> oldDescriptors = null;
        if (this.context.history.size() >= this.context.max_missed_hb_threshold) {
            oldDescriptors = this.context.history.get(0);
        }
        List<LeDescriptor> newDescriptors = this.getAllSortedDescriptors();
        if (oldDescriptors != null) {
            for (LeDescriptor newDesc : newDescriptors) {
                LeDescriptor oldDesc = oldDescriptors.get(newDesc.getId());
                if (oldDesc != null) {
                    if (newDesc.getCounter() <= oldDesc.getCounter()) continue;
                    aliveList.add(newDesc);
                    continue;
                }
                aliveList.add(newDesc);
            }
        } else {
            aliveList.addAll(newDescriptors);
        }
        return aliveList;
    }

    private void makeSortedActiveNodeList(List<LeDescriptor> nns) {
        ArrayList<ActiveNode> activeNameNodeList = new ArrayList<ActiveNode>();
        for (LeDescriptor l : nns) {
            String[] hostName = new String[]{"", ""};
            int[] port = new int[]{0, 0};
            String hostNameNPort = l.getRpcAddresses();
            StringTokenizer st = new StringTokenizer(hostNameNPort, ",");
            for (int i = 0; i < 2; ++i) {
                if (!st.hasMoreTokens()) continue;
                String address = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(address, ":");
                String intermediaryHostName = st2.nextToken();
                port[i] = Integer.parseInt(st2.nextToken());
                StringTokenizer st3 = new StringTokenizer(intermediaryHostName, "/");
                hostName[i] = st3.nextToken();
            }
            String httpAddress = l.getHttpAddress();
            ActiveNodePBImpl ann = new ActiveNodePBImpl(l.getId(), l.getRpcAddresses(), hostName[0], port[0], httpAddress, hostName[1], port[1], l.getLocationDomainId());
            activeNameNodeList.add(ann);
        }
        this.context.memberShip = new SortedActiveNodeListPBImpl(activeNameNodeList);
    }

    private void appendHistory() throws IOException {
        if (this.context.history.size() > 0 && this.context.history.size() >= this.context.max_missed_hb_threshold) {
            this.context.history.remove(0);
        }
        List<LeDescriptor> list = this.getAllSortedDescriptors();
        HashMap<Long, LeDescriptor> descriptors = new HashMap<Long, LeDescriptor>();
        for (LeDescriptor desc : list) {
            descriptors.put(desc.getId(), desc);
        }
        this.context.history.add(descriptors);
    }

    private void increaseTimePeriod() throws TransactionContextException, StorageException {
        if (VarsRegister.isEvict(this.leFactory.getVarsFinder()) && this.context.role == LeaderElectionRole.Role.LEADER && this.txLockType == TransactionLockTypes.LockType.WRITE) {
            long oldTP = this.context.time_period;
            this.context.time_period += this.context.time_period_increment;
            VarsRegister.setTimePeriod(this.leFactory.getVarsFinder(), this.context.time_period);
            LOG.warn((Object)("LE Status: id " + this.context.id + " I am LEADER and I am updating the time period. Old Tp: " + oldTP + " new TP: " + this.context.time_period));
            VarsRegister.setEvictFlag(this.leFactory.getVarsFinder(), false);
        }
    }

    private void setEvictionFlag() throws TransactionContextException, StorageException {
        VarsRegister.setEvictFlag(this.leFactory.getVarsFinder(), true);
    }

    public void forceLead(final long id) throws IOException {
        LeaderTransactionalRequestHandler leaderElectionHandler = new LeaderTransactionalRequestHandler(LeaderOperationType.LEADER_ELECTION){

            @Override
            public void preTransactionSetup() throws IOException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LeLockFactory lockFactory = LeLockFactory.getInstance();
                locks.add(lockFactory.getLeVarsLock(LETransaction.this.leFactory.getVarsFinder(), TransactionLockTypes.LockType.WRITE)).add(lockFactory.getLeDescriptorLock(LETransaction.this.leFactory, TransactionLockTypes.LockType.READ_COMMITTED));
            }

            public Object performTask() throws IOException {
                List descriptors = LETransaction.this.getAllAliveProcesses();
                for (LeDescriptor descriptor : descriptors) {
                    if (descriptor.getId() >= id) continue;
                    LETransaction.this.removeLeaderRow(descriptor);
                }
                return null;
            }
        };
        leaderElectionHandler.handle();
    }
}

