/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection.experiments;

import io.hops.hadoop.shaded.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import io.hops.leaderElection.experiments.Experiment1;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExperimentDriver {
    private Process process;
    private static final String JAR_FILE = "hops-leader-election-2.0.4-alpha-jar-with-dependencies.jar";
    private static final Log LOG = LogFactory.getLog(ExperimentDriver.class);

    public static void main(String[] argv) throws FileNotFoundException, IOException, InterruptedException {
        String experimentFile = "experiments_descriptions.txt";
        if (argv.length != 1) {
            System.out.println("Please specify the file containing experiment parameters ");
            System.out.println("Trying to read defaule file " + experimentFile);
        } else {
            experimentFile = argv[0];
        }
        new ExperimentDriver().runCommands(experimentFile);
    }

    private void runCommands(String file) throws FileNotFoundException, IOException, InterruptedException {
        String line;
        if (!new File(file).exists()) {
            LOG.error((Object)"File Does not exists");
            return;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(line, " ");
            int numProcesses = -1;
            String timeToRep = st.nextToken();
            int timesToRepeat = Integer.parseInt(timeToRep);
            line = line.substring(timeToRep.length(), line.length());
            String outputFileName = null;
            while (st.hasMoreElements()) {
                if (!st.nextElement().equals("-max_processes")) continue;
                numProcesses = Integer.parseInt(st.nextToken());
                outputFileName = numProcesses + ".log";
                break;
            }
            LOG.info((Object)("Going to repeat the experiment of " + timesToRepeat + " times"));
            for (int i = 0; i < timesToRepeat; ++i) {
                String command = line + " -output_file_path " + outputFileName;
                LOG.info((Object)("Driver going to run command " + command));
                this.runCommand(command);
            }
            LOG.info((Object)("Going to calculate points from file " + outputFileName));
            this.calculateNumbers(numProcesses, outputFileName);
        }
        br.close();
    }

    private void calculateNumbers(int numProcesses, String outputFileName) throws FileNotFoundException, IOException {
        String line;
        if (!new File(outputFileName).exists()) {
            LOG.error((Object)("File " + outputFileName + " does not exists"));
            return;
        }
        String marker = "DataPoints: ";
        DescriptiveStatistics failOverStats = new DescriptiveStatistics();
        DescriptiveStatistics tpStats = new DescriptiveStatistics();
        BufferedReader br = new BufferedReader(new FileReader(outputFileName));
        while ((line = br.readLine()) != null) {
            if (!line.startsWith(marker)) continue;
            boolean tpStatRecorded = false;
            String numbers = line.substring(marker.length(), line.length());
            StringTokenizer st = new StringTokenizer(numbers, ",[] ");
            while (st.hasMoreElements()) {
                double point = Double.parseDouble(st.nextToken());
                if (!tpStatRecorded) {
                    tpStats.addValue(point);
                    tpStatRecorded = true;
                    continue;
                }
                failOverStats.addValue(point);
            }
        }
        br.close();
        this.writeMessageToFile(numProcesses, failOverStats, tpStats);
    }

    public void writeMessageToFile(int numProcesses, DescriptiveStatistics failOverStats, DescriptiveStatistics tpStats) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("summary.log", true)));
        out.println(numProcesses + " " + tpStats.getN() + " " + tpStats.getMin() + " " + tpStats.getMax() + " " + tpStats.getMean() + " " + tpStats.getStandardDeviation() + " " + tpStats.getStandardDeviation() / Math.sqrt(tpStats.getN()) + " " + failOverStats.getN() + " " + failOverStats.getMin() + " " + failOverStats.getMax() + " " + failOverStats.getMean() + " " + failOverStats.getStandardDeviation() + " " + failOverStats.getStandardDeviation() / Math.sqrt(failOverStats.getN()));
        out.close();
    }

    private void runCommand(String args) throws IOException, InterruptedException {
        this.process = Runtime.getRuntime().exec(this.makeCommand(args));
        if (this.process == null) {
            LOG.error((Object)("Failed to run experiment. Argv " + args));
        } else {
            new StreamGobbler(this.process.getInputStream()).start();
            new StreamGobbler(this.process.getErrorStream()).start();
            LOG.error((Object)("Process exited. Value " + this.process.waitFor()));
        }
    }

    private String makeCommand(String args) {
        String dir = System.getProperty("user.dir");
        String jarFile = dir + File.separator + "target" + File.separator + JAR_FILE;
        if (!new File(jarFile).exists()) {
            jarFile = Experiment1.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        String command = "java -Xmx10000m -cp " + jarFile + " Experiment1 " + args;
        LOG.error((Object)command);
        return command;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

