/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import io.hops.hadoop.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpGet;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpUriRequest;
import io.hops.hadoop.shaded.org.apache.http.conn.HttpClientConnectionManager;
import io.hops.hadoop.shaded.org.apache.http.impl.client.CloseableHttpClient;
import io.hops.hadoop.shaded.org.apache.http.impl.client.HttpClients;
import io.hops.hadoop.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import io.hops.leader_election.watchdog.AliveWatchdogPoller;
import io.hops.leader_election.watchdog.HttpUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class HttpPageNotFoundPoller
implements AliveWatchdogPoller {
    private static final Log LOG = LogFactory.getLog(HttpPageNotFoundPoller.class);
    private static final int MAX_CONNECTIONS_PER_ROUTE = 20;
    private Configuration conf;
    private HttpGet request;
    private PoolingHttpClientConnectionManager httpConnectionManager;
    private CloseableHttpClient httpClient;

    @Override
    public Boolean shouldIBeAlive() throws Exception {
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.request);){
            Boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
    }

    @Override
    public void init() throws Exception {
        String url = this.conf.get("hops.alive-watchdog.http-poll.url");
        if (url == null) {
            String msg = "Alive watchdog HTTP poller url is empty. Make sure you have set hops.alive-watchdog.http-poll.url";
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        URI endpoint = new URI(url);
        this.request = new HttpGet(endpoint);
        this.httpConnectionManager = HttpUtils.createHTTPConnectionManager(this.conf, 20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
    }

    @Override
    public void destroy() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

