/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import io.hops.common.CountersQueue;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.hadoop.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.hops.hadoop.shaded.org.apache.commons.io.output.ByteArrayOutputStream;
import io.hops.leaderElection.VarsRegister;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.Variables;
import io.hops.metadata.common.entity.ArrayVariable;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class HdfsVariables {
    private static final Log LOG = LogFactory.getLog(HdfsVariables.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object handleVariable(Handler handler, boolean writeLock) throws StorageException {
        VariableDataAccess vd = (VariableDataAccess)HdfsStorageFactory.getDataAccess(VariableDataAccess.class);
        boolean insideActiveTransaction = HdfsStorageFactory.getConnector().isTransactionActive();
        if (!insideActiveTransaction) {
            HdfsStorageFactory.getConnector().beginTransaction();
        }
        if (writeLock) {
            HdfsStorageFactory.getConnector().writeLock();
        } else {
            HdfsStorageFactory.getConnector().readLock();
        }
        try {
            Object response;
            Object object = response = handler.handle((VariableDataAccess<Variable, Variable.Finder>)vd);
            return object;
        }
        finally {
            if (!insideActiveTransaction && HdfsStorageFactory.getConnector().isTransactionActive()) {
                HdfsStorageFactory.getConnector().commit();
            } else {
                HdfsStorageFactory.getConnector().readCommitted();
            }
        }
    }

    private static Object handleVariableWithReadLock(Handler handler) throws StorageException {
        return HdfsVariables.handleVariable(handler, false);
    }

    private static Object handleVariableWithWriteLock(Handler handler) throws StorageException {
        return HdfsVariables.handleVariable(handler, true);
    }

    public static CountersQueue.Counter incrementBlockIdCounter(final long increment) throws IOException {
        return (CountersQueue.Counter)new LightWeightRequestHandler(HDFSOperationType.UPDATE_BLOCK_ID_COUNTER){

            public Object performTask() throws IOException {
                return HdfsVariables.incrementCounter(Variable.Finder.BlockID, increment);
            }
        }.handle();
    }

    public static CountersQueue.Counter incrementINodeIdCounter(final long increment) throws IOException {
        return (CountersQueue.Counter)new LightWeightRequestHandler(HDFSOperationType.UPDATE_INODE_ID_COUNTER){

            public Object performTask() throws IOException {
                return HdfsVariables.incrementCounter(Variable.Finder.INodeID, increment);
            }
        }.handle();
    }

    public static CountersQueue.Counter incrementQuotaUpdateIdCounter(final long increment) throws IOException {
        return (CountersQueue.Counter)new LightWeightRequestHandler(HDFSOperationType.UPDATE_INODE_ID_COUNTER){

            public Object performTask() throws IOException {
                return HdfsVariables.incrementCounter(Variable.Finder.QuotaUpdateID, increment);
            }
        }.handle();
    }

    public static CountersQueue.Counter incrementCacheDirectiveIdCounter(final int increment) throws IOException {
        return (CountersQueue.Counter)new LightWeightRequestHandler(HDFSOperationType.UPDATE_CACHE_DIRECTIVE_ID_COUNTER){

            public Object performTask() throws IOException {
                return HdfsVariables.incrementCounter(Variable.Finder.CacheDirectiveID, increment);
            }
        }.handle();
    }

    private static CountersQueue.Counter incrementCounter(final Variable.Finder finder, final long increment) throws StorageException {
        return (CountersQueue.Counter)HdfsVariables.handleVariableWithWriteLock(new Handler(){

            @Override
            public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                Variable variable = (Variable)vd.getVariable((Object)finder);
                if (variable instanceof IntVariable) {
                    assert (increment == (long)((int)increment));
                    int oldValue = ((IntVariable)vd.getVariable((Object)finder)).getValue();
                    int newValue = IntMath.checkedAdd((int)oldValue, (int)((int)increment));
                    vd.setVariable((Variable)new IntVariable(finder, newValue));
                    return new CountersQueue.Counter(oldValue, newValue);
                }
                if (variable instanceof LongVariable) {
                    long oldValue = ((LongVariable)variable).getValue() == null ? 0L : ((LongVariable)variable).getValue();
                    long newValue = LongMath.checkedAdd((long)oldValue, (long)increment);
                    vd.setVariable((Variable)new LongVariable(finder, newValue));
                    return new CountersQueue.Counter(oldValue, newValue);
                }
                throw new IllegalStateException("Cannot increment Variable of type " + variable.getClass().getSimpleName());
            }
        });
    }

    public static void resetMisReplicatedIndex() throws IOException {
        HdfsVariables.incrementMisReplicatedIndex(0);
    }

    public static Long incrementMisReplicatedIndex(final int increment) throws IOException {
        return (Long)new LightWeightRequestHandler(HDFSOperationType.INCREMENT_MIS_REPLICATED_FILES_INDEX){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        LongVariable var = (LongVariable)vd.getVariable((Object)Variable.Finder.MisReplicatedFilesIndex);
                        long oldValue = var == null ? 0L : var.getValue();
                        long newValue = increment == 0 ? 0L : LongMath.checkedAdd((long)oldValue, (long)increment);
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.MisReplicatedFilesIndex, newValue));
                        return newValue;
                    }
                });
            }
        }.handle();
    }

    public static void setSafeModeInfo(final FSNamesystem.SafeModeInfo safeModeInfo, final long reached) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_SAFE_MODE_INFO){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.SafeModeReached, reached));
                        ArrayList<Number> vals = new ArrayList<Number>();
                        if (safeModeInfo != null) {
                            vals.add(safeModeInfo.getThreshold());
                            vals.add(safeModeInfo.getDatanodeThreshold());
                            vals.add(safeModeInfo.getExtension());
                            vals.add(safeModeInfo.getSafeReplication());
                            vals.add(safeModeInfo.getReplicationQueueThreshold());
                            vals.add(safeModeInfo.isResourcesLow() ? 0 : 1);
                        }
                        vd.setVariable((Variable)new ArrayVariable(Variable.Finder.SafeModeInfo, vals));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void exitSafeMode() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.EXIT_SAFE_MODE){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.SafeModeReached, -1L));
                        vd.setVariable((Variable)new ArrayVariable(Variable.Finder.SafeModeInfo, new ArrayList()));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void setSafeModeReached(final long reached) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_SAFE_MODE_REACHED){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.SafeModeReached, reached));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static long getSafeModeReached() throws IOException {
        return (Long)new LightWeightRequestHandler(HDFSOperationType.GET_SAFE_MODE_REACHED){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        LongVariable var = (LongVariable)vd.getVariable((Object)Variable.Finder.SafeModeReached);
                        return var.getValue() == null ? 0L : var.getValue();
                    }
                });
            }
        }.handle();
    }

    public static List<Object> getSafeModeFromDB() throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.GET_CLUSTER_SAFE_MODE){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        ArrayVariable var = (ArrayVariable)vd.getVariable((Object)Variable.Finder.SafeModeInfo);
                        return var.getVarsValue();
                    }
                });
            }
        }.handle();
    }

    public static void setMaxConcurrentBrs(final long value, Configuration conf) throws IOException {
        if (conf != null) {
            HdfsStorageFactory.setConfiguration(conf);
        }
        new LightWeightRequestHandler(HDFSOperationType.SET_BR_LB_MAX_CONCURRENT_BRS){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.BrLbMaxConcurrentBRs, value));
                        LOG.debug((Object)("Set block report max blocks per time window is : " + value));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static long getMaxConcurrentBrs() throws IOException {
        return (Long)new LightWeightRequestHandler(HDFSOperationType.GET_BR_LB_MAX_CONCURRENT_BRS){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        LongVariable var = (LongVariable)vd.getVariable((Object)Variable.Finder.BrLbMaxConcurrentBRs);
                        return var.getValue();
                    }
                });
            }
        }.handle();
    }

    public static void setReplicationIndex(List<Integer> indeces) throws StorageException, TransactionContextException {
        Variables.updateVariable((Variable)new ArrayVariable(Variable.Finder.ReplicationIndex, indeces));
    }

    public static List<Integer> getReplicationIndex() throws StorageException, TransactionContextException {
        return ((ArrayVariable)Variables.getVariable(Variable.Finder.ReplicationIndex)).getVarsValue();
    }

    public static void setStorageInfo(StorageInfo storageInfo) throws StorageException, TransactionContextException {
        ArrayList<Object> vals = new ArrayList<Object>();
        vals.add(storageInfo.getLayoutVersion());
        vals.add(storageInfo.getNamespaceID());
        vals.add(storageInfo.getClusterID());
        vals.add(storageInfo.getCTime());
        vals.add(storageInfo.getBlockPoolId());
        vals.add(storageInfo.getStorageType().name());
        Variables.updateVariable((Variable)new ArrayVariable(Variable.Finder.StorageInfo, vals));
    }

    public static StorageInfo getStorageInfo() throws StorageException, TransactionContextException {
        ArrayVariable var = (ArrayVariable)Variables.getVariable(Variable.Finder.StorageInfo);
        List vals = var.getVarsValue();
        if (vals.size() >= 6) {
            return new StorageInfo((Integer)vals.get(0), (Integer)vals.get(1), (String)vals.get(2), (Long)vals.get(3), HdfsServerConstants.NodeType.valueOf((String)vals.get(5)), (String)vals.get(4));
        }
        StorageInfo info = new StorageInfo((Integer)vals.get(0), (Integer)vals.get(1), (String)vals.get(2), (Long)vals.get(3), HdfsServerConstants.NodeType.NAME_NODE, (String)vals.get(4));
        HdfsVariables.setStorageInfo(info);
        return info;
    }

    public static void setRollingUpgradeInfo(RollingUpgradeInfo rollingUpgradeInfo) throws TransactionContextException, StorageException {
        if (rollingUpgradeInfo != null) {
            ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto = PBHelper.convert(rollingUpgradeInfo);
            byte[] array = proto.toByteArray();
            Variables.updateVariable((Variable)new ByteArrayVariable(Variable.Finder.RollingUpgradeInfo, proto.toByteArray()));
        } else {
            Variables.updateVariable((Variable)new ByteArrayVariable(Variable.Finder.RollingUpgradeInfo, null));
        }
    }

    public static RollingUpgradeInfo getRollingUpgradeInfo() throws TransactionContextException, StorageException, InvalidProtocolBufferException {
        ByteArrayVariable var = (ByteArrayVariable)Variables.getVariable(Variable.Finder.RollingUpgradeInfo);
        if (var == null) {
            return null;
        }
        byte[] value = (byte[])var.getValue();
        if (value.length == 0) {
            return null;
        }
        ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto = ClientNamenodeProtocolProtos.RollingUpgradeInfoProto.parseFrom((byte[])var.getValue());
        return PBHelper.convert(proto);
    }

    public static void updateBlockTokenKeys(BlockKey curr, BlockKey next) throws IOException {
        HdfsVariables.updateBlockTokenKeys(curr, next, null);
    }

    public static void updateBlockTokenKeys(BlockKey curr, BlockKey next, BlockKey simple) throws IOException {
        ArrayVariable arr = new ArrayVariable(Variable.Finder.BlockTokenKeys);
        arr.addVariable((Variable)HdfsVariables.serializeBlockKey(curr, Variable.Finder.BTCurrKey));
        arr.addVariable((Variable)HdfsVariables.serializeBlockKey(next, Variable.Finder.BTNextKey));
        if (simple != null) {
            arr.addVariable((Variable)HdfsVariables.serializeBlockKey(simple, Variable.Finder.BTSimpleKey));
        }
        Variables.updateVariable((Variable)arr);
    }

    public static Map<Integer, BlockKey> getAllBlockTokenKeysByID() throws IOException {
        return HdfsVariables.getAllBlockTokenKeys(true, false);
    }

    public static Map<Integer, BlockKey> getAllBlockTokenKeysByType() throws IOException {
        return HdfsVariables.getAllBlockTokenKeys(false, false);
    }

    public static Map<Integer, BlockKey> getAllBlockTokenKeysByIDLW() throws IOException {
        return HdfsVariables.getAllBlockTokenKeys(true, true);
    }

    public static Map<Integer, BlockKey> getAllBlockTokenKeysByTypeLW() throws IOException {
        return HdfsVariables.getAllBlockTokenKeys(false, true);
    }

    public static int getSIdCounter() throws StorageException, TransactionContextException {
        return (Integer)Variables.getVariable(Variable.Finder.SIdCounter).getValue();
    }

    public static void setSIdCounter(int sid) throws StorageException, TransactionContextException {
        Variables.updateVariable((Variable)new IntVariable(Variable.Finder.SIdCounter, sid));
    }

    private static Map<Integer, BlockKey> getAllBlockTokenKeys(boolean useKeyId, boolean leightWeight) throws IOException {
        List vars = (List)(leightWeight ? HdfsVariables.getVariableLightWeight(Variable.Finder.BlockTokenKeys).getValue() : Variables.getVariable(Variable.Finder.BlockTokenKeys).getValue());
        HashMap<Integer, BlockKey> keys = new HashMap<Integer, BlockKey>();
        for (Variable var : vars) {
            BlockKey key = HdfsVariables.deserializeBlockKey((ByteArrayVariable)var);
            int mapKey = useKeyId ? key.getKeyId() : key.getKeyType().ordinal();
            keys.put(mapKey, key);
        }
        return keys;
    }

    private static ByteArrayVariable serializeBlockKey(BlockKey key, Variable.Finder keyType) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)os);
        key.write(dos);
        dos.flush();
        return new ByteArrayVariable(keyType, os.toByteArray());
    }

    private static BlockKey deserializeBlockKey(ByteArrayVariable var) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream((byte[])var.getValue());
        DataInputStream dis = new DataInputStream(is);
        BlockKey key = new BlockKey();
        key.readFields(dis);
        switch (var.getType()) {
            case BTCurrKey: {
                key.setKeyType(BlockKey.KeyType.CurrKey);
                break;
            }
            case BTNextKey: {
                key.setKeyType(BlockKey.KeyType.NextKey);
                break;
            }
            case BTSimpleKey: {
                key.setKeyType(BlockKey.KeyType.SimpleKey);
            }
        }
        return key;
    }

    public static boolean getNeedRescan() throws StorageException, TransactionContextException, IOException {
        return (Boolean)new LightWeightRequestHandler(HDFSOperationType.GET_NEED_RESCAN){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        int neededScanCoun;
                        IntVariable var = (IntVariable)vd.getVariable((Object)Variable.Finder.completedScanCount);
                        int completedScanCount = 0;
                        if (var != null && var.getValue() != null) {
                            completedScanCount = var.getValue();
                        }
                        return completedScanCount < (neededScanCoun = ((IntVariable)vd.getVariable((Object)Variable.Finder.neededScanCount)).getValue().intValue());
                    }
                });
            }
        }.handle();
    }

    public static void setNeedRescan() throws StorageException, TransactionContextException, IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_NEED_RESCAN){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable curScanVar = (IntVariable)vd.getVariable((Object)Variable.Finder.curScanCount);
                        int curScanCount = -1;
                        if (curScanVar != null && curScanVar.getValue() != null) {
                            curScanCount = curScanVar.getValue();
                        }
                        if (curScanCount >= 0) {
                            vd.setVariable((Variable)new IntVariable(Variable.Finder.neededScanCount, curScanCount + 1));
                        } else {
                            IntVariable completedScanVar = (IntVariable)vd.getVariable((Object)Variable.Finder.completedScanCount);
                            int completedScanCount = 0;
                            if (completedScanVar != null && completedScanVar.getValue() != null) {
                                completedScanCount = completedScanVar.getValue();
                            }
                            vd.setVariable((Variable)new IntVariable(Variable.Finder.neededScanCount, completedScanCount + 1));
                        }
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void setCompletedAndCurScanCount() throws StorageException, TransactionContextException, IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_NEED_RESCAN){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable curScanVar = (IntVariable)vd.getVariable((Object)Variable.Finder.curScanCount);
                        int curScanCount = -1;
                        if (curScanVar != null && curScanVar.getValue() != null) {
                            curScanCount = curScanVar.getValue();
                        }
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.completedScanCount, curScanCount));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.curScanCount, -1));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void setCurScanCount() throws StorageException, TransactionContextException, IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_NEED_RESCAN){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable var = (IntVariable)vd.getVariable((Object)Variable.Finder.completedScanCount);
                        int completedScanCount = 0;
                        if (var != null && var.getValue() != null) {
                            completedScanCount = var.getValue();
                        }
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.curScanCount, completedScanCount + 1));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static int getCurScanCount() throws StorageException, TransactionContextException, IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.SET_NEED_RESCAN){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable curScanVar = (IntVariable)vd.getVariable((Object)Variable.Finder.curScanCount);
                        int curScanCount = -1;
                        if (curScanVar != null && curScanVar.getValue() != null) {
                            curScanCount = curScanVar.getValue();
                        }
                        return curScanCount;
                    }
                });
            }
        }.handle();
    }

    public static void setBlockTotal(final int value) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_BLOCK_TOTAL){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockTotal, value));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockThreshold, 0));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockReplicationQueueThreshold, 0));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void setBlockTotal(final int blockTotal, final int blockThreshold, final int blockReplicationQueueThreshold) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_BLOCK_TOTAL){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockTotal, blockTotal));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockThreshold, blockThreshold));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockReplicationQueueThreshold, blockReplicationQueueThreshold));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static void updateBlockTotal(final int deltaBlockTotal, final double threshold, final double replicationQueueThreshold) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.SET_BLOCK_TOTAL){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable blockTotalVar = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockTotal);
                        int blockTotal = blockTotalVar.getValue();
                        IntVariable blockThresholdVar = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockThreshold);
                        int blockThreshold = blockThresholdVar.getValue();
                        IntVariable blockReplicationQueueThresholdVar = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockReplicationQueueThreshold);
                        int blockReplicationQueueThreshold = blockReplicationQueueThresholdVar.getValue();
                        assert (blockTotal + deltaBlockTotal >= 0) : "Can't reduce blockTotal " + blockTotal + " by " + deltaBlockTotal + ": would be negative";
                        int newBlockThreshold = (int)((double)blockTotal * threshold);
                        int newBlockReplicationQueueThreshold = (int)((double)blockTotal * replicationQueueThreshold);
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockTotal, blockTotal + deltaBlockTotal));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockThreshold, newBlockThreshold));
                        vd.setVariable((Variable)new IntVariable(Variable.Finder.BlockReplicationQueueThreshold, newBlockReplicationQueueThreshold));
                        int total = blockTotal + deltaBlockTotal;
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static int getBlockTotal() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.GET_BLOCK_TOTAL){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable var = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockTotal);
                        int result = 0;
                        if (var.getValue() != null) {
                            result = var.getValue();
                        }
                        return result;
                    }
                });
            }
        }.handle();
    }

    public static int getBlockThreshold() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.GET_BLOCK_THRESHOLD){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable var = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockThreshold);
                        int result = 0;
                        if (var.getValue() != null) {
                            result = var.getValue();
                        }
                        return result;
                    }
                });
            }
        }.handle();
    }

    public static long getRetryCacheCleanerEpoch() throws IOException {
        return (Long)new LightWeightRequestHandler(HDFSOperationType.GET_RETRY_CACHE_CLEANER_EPOCH){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        LongVariable var = (LongVariable)vd.getVariable((Object)Variable.Finder.RetryCacheCleanerEpoch);
                        long result = 0L;
                        if (var.getValue() != null) {
                            result = var.getValue();
                        }
                        return result;
                    }
                });
            }
        }.handle();
    }

    public static void setRetryCacheCleanerEpoch(final long epoch) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.GET_RETRY_CACHE_CLEANER_EPOCH){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithWriteLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        vd.setVariable((Variable)new LongVariable(Variable.Finder.RetryCacheCleanerEpoch, epoch));
                        return null;
                    }
                });
            }
        }.handle();
    }

    public static int getBlockReplicationQueueThreshold() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.GET_BLOCK_REPLICATION_QUEUE_THRESHOLD){

            public Object performTask() throws IOException {
                return HdfsVariables.handleVariableWithReadLock(new Handler(){

                    @Override
                    public Object handle(VariableDataAccess<Variable, Variable.Finder> vd) throws StorageException {
                        IntVariable var = (IntVariable)vd.getVariable((Object)Variable.Finder.BlockReplicationQueueThreshold);
                        int result = 0;
                        if (var.getValue() != null) {
                            result = var.getValue();
                        }
                        return result;
                    }
                });
            }
        }.handle();
    }

    private static Variable getVariableLightWeight(final Variable.Finder varType) throws IOException {
        return (Variable)new LightWeightRequestHandler(HDFSOperationType.GET_VARIABLE){

            public Object performTask() throws IOException {
                VariableDataAccess vd = (VariableDataAccess)HdfsStorageFactory.getDataAccess(VariableDataAccess.class);
                return vd.getVariable((Object)varType);
            }
        }.handle();
    }

    public static void registerDefaultValues(Configuration conf) {
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.BlockID, (byte[])new LongVariable(0L).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.INodeID, (byte[])new LongVariable(2L).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.ReplicationIndex, (byte[])new ArrayVariable(Arrays.asList(0, 0, 0, 0, 0)).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.SIdCounter, (byte[])new IntVariable(0).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.MisReplicatedFilesIndex, (byte[])new LongVariable(0L).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.SafeModeReached, (byte[])new IntVariable(-1).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.QuotaUpdateID, (byte[])new IntVariable(0).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.BrLbMaxConcurrentBRs, (byte[])new LongVariable(conf.getLong("dfs.block.report.load.balancer.max.concurrent.block.reports.per.nn", 1L)).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.CacheDirectiveID, (byte[])new LongVariable(1L).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.neededScanCount, (byte[])new IntVariable(0).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.completedScanCount, (byte[])new IntVariable(0).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.curScanCount, (byte[])new IntVariable(-1).getBytes());
        Variable.registerUserDefinedDefaultValue((Variable.Finder)Variable.Finder.RetryCacheCleanerEpoch, (byte[])new LongVariable(0L).getBytes());
        VarsRegister.registerHdfsDefaultValues();
        VarsRegister.registerYarnDefaultValues();
    }

    private static interface Handler {
        public Object handle(VariableDataAccess<Variable, Variable.Finder> var1) throws StorageException;
    }
}

