/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.leaderElection.LeaderElection;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Daemon;

public class MDCleaner {
    public static final Log LOG = LogFactory.getLog(MDCleaner.class);
    private boolean run = false;
    private LeaderElection leaderElection;
    private Daemon mdCleaner;
    private long failedSTOCleanDelay = 0L;
    private long slowSTOCleanDelay = 0L;
    private FSNamesystem namesystem;

    public static MDCleaner getInstance() {
        return new MDCleaner();
    }

    private void clearLocks() throws IOException {
        SortedActiveNodeList activeNodeList = this.leaderElection.getActiveNamenodes();
        if (activeNodeList.size() == 0) {
            return;
        }
        long[] aliveNNs = new long[activeNodeList.size()];
        for (int i = 0; i < activeNodeList.getActiveNodes().size(); ++i) {
            aliveNNs[i] = activeNodeList.getActiveNodes().get(i).getId();
        }
        Collection<SubTreeOperation> ops = this.getFailedPaths(aliveNNs, System.currentTimeMillis() - this.failedSTOCleanDelay);
        for (SubTreeOperation op : ops) {
            LOG.info((Object)("Cleaning dead STO lock. OP = {" + op + "}"));
            this.removeLock(op.getPath(), -1L);
        }
        ops = this.getSlowOpsPaths(aliveNNs, System.currentTimeMillis() - this.slowSTOCleanDelay);
        for (SubTreeOperation op : ops) {
            LOG.warn((Object)("Cleaning slow STO lock. OP = {" + op + "}"));
            this.removeLock(op.getPath(), -1L);
        }
        ops = this.getPathsToRecoverAsync();
        for (SubTreeOperation op : ops) {
            LOG.warn((Object)("Cleaning async STO lock. OP = {" + op + "}"));
            this.removeLock(op.getPath(), op.getInodeID());
        }
    }

    private void removeLock(String path, long ignoreInodeID) {
        try {
            this.namesystem.unlockSubtree(path, ignoreInodeID);
        }
        catch (IOException e) {
            LOG.info((Object)("Error while removing sub tree lock " + e));
        }
    }

    Collection<SubTreeOperation> getFailedPaths(final long[] nnIDs, final long time) throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler(HDFSOperationType.MDCLEANER_LIST_FAILED_OPS){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allDeadOperations(nnIDs, time);
            }
        };
        return (Collection)subTreeLockChecker.handle();
    }

    Collection<SubTreeOperation> getSlowOpsPaths(final long[] nnIDs, final long time) throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler(HDFSOperationType.MDCLEANER_LIST_SLOW_OPS){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allSlowActiveOperations(nnIDs, time);
            }
        };
        return (Collection)subTreeLockChecker.handle();
    }

    Collection<SubTreeOperation> getPathsToRecoverAsync() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler(HDFSOperationType.MDCLEANER_LIST_ASYNC_OPS){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allOpsToRecoverAsync();
            }
        };
        return (Collection)subTreeLockChecker.handle();
    }

    void startMDCleanerMonitor(FSNamesystem namesystem, LeaderElection leaderElection, long failedSTOCleanDelay, long slowSTOCleanDelay) {
        this.leaderElection = leaderElection;
        this.failedSTOCleanDelay = failedSTOCleanDelay;
        this.slowSTOCleanDelay = slowSTOCleanDelay;
        this.namesystem = namesystem;
        this.run = true;
        this.mdCleaner = new Daemon(new Monitor());
        this.mdCleaner.start();
    }

    void stopMDCleanerMonitor() {
        if (this.mdCleaner != null) {
            this.run = false;
            LOG.debug((Object)"Shutting down metadata cleaner ");
            try {
                this.mdCleaner.interrupt();
                this.mdCleaner.join(3000L);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Encountered exception ", (Throwable)ie);
            }
            this.mdCleaner = null;
        }
    }

    class Monitor
    implements Runnable {
        Monitor() {
        }

        @Override
        public void run() {
            while (MDCleaner.this.run) {
                try {
                    if (MDCleaner.this.leaderElection.isRunning() && MDCleaner.this.leaderElection.isLeader()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Cleaning dead locks. I am th leader ");
                        }
                        MDCleaner.this.clearLocks();
                    }
                }
                catch (IOException e) {
                    LOG.info((Object)("Eror in metadata cleaner " + e));
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Metadata Cleaner Interrupted");
                }
            }
        }
    }
}

