/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.tfile;

import io.hops.hadoop.shaded.org.apache.commons.math3.util.Pair;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationDFSException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.TFileAggregatedLogsBlock;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogAggregationTFileController
extends LogAggregationFileController {
    private static final Log LOG = LogFactory.getLog(LogAggregationTFileController.class);
    private AggregatedLogFormat.LogWriter writer;
    private TFileLogReader tfReader = null;

    @Override
    public void initInternal(Configuration conf) {
        this.remoteRootLogDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        this.remoteRootLogDirSuffix = conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
    }

    @Override
    public void initializeWriter(LogAggregationFileControllerContext context) throws IOException {
        this.writer = new AggregatedLogFormat.LogWriter();
        this.writer.initialize(this.conf, context.getRemoteNodeTmpLogFileForApp(), context.getUserUgi());
        this.writer.writeApplicationACLs(context.getAppAcls());
        this.writer.writeApplicationOwner(context.getUserUgi().getShortUserName());
    }

    @Override
    public void closeWriter() throws LogAggregationDFSException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (DSQuotaExceededException e) {
                throw new LogAggregationDFSException(e);
            }
            finally {
                this.writer = null;
            }
        }
    }

    @Override
    public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        this.writer.append(logKey, logValue);
    }

    @Override
    public void postWrite(final LogAggregationFileControllerContext record) throws Exception {
        if (record.isUploadedLogsInThisCycle() && record.isLogAggregationInRolling()) {
            this.cleanOldLogs(record.getRemoteNodeLogFileForApp(), record.getNodeId(), record.getUserUgi());
            record.increcleanupOldLogTimes();
        }
        this.closeWriter();
        final Path renamedPath = record.getRollingMonitorInterval() <= 0L ? record.getRemoteNodeLogFileForApp() : new Path(record.getRemoteNodeLogFileForApp().getParent(), record.getRemoteNodeLogFileForApp().getName() + "_" + record.getLogUploadTimeStamp());
        final boolean rename = record.isUploadedLogsInThisCycle();
        try {
            record.getUserUgi().doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem remoteFS = record.getRemoteNodeLogFileForApp().getFileSystem(LogAggregationTFileController.this.conf);
                    if (rename) {
                        remoteFS.rename(record.getRemoteNodeTmpLogFileForApp(), renamedPath);
                    } else {
                        remoteFS.delete(record.getRemoteNodeTmpLogFileForApp(), false);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to move temporary log file to final location: [" + record.getRemoteNodeTmpLogFileForApp() + "] to [" + renamedPath + "]"), (Throwable)e);
            throw new Exception("Log uploaded failed for Application: " + record.getAppId() + " in NodeManager: " + LogAggregationUtils.getNodeString(record.getNodeId()) + " at " + Times.format(record.getLogUploadTimeStamp()) + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) throws IOException {
        findLogs = false;
        createPrintStream = os == null;
        appId = logRequest.getAppId();
        nodeId = logRequest.getNodeId();
        logTypes = new ArrayList<String>();
        if (logRequest.getLogTypes() != null && !logRequest.getLogTypes().isEmpty()) {
            logTypes.addAll(logRequest.getLogTypes());
        }
        getAllContainers = (containerIdStr = logRequest.getContainerId()) == null || containerIdStr.isEmpty() != false;
        size = logRequest.getBytes();
        nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, logRequest.getAppOwner());
        buf = new byte[65535];
        block7: while (nodeFiles != null && nodeFiles.hasNext()) {
            thisNodeFile = nodeFiles.next();
            nodeName = thisNodeFile.getPath().getName();
            if (nodeName.equals(appId + ".har")) {
                p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                nodeFiles = HarFs.get(p.toUri(), this.conf).listStatusIterator(p);
                continue;
            }
            if (nodeId != null && !nodeName.contains(LogAggregationUtils.getNodeString(nodeId)) || nodeName.endsWith(".tmp")) continue;
            reader = null;
            try {
                reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());
                key = new AggregatedLogFormat.LogKey();
                valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr)) {
                        if (createPrintStream) {
                            os = LogToolUtils.createPrintStream(logRequest.getOutputLocalDir(), thisNodeFile.getPath().getName(), key.toString());
                        }
                        try {
                            try {
                                block9: while (true) {
                                    fileType = valueStream.readUTF();
                                    fileLengthStr = valueStream.readUTF();
                                    fileLength = Long.parseLong(fileLengthStr);
                                    if (logTypes == null || logTypes.isEmpty() || logTypes.contains(fileType)) {
                                        LogToolUtils.outputContainerLog(key.toString(), nodeName, fileType, fileLength, size, Times.format(thisNodeFile.getModificationTime()), valueStream, os, buf, ContainerLogAggregationType.AGGREGATED);
                                        b = this.aggregatedLogSuffix(fileType).getBytes(Charset.forName("UTF-8"));
                                        os.write(b, 0, b.length);
                                        findLogs = true;
                                        continue;
                                    }
                                    totalSkipped = 0L;
                                    currSkipped = 0L;
                                    while (true) {
                                        if (currSkipped != -1L && totalSkipped < fileLength) ** break;
                                        continue block9;
                                        currSkipped = valueStream.skip(fileLength - totalSkipped);
                                        totalSkipped += currSkipped;
                                    }
                                    break;
                                }
                            }
                            catch (EOFException eof) {
                                os.flush();
                                if (createPrintStream) {
                                    this.closePrintStream(os);
                                }
                            }
                        }
                        catch (Throwable var27_25) {
                            os.flush();
                            if (createPrintStream) {
                                this.closePrintStream(os);
                            }
                            throw var27_25;
                        }
                        if (!getAllContainers) continue block7;
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return findLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) throws IOException {
        ArrayList<ContainerLogMeta> containersLogMeta = new ArrayList<ContainerLogMeta>();
        String containerIdStr = logRequest.getContainerId();
        String nodeId = logRequest.getNodeId();
        ApplicationId appId = logRequest.getAppId();
        String appOwner = logRequest.getAppOwner();
        boolean getAllContainers = containerIdStr == null;
        String nodeIdStr = nodeId == null ? null : LogAggregationUtils.getNodeString(nodeId);
        RemoteIterator<FileStatus> nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, appOwner);
        if (nodeFiles == null) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        block5: while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = nodeFiles.next();
            if (thisNodeFile.getPath().getName().equals(appId + ".har")) {
                Path p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                nodeFiles = HarFs.get(p.toUri(), this.conf).listStatusIterator(p);
                continue;
            }
            if (nodeIdStr != null && !thisNodeFile.getPath().getName().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr)) {
                        ContainerLogMeta containerLogMeta = new ContainerLogMeta(key.toString(), thisNodeFile.getPath().getName());
                        try {
                            while (true) {
                                Pair<String, String> logMeta = AggregatedLogFormat.LogReader.readContainerMetaDataAndSkipData(valueStream);
                                containerLogMeta.addLogMeta((String)logMeta.getFirst(), (String)logMeta.getSecond(), Times.format(thisNodeFile.getModificationTime()));
                            }
                        }
                        catch (EOFException eof) {
                            containersLogMeta.add(containerLogMeta);
                            if (!getAllContainers) continue block5;
                        }
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        return containersLogMeta;
    }

    @Override
    public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        TFileAggregatedLogsBlock block = new TFileAggregatedLogsBlock(context, this.conf);
        block.render(html);
    }

    @Override
    public String getApplicationOwner(Path aggregatedLog, ApplicationId appId) throws IOException {
        this.createTFileLogReader(aggregatedLog);
        return this.tfReader.getLogReader().getApplicationOwner();
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLog, ApplicationId appId) throws IOException {
        this.createTFileLogReader(aggregatedLog);
        return this.tfReader.getLogReader().getApplicationAcls();
    }

    private void createTFileLogReader(Path aggregatedLog) throws IOException {
        if (this.tfReader == null || !this.tfReader.getAggregatedLogPath().equals(aggregatedLog)) {
            AggregatedLogFormat.LogReader logReader = new AggregatedLogFormat.LogReader(this.conf, aggregatedLog);
            this.tfReader = new TFileLogReader(logReader, aggregatedLog);
        }
    }

    private static class TFileLogReader {
        private AggregatedLogFormat.LogReader logReader;
        private Path aggregatedLogPath;

        TFileLogReader(AggregatedLogFormat.LogReader logReader, Path aggregatedLogPath) {
            this.setLogReader(logReader);
            this.setAggregatedLogPath(aggregatedLogPath);
        }

        public AggregatedLogFormat.LogReader getLogReader() {
            return this.logReader;
        }

        public void setLogReader(AggregatedLogFormat.LogReader logReader) {
            this.logReader = logReader;
        }

        public Path getAggregatedLogPath() {
            return this.aggregatedLogPath;
        }

        public void setAggregatedLogPath(Path aggregatedLogPath) {
            this.aggregatedLogPath = aggregatedLogPath;
        }
    }
}

