/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.ErasureCode;
import io.hops.hadoop.shaded.org.json.simple.JSONArray;
import io.hops.hadoop.shaded.org.json.simple.JSONObject;
import io.hops.hadoop.shaded.org.json.simple.parser.JSONParser;
import io.hops.hadoop.shaded.org.json.simple.parser.ParseException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;

public class Codec
implements Serializable {
    public static final Log LOG = LogFactory.getLog(Codec.class);
    public static final String ERASURE_CODE_KEY_PREFIX = "hdfs.raid.erasure.code.";
    public final JSONObject json;
    public final String id;
    public final int stripeLength;
    public final int parityLength;
    public final String erasureCodeClass;
    public final String description;
    public final String parityDirectory;
    public final int priority;
    private static List<Codec> codecs;
    private static Map<String, Codec> idToCodec;

    public static List<Codec> getCodecs() {
        return codecs;
    }

    public static Codec getCodec(String id) {
        return idToCodec.get(id);
    }

    public static void initializeCodecs(Configuration conf) throws IOException {
        try {
            String source = conf.get("dfs.erasure_coding.codecs.json");
            if (source == null) {
                codecs = Collections.emptyList();
                idToCodec = Collections.emptyMap();
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)"No codec is specified");
                }
                return;
            }
            JSONArray jsonArray = (JSONArray)new JSONParser().parse(source);
            ArrayList<Codec> localCodecs = new ArrayList<Codec>();
            HashMap<String, Codec> localIdToCodec = new HashMap<String, Codec>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Codec codec = new Codec((JSONObject)jsonArray.get(i));
                localIdToCodec.put(codec.id, codec);
                localCodecs.add(codec);
            }
            Collections.sort(localCodecs, new Comparator<Codec>(){

                @Override
                public int compare(Codec c1, Codec c2) {
                    return c2.priority - c1.priority;
                }
            });
            codecs = Collections.unmodifiableList(localCodecs);
            idToCodec = Collections.unmodifiableMap(localIdToCodec);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public Codec(JSONObject json) {
        this.json = json;
        this.id = (String)json.get((Object)"id");
        this.parityLength = ((Long)json.get((Object)"parity_length")).intValue();
        this.stripeLength = ((Long)json.get((Object)"stripe_length")).intValue();
        this.erasureCodeClass = (String)json.get((Object)"erasure_code");
        this.parityDirectory = (String)json.get((Object)"parity_dir");
        this.priority = ((Long)json.get((Object)"priority")).intValue();
        this.description = Codec.getJSONString(json, "description", "");
        this.checkDirectory(this.parityDirectory);
    }

    private void checkDirectory(String d) {
        if (!d.startsWith("/")) {
            throw new IllegalArgumentException("Bad directory:" + d);
        }
        if (d.endsWith("/")) {
            throw new IllegalArgumentException("Bad directory:" + d);
        }
    }

    private static String getJSONString(JSONObject json, String key, String defaultResult) {
        String result = defaultResult;
        result = (String)json.get((Object)key);
        return result;
    }

    public ErasureCode createErasureCode(Configuration conf) {
        Class<?> erasureCode = null;
        try {
            erasureCode = conf.getClass(ERASURE_CODE_KEY_PREFIX + this.id, conf.getClassByName(this.erasureCodeClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ErasureCode code = (ErasureCode)ReflectionUtils.newInstance(erasureCode, conf);
        code.init(this);
        return code;
    }

    public String toString() {
        if (this.json == null) {
            return "Test codec " + this.id;
        }
        return this.json.toString();
    }

    public String getParityPrefix() {
        String prefix = this.parityDirectory;
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    public int getStripeLength() {
        return this.stripeLength;
    }

    public int getParityLength() {
        return this.parityLength;
    }

    public String getId() {
        return this.id;
    }

    static {
        try {
            Configuration.addDefaultResource("hdfs-default.xml");
            Configuration.addDefaultResource("hdfs-site.xml");
            Configuration.addDefaultResource("erasure-coding-default.xml");
            Configuration.addDefaultResource("erasure-coding-site.xml");
            Codec.initializeCodecs(new Configuration());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize erasure coding codecs", e);
        }
    }
}

