/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.server.namenode.ScopedAclEntries;

@InterfaceAudience.Private
final class AclTransformation {
    private static final int MAX_ENTRIES = 32;
    static final Comparator<AclEntry> ACL_ENTRY_COMPARATOR = new Comparator<AclEntry>(){

        @Override
        public int compare(AclEntry entry1, AclEntry entry2) {
            return ComparisonChain.start().compare((Object)entry1.getScope(), (Object)entry2.getScope(), (Comparator)Ordering.explicit((Object)((Object)AclEntryScope.ACCESS), (Object[])new AclEntryScope[]{AclEntryScope.DEFAULT})).compare((Object)entry1.getType(), (Object)entry2.getType(), (Comparator)Ordering.explicit((Object)((Object)AclEntryType.USER), (Object[])new AclEntryType[]{AclEntryType.GROUP, AclEntryType.MASK, AclEntryType.OTHER})).compare((Object)entry1.getName(), (Object)entry2.getName(), (Comparator)Ordering.natural().nullsFirst()).result();
        }
    };

    public static List<AclEntry> filterAclEntriesByAclSpec(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry existingEntry : existingAcl) {
            if (aclSpec.containsKey(existingEntry)) {
                scopeDirty.add(existingEntry.getScope());
                if (existingEntry.getType() != AclEntryType.MASK) continue;
                maskDirty.add(existingEntry.getScope());
                continue;
            }
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> filterDefaultAclEntries(List<AclEntry> existingAcl) throws AclException {
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        for (AclEntry existingEntry : existingAcl) {
            if (existingEntry.getScope() == AclEntryScope.DEFAULT) break;
            aclBuilder.add(existingEntry);
        }
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> mergeAclEntries(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        ArrayList foundAclSpecEntries = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry existingEntry : existingAcl) {
            AclEntry aclSpecEntry = aclSpec.findByKey(existingEntry);
            if (aclSpecEntry != null) {
                foundAclSpecEntries.add(aclSpecEntry);
                scopeDirty.add(aclSpecEntry.getScope());
                if (aclSpecEntry.getType() == AclEntryType.MASK) {
                    providedMask.put(aclSpecEntry.getScope(), aclSpecEntry);
                    maskDirty.add(aclSpecEntry.getScope());
                    continue;
                }
                aclBuilder.add(aclSpecEntry);
                continue;
            }
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        for (AclEntry newEntry : aclSpec) {
            if (Collections.binarySearch(foundAclSpecEntries, newEntry, ACL_ENTRY_COMPARATOR) >= 0) continue;
            scopeDirty.add(newEntry.getScope());
            if (newEntry.getType() == AclEntryType.MASK) {
                providedMask.put(newEntry.getScope(), newEntry);
                maskDirty.add(newEntry.getScope());
                continue;
            }
            aclBuilder.add(newEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> replaceAclEntries(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry aclSpecEntry : aclSpec) {
            scopeDirty.add(aclSpecEntry.getScope());
            if (aclSpecEntry.getType() == AclEntryType.MASK) {
                providedMask.put(aclSpecEntry.getScope(), aclSpecEntry);
                maskDirty.add(aclSpecEntry.getScope());
                continue;
            }
            aclBuilder.add(aclSpecEntry);
        }
        for (AclEntry existingEntry : existingAcl) {
            if (scopeDirty.contains((Object)existingEntry.getScope())) continue;
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    private AclTransformation() {
    }

    private static List<AclEntry> buildAndValidateAcl(ArrayList<AclEntry> aclBuilder) throws AclException {
        if (aclBuilder.size() > 32) {
            throw new AclException("Invalid ACL: ACL has " + aclBuilder.size() + " entries, which exceeds maximum of " + 32 + ".");
        }
        aclBuilder.trimToSize();
        Collections.sort(aclBuilder, ACL_ENTRY_COMPARATOR);
        AclEntry prevEntry = null;
        for (AclEntry entry : aclBuilder) {
            if (prevEntry != null && ACL_ENTRY_COMPARATOR.compare(prevEntry, entry) == 0) {
                throw new AclException("Invalid ACL: multiple entries with same scope, type and name.");
            }
            if (entry.getName() != null && (entry.getType() == AclEntryType.MASK || entry.getType() == AclEntryType.OTHER)) {
                throw new AclException("Invalid ACL: this entry type must not have a name: " + entry + ".");
            }
            prevEntry = entry;
        }
        ScopedAclEntries scopedEntries = new ScopedAclEntries(aclBuilder);
        for (AclEntryType type : EnumSet.of(AclEntryType.USER, AclEntryType.GROUP, AclEntryType.OTHER)) {
            AclEntry accessEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).build();
            if (Collections.binarySearch(scopedEntries.getAccessEntries(), accessEntryKey, ACL_ENTRY_COMPARATOR) < 0) {
                throw new AclException("Invalid ACL: the user, group and other entries are required.");
            }
            if (scopedEntries.getDefaultEntries().isEmpty()) continue;
            AclEntry defaultEntryKey = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).build();
            if (Collections.binarySearch(scopedEntries.getDefaultEntries(), defaultEntryKey, ACL_ENTRY_COMPARATOR) >= 0) continue;
            throw new AclException("Invalid default ACL: the user, group and other entries are required.");
        }
        return Collections.unmodifiableList(aclBuilder);
    }

    private static void calculateMasks(List<AclEntry> aclBuilder, EnumMap<AclEntryScope, AclEntry> providedMask, EnumSet<AclEntryScope> maskDirty, EnumSet<AclEntryScope> scopeDirty) throws AclException {
        EnumSet<AclEntryScope> scopeFound = EnumSet.noneOf(AclEntryScope.class);
        EnumMap unionPerms = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskNeeded = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry entry : aclBuilder) {
            scopeFound.add(entry.getScope());
            if (entry.getType() == AclEntryType.GROUP || entry.getName() != null) {
                FsAction scopeUnionPerms = (FsAction)((Object)unionPerms.get((Object)entry.getScope()));
                if (scopeUnionPerms == null) {
                    scopeUnionPerms = FsAction.NONE;
                }
                unionPerms.put(entry.getScope(), scopeUnionPerms.or(entry.getPermission()));
            }
            if (entry.getName() == null) continue;
            maskNeeded.add(entry.getScope());
        }
        for (AclEntryScope scope : scopeFound) {
            if (!providedMask.containsKey((Object)scope) && maskNeeded.contains((Object)scope) && maskDirty.contains((Object)scope)) {
                throw new AclException("Invalid ACL: mask is required and cannot be deleted.");
            }
            if (providedMask.containsKey((Object)scope) && (!scopeDirty.contains((Object)scope) || maskDirty.contains((Object)scope))) {
                aclBuilder.add(providedMask.get((Object)scope));
                continue;
            }
            if (!maskNeeded.contains((Object)scope) && !providedMask.containsKey((Object)scope)) continue;
            aclBuilder.add(new AclEntry.Builder().setScope(scope).setType(AclEntryType.MASK).setPermission((FsAction)((Object)unionPerms.get((Object)scope))).build());
        }
    }

    private static void copyDefaultsIfNeeded(List<AclEntry> aclBuilder) {
        Collections.sort(aclBuilder, ACL_ENTRY_COMPARATOR);
        ScopedAclEntries scopedEntries = new ScopedAclEntries(aclBuilder);
        if (!scopedEntries.getDefaultEntries().isEmpty()) {
            List<AclEntry> accessEntries = scopedEntries.getAccessEntries();
            List<AclEntry> defaultEntries = scopedEntries.getDefaultEntries();
            ArrayList copiedEntries = Lists.newArrayListWithCapacity((int)3);
            for (AclEntryType type : EnumSet.of(AclEntryType.USER, AclEntryType.GROUP, AclEntryType.OTHER)) {
                AclEntry accessEntryKey;
                int accessEntryIndex;
                AclEntry defaultEntryKey = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).build();
                int defaultEntryIndex = Collections.binarySearch(defaultEntries, defaultEntryKey, ACL_ENTRY_COMPARATOR);
                if (defaultEntryIndex >= 0 || (accessEntryIndex = Collections.binarySearch(accessEntries, accessEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).build(), ACL_ENTRY_COMPARATOR)) < 0) continue;
                copiedEntries.add(new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).setPermission(accessEntries.get(accessEntryIndex).getPermission()).build());
            }
            aclBuilder.addAll(copiedEntries);
        }
    }

    private static final class ValidatedAclSpec
    implements Iterable<AclEntry> {
        private final List<AclEntry> aclSpec;

        public ValidatedAclSpec(List<AclEntry> aclSpec) throws AclException {
            if (aclSpec.size() > 32) {
                throw new AclException("Invalid ACL: ACL spec has " + aclSpec.size() + " entries, which exceeds maximum of " + 32 + ".");
            }
            Collections.sort(aclSpec, ACL_ENTRY_COMPARATOR);
            this.aclSpec = aclSpec;
        }

        public boolean containsKey(AclEntry key) {
            return Collections.binarySearch(this.aclSpec, key, ACL_ENTRY_COMPARATOR) >= 0;
        }

        public AclEntry findByKey(AclEntry key) {
            int index = Collections.binarySearch(this.aclSpec, key, ACL_ENTRY_COMPARATOR);
            if (index >= 0) {
                return this.aclSpec.get(index);
            }
            return null;
        }

        @Override
        public Iterator<AclEntry> iterator() {
            return this.aclSpec.iterator();
        }
    }
}

