/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.security.GroupNotFoundException;
import io.hops.security.UserNotFoundException;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

public abstract class INodeWithAdditionalFields
extends INode {
    protected final long id;
    private byte[] name = null;
    private FsPermission permission;
    protected long modificationTime = 0L;
    protected long accessTime = 0L;
    private String userName;
    private String groupName;
    private int userId;
    private int groupId;
    long header = 0L;
    protected Long partitionId;
    private static final INode.Feature[] EMPTY_FEATURE = new INode.Feature[0];
    protected INode.Feature[] features = EMPTY_FEATURE;
    private int logicalTime;

    private INodeWithAdditionalFields(INode parent, long id, byte[] name, PermissionStatus permission, long modificationTime, long accessTime, boolean inTree) throws IOException {
        super(parent);
        this.id = id;
        this.name = name;
        this.permission = permission.getPermission();
        this.userName = permission.getUserName();
        this.userId = this.getUserIDDB(this.userName);
        this.groupName = permission.getGroupName();
        this.groupId = this.getGroupIDDB(this.groupName);
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.inTree = inTree;
    }

    INodeWithAdditionalFields(long id, byte[] name, PermissionStatus permission, long modificationTime, long accessTime, boolean inTree) throws IOException {
        this(null, id, name, permission, modificationTime, accessTime, inTree);
    }

    INodeWithAdditionalFields(INodeWithAdditionalFields other) throws IOException {
        this(other.getParent(), other.getId(), other.getLocalNameBytes(), other.getPermissionStatus(), other.modificationTime, other.accessTime, other.inTree);
        this.header = other.getHeader();
        this.partitionId = other.getPartitionId();
        this.parentId = other.getParentId();
        this.logicalTime = other.getLogicalTime();
    }

    INodeWithAdditionalFields(long id, String name, PermissionStatus permissions) throws IOException {
        this(id, name, permissions, false);
    }

    INodeWithAdditionalFields(long id, String name, PermissionStatus permissions, boolean inTree) throws IOException {
        this(null, id, DFSUtil.string2Bytes(name), permissions, 0L, 0L, inTree);
    }

    INodeWithAdditionalFields(long id, PermissionStatus permissions, long modificationTime, long accessTime) throws IOException {
        this(id, permissions, modificationTime, accessTime, false);
    }

    INodeWithAdditionalFields(long id, PermissionStatus permissions, long modificationTime, long accessTime, boolean inTree) throws IOException {
        this(id, null, permissions, modificationTime, accessTime, inTree);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final byte[] getLocalNameBytes() {
        return this.name;
    }

    @Override
    public final void setLocalName(byte[] name) throws StorageException, TransactionContextException {
        this.setLocalNameNoPersistance(name);
        this.save();
    }

    final void clonePermission(INodeWithAdditionalFields that) throws StorageException, TransactionContextException {
        this.permission = that.permission;
        this.save();
    }

    @Override
    public final PermissionStatus getPermissionStatus() throws IOException {
        return new PermissionStatus(this.getUserName(), this.getGroupName(), this.getFsPermission());
    }

    @Override
    protected final void setUser(String user) throws IOException {
        this.setUserNoPersistance(user);
        this.save();
    }

    @Override
    public final String getUserName() throws IOException {
        return this.userName;
    }

    @Override
    public final int getUserID() {
        return this.userId;
    }

    @Override
    public final int getGroupID() {
        return this.groupId;
    }

    @Override
    public final String getGroupName() throws IOException {
        return this.groupName;
    }

    @Override
    protected final void setGroup(String group) throws IOException {
        this.setGroupNoPersistance(group);
        this.save();
    }

    @Override
    protected final short getFsPermissionShort() {
        return this.permission.toShort();
    }

    @Override
    void setPermission(FsPermission permission) throws StorageException, TransactionContextException {
        this.setPermissionNoPersistance(permission);
        this.save();
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public final void updateModificationTime(long mtime) throws QuotaExceededException, StorageException, TransactionContextException {
        Preconditions.checkState((boolean)this.isDirectory());
        if (mtime <= this.modificationTime) {
            return;
        }
        this.setModificationTime(mtime);
    }

    @Override
    public final void setModificationTime(long modificationTime) throws StorageException, TransactionContextException {
        this.setModificationTimeNoPersistance(modificationTime);
        this.save();
    }

    @Override
    final void setModificationTimeForce(long modificationTime) throws StorageException, TransactionContextException {
        this.setModificationTimeForceNoPersistence(modificationTime);
        this.save();
    }

    final void cloneModificationTime(INodeWithAdditionalFields that) throws StorageException, TransactionContextException {
        this.modificationTime = that.modificationTime;
        this.save();
    }

    @Override
    public final long getAccessTime() {
        return this.accessTime;
    }

    @Override
    public final void setAccessTime(long accessTime) throws StorageException, TransactionContextException {
        this.setAccessTimeNoPersistance(accessTime);
        this.save();
    }

    @Override
    public final FsPermission getFsPermission() {
        return this.permission;
    }

    public void setUserNoPersistance(String user) throws IOException {
        this.userName = user;
    }

    public void setGroupNoPersistance(String group) throws IOException {
        this.groupName = group;
    }

    @Override
    public final long getHeader() {
        return this.header;
    }

    @Override
    public final void setHeaderNoPersistance(long header) {
        this.header = header;
    }

    @Override
    public final void setHasBlocksNoPersistance(boolean hasBlocks) throws StorageException, TransactionContextException {
        this.header = INode.HeaderFormat.HAS_BLOCKS.BITS.combine(hasBlocks ? 1L : 0L, this.header);
    }

    @Override
    public boolean hasBlocks() {
        return INode.HeaderFormat.hasBlocks(this.header);
    }

    @Override
    public final Long getPartitionId() {
        return this.partitionId;
    }

    @Override
    public final void setPartitionIdNoPersistance(long partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public final void setPartitionId(Long partitionId) throws StorageException, TransactionContextException {
        this.setPartitionIdNoPersistance(partitionId);
        this.save();
    }

    @Override
    public void logMetadataEvent(INodeMetadataLogEntry.Operation operation) throws StorageException, TransactionContextException {
        if (this.isUnderConstruction()) {
            return;
        }
        if (this.isPathMetaEnabled()) {
            if (this.getPartitionId() == null) {
                throw new RuntimeException("Trying to log metadata for an inode that wasn't commited to the database");
            }
            INodeDirectory datasetDir = this.getMetaEnabledParent();
            EntityManager.add((Object)new INodeMetadataLogEntry(datasetDir.getId(), this.getId(), this.getPartitionId().longValue(), this.getParentId(), this.getLocalName(), this.incrementLogicalTime(), operation));
            this.save();
        }
    }

    @Override
    public final int getLogicalTime() {
        return this.logicalTime;
    }

    @Override
    public final void setLogicalTimeNoPersistance(Integer logicalTime) {
        this.logicalTime = logicalTime;
    }

    @Override
    public final int incrementLogicalTime() {
        return ++this.logicalTime;
    }

    @Override
    public final void setLocalNameNoPersistance(byte[] name) {
        this.name = name;
    }

    @Override
    public void setLocalNameNoPersistance(String name) {
        this.name = DFSUtil.string2Bytes(name);
    }

    private void setPermissionNoPersistance(FsPermission permission) {
        this.permission = permission;
    }

    @Override
    public void setModificationTimeNoPersistance(long modtime) {
        this.modificationTime = modtime;
    }

    protected void setModificationTimeForceNoPersistence(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    @Override
    public void setAccessTimeNoPersistance(long atime) {
        this.accessTime = atime;
    }

    @Override
    XAttrFeature getXAttrFeature() {
        return (XAttrFeature)this.getFeature(XAttrFeature.class);
    }

    @Override
    public void removeXAttrFeature() {
        XAttrFeature f = this.getXAttrFeature();
        Preconditions.checkNotNull((Object)f);
        this.removeFeature(f);
    }

    @Override
    public void addXAttrFeature(XAttrFeature f) {
        XAttrFeature f1 = this.getXAttrFeature();
        Preconditions.checkState((f1 == null ? 1 : 0) != 0, (Object)"Duplicated XAttrFeature");
        this.addFeature(f);
    }

    @Override
    public void setUserID(int userId) throws IOException {
        this.setUserIDNoPersistence(userId);
        this.save();
    }

    @Override
    public void setUserIDNoPersistence(int userId) {
        this.userId = userId;
    }

    @Override
    public void setGroupID(int groupId) throws IOException {
        this.setGroupIDNoPersistence(groupId);
        this.save();
    }

    @Override
    public void setGroupIDNoPersistence(int groupId) {
        this.groupId = groupId;
    }

    public void addFeature(INode.Feature f) {
        int size = this.features.length;
        INode.Feature[] arr = new INode.Feature[size + 1];
        if (size != 0) {
            System.arraycopy(this.features, 0, arr, 0, size);
        }
        arr[size] = f;
        this.features = arr;
    }

    protected void removeFeature(INode.Feature f) {
        int size = this.features.length;
        Preconditions.checkState((size > 0 ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
        if (size == 1) {
            Preconditions.checkState((this.features[0] == f ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
            this.features = EMPTY_FEATURE;
            return;
        }
        INode.Feature[] arr = new INode.Feature[size - 1];
        int j = 0;
        boolean overflow = false;
        for (INode.Feature f1 : this.features) {
            if (f1 == f) continue;
            if (j == size - 1) {
                overflow = true;
                break;
            }
            arr[j++] = f1;
        }
        Preconditions.checkState((!overflow && j == size - 1 ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
        this.features = arr;
    }

    protected <T extends INode.Feature> T getFeature(Class<? extends INode.Feature> clazz) {
        for (INode.Feature f : this.features) {
            if (f.getClass() != clazz) continue;
            INode.Feature ret = f;
            return (T)ret;
        }
        return null;
    }

    private int getUserIDDB(String name) throws IOException {
        if (name == null) {
            return 0;
        }
        int userID = 0;
        try {
            userID = UsersGroups.getUserID(name);
        }
        catch (UserNotFoundException e) {
            return 0;
        }
        return userID;
    }

    private int getGroupIDDB(String name) throws IOException {
        if (name == null) {
            return 0;
        }
        int groupID = 0;
        try {
            groupID = UsersGroups.getGroupID(name);
        }
        catch (GroupNotFoundException e) {
            return 0;
        }
        return groupID;
    }
}

