/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.leaderElection.HdfsLeDescriptorFactory;
import io.hops.leaderElection.LeaderElection;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.hdfs.dal.LeaseCreationLocksDataAccess;
import io.hops.security.HopsUGException;
import io.hops.security.UsersGroups;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BRLoadBalancingNonLeaderException;
import org.apache.hadoop.hdfs.server.blockmanagement.BRTrackingService;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.MDCleaner;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeStatusMXBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.ssl.RevocationListFetcherService;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.tracing.TracerConfigurationManager;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NameNode
implements NameNodeStatusMXBean {
    public static final String[] NAMENODE_SPECIFIC_KEYS;
    private static final String USAGE;
    public static final int DEFAULT_PORT = 8020;
    public static final Logger LOG;
    public static final Logger stateChangeLog;
    public static final Logger blockStateChangeLog;
    private static final String NAMENODE_HTRACE_PREFIX = "namenode.htrace.";
    protected FSNamesystem namesystem;
    protected final Configuration conf;
    private AtomicBoolean started = new AtomicBoolean(false);
    protected NameNodeHttpServer httpServer;
    private Thread emptier;
    protected boolean stopRequested = false;
    protected NamenodeRegistration nodeRegistration;
    private List<ServicePlugin> plugins;
    private NameNodeRpcServer rpcServer;
    private JvmPauseMonitor pauseMonitor;
    protected LeaderElection leaderElection;
    protected RevocationListFetcherService revocationListFetcherService;
    private BRTrackingService brTrackingService;
    private MDCleaner mdCleaner;
    static long failedSTOCleanDelay;
    long slowSTOCleanDelay = 0L;
    private ObjectName nameNodeStatusBeanName;
    protected final Tracer tracer;
    protected final TracerConfigurationManager tracerConfigurationManager;
    private String tokenServiceName;
    static NameNodeMetrics metrics;
    private static final StartupProgress startupProgress;

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 69L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 6L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshCallQueueProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(GetUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(TraceAdminProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.formatHdfs(conf, false, true);
    }

    public FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    @VisibleForTesting
    public void setNamesystem(FSNamesystem fsNamesystem) {
        this.namesystem = fsNamesystem;
    }

    public NamenodeProtocols getRpcServer() {
        return this.rpcServer;
    }

    static void initMetrics(Configuration conf, HdfsServerConstants.NamenodeRole role) {
        metrics = NameNodeMetrics.create(conf, role);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return metrics;
    }

    public static StartupProgress getStartupProgress() {
        return startupProgress;
    }

    public String getTokenServiceName() {
        return this.tokenServiceName;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr(address, 8020);
    }

    public static void setServiceAddress(Configuration conf, String address) {
        LOG.info("Setting ADDRESS {}", (Object)address);
        conf.set("dfs.namenode.servicerpc-address", address);
    }

    public static InetSocketAddress getServiceAddress(Configuration conf, boolean fallback) {
        String addr = conf.getTrimmed("dfs.namenode.servicerpc-address");
        if (addr == null || addr.isEmpty()) {
            return fallback ? NameNode.getAddress(conf) : null;
        }
        return NameNode.getAddress(addr);
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri(conf);
        return NameNode.getAddress(filesystemURI);
    }

    public static InetSocketAddress getAddress(URI filesystemURI) {
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme()) && !"hopsfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return NameNode.getAddress(authority);
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        if (this.leaderElection != null && this.leaderElection.isLeader()) {
            return HdfsServerConstants.NamenodeRole.LEADER_NAMENODE;
        }
        return HdfsServerConstants.NamenodeRole.NAMENODE;
    }

    boolean isRole(HdfsServerConstants.NamenodeRole that) {
        HdfsServerConstants.NamenodeRole currentRole = this.getRole();
        return currentRole.equals((Object)that);
    }

    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) {
        return NameNode.getServiceAddress(conf, false);
    }

    protected InetSocketAddress getRpcServerAddress(Configuration conf) {
        return NameNode.getAddress(conf);
    }

    protected String getServiceRpcServerBindHost(Configuration conf) {
        String addr = conf.getTrimmed("dfs.namenode.servicerpc-bind-host");
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        return addr;
    }

    protected String getRpcServerBindHost(Configuration conf) {
        String addr = conf.getTrimmed("dfs.namenode.rpc-bind-host");
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        return addr;
    }

    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress serviceRPCAddress) {
        NameNode.setServiceAddress(conf, NetUtils.getHostPortString(serviceRPCAddress));
    }

    protected void setRpcServerAddress(Configuration conf, InetSocketAddress rpcAddress) {
        FileSystem.setDefaultUri(conf, NameNode.getUri(rpcAddress));
    }

    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        return NameNode.getHttpAddress(conf);
    }

    protected InetSocketAddress getHttpServerBindAddress(Configuration conf) {
        InetSocketAddress bindAddress = this.getHttpServerAddress(conf);
        String bindHost = conf.getTrimmed("dfs.namenode.http-bind-host");
        if (bindHost != null && !bindHost.isEmpty()) {
            bindAddress = new InetSocketAddress(bindHost, bindAddress.getPort());
        }
        return bindAddress;
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr(conf.getTrimmed("dfs.namenode.http-address", "0.0.0.0:50070"));
    }

    protected void loadNamesystem(Configuration conf) throws IOException {
        this.namesystem = FSNamesystem.loadFromDisk(conf, this);
    }

    NamenodeRegistration getRegistration() {
        return this.nodeRegistration;
    }

    NamenodeRegistration setRegistration() throws IOException {
        this.nodeRegistration = new NamenodeRegistration(NetUtils.getHostPortString(this.rpcServer.getRpcAddress()), NetUtils.getHostPortString(this.getHttpAddress()), StorageInfo.getStorageInfoFromDB(), this.getRole());
        return this.nodeRegistration;
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    void loginAsNameNodeUser(Configuration conf) throws IOException {
        InetSocketAddress socAddr = this.getRpcServerAddress(conf);
        SecurityUtil.login(conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", socAddr.getHostName());
    }

    protected void initialize(Configuration conf) throws IOException {
        String intervals;
        if (conf.get("hadoop.user.group.metrics.percentiles.intervals") == null && (intervals = conf.get("dfs.metrics.percentiles.intervals")) != null) {
            conf.set("hadoop.user.group.metrics.percentiles.intervals", intervals);
        }
        UserGroupInformation.setConfiguration(conf);
        this.loginAsNameNodeUser(conf);
        HdfsStorageFactory.setConfiguration(conf);
        int baseWaitTime = conf.getInt("dfs.namenode.tx.initial.wait.time.before.retry", 2000);
        int retryCount = conf.getInt("dfs.namenode.tx.retry.count", 5);
        RequestHandler.setRetryBaseWaitTime((int)baseWaitTime);
        RequestHandler.setRetryCount((int)retryCount);
        long updateThreshold = conf.getLong("dfs.block.report.load.balancing.db.var.update.threashold", 60000L);
        long maxConcurrentBRs = conf.getLong("dfs.block.report.load.balancer.max.concurrent.block.reports.per.nn", 1L);
        long brMaxProcessingTime = conf.getLong("dfs.block.report.load.balancing.max.block.report.processing.time", 3600000L);
        this.brTrackingService = new BRTrackingService(updateThreshold, maxConcurrentBRs, brMaxProcessingTime);
        this.mdCleaner = MDCleaner.getInstance();
        failedSTOCleanDelay = conf.getLong("dfs.subtree.clean.failed.ops.locks.delay", 600000L);
        this.slowSTOCleanDelay = conf.getLong("dfs.subtree.clean.failed.ops.locks.delay", 900000L);
        String fsOwnerShortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        String superGroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        try {
            UsersGroups.addUser(fsOwnerShortUserName);
            UsersGroups.addGroup(superGroup);
            UsersGroups.addUserToGroup(fsOwnerShortUserName, superGroup);
        }
        catch (HopsUGException hopsUGException) {
            // empty catch block
        }
        try {
            this.createAndStartCRLFetcherService(conf);
        }
        catch (Exception ex) {
            LOG.error("Error starting CRL fetcher service", (Throwable)ex);
            throw new IOException(ex);
        }
        NameNode.initMetrics(conf, this.getRole());
        StartupProgressMetrics.register(startupProgress);
        this.startHttpServer(conf);
        this.loadNamesystem(conf);
        this.rpcServer = this.createRpcServer(conf);
        this.tokenServiceName = NetUtils.getHostPortString(this.rpcServer.getRpcAddress());
        this.httpServer.setNameNodeAddress(this.getNameNodeAddress());
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(conf);
        this.pauseMonitor.start();
        metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        this.startCommonServices(conf);
        if (this.isLeader()) {
            HdfsVariables.setMaxConcurrentBrs(maxConcurrentBRs, null);
            NameNode.createLeaseLocks(conf);
        }
        if (HdfsVariables.getRetryCacheCleanerEpoch() == 0L) {
            HdfsVariables.setRetryCacheCleanerEpoch(System.currentTimeMillis() / 1000L - 1L);
        }
    }

    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new NameNodeRpcServer(conf, this);
    }

    private void startCommonServices(Configuration conf) throws IOException {
        this.startLeaderElectionService();
        this.startMDCleanerService();
        this.namesystem.startCommonServices(conf);
        this.registerNNSMXBean();
        this.rpcServer.start();
        this.plugins = conf.getInstances("dfs.namenode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start(this);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin " + p + " could not be started", t);
            }
        }
        LOG.info((Object)((Object)this.getRole()) + " RPC up at: " + this.rpcServer.getRpcAddress());
        if (this.rpcServer.getServiceRpcAddress() != null) {
            LOG.info((Object)((Object)this.getRole()) + " service RPC up at: " + this.rpcServer.getServiceRpcAddress());
        }
    }

    private void registerNNSMXBean() {
        this.nameNodeStatusBeanName = MBeans.register("NameNode", "NameNodeStatus", this);
    }

    @Override
    public String getNNRole() {
        String roleStr = "";
        HdfsServerConstants.NamenodeRole role = this.getRole();
        if (null != role) {
            roleStr = role.toString();
        }
        return roleStr;
    }

    @Override
    public String getHostAndPort() {
        return this.getNameNodeAddressHostPortString();
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    private void stopCommonServices() {
        if (this.leaderElection != null && this.leaderElection.isRunning()) {
            try {
                this.leaderElection.stopElectionThread();
            }
            catch (InterruptedException e) {
                LOG.warn("LeaderElection thread stopped", (Throwable)e);
            }
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        if (this.mdCleaner != null) {
            this.mdCleaner.stopMDCleanerMonitor();
        }
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin " + p + " could not be stopped", t);
                }
            }
        }
        if (this.revocationListFetcherService != null) {
            try {
                this.revocationListFetcherService.serviceStop();
            }
            catch (Exception ex) {
                LOG.warn("Exception while stopping CRL fetcher service, but we are shutting down anyway");
            }
        }
        this.stopHttpServer();
    }

    private void startTrashEmptier(final Configuration conf) throws IOException {
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        if (trashInterval == 0L) {
            return;
        }
        if (trashInterval < 0L) {
            throw new IOException("Cannot start trash emptier with negative interval. Set fs.trash.interval to a positive value.");
        }
        FileSystem fs = SecurityUtil.doAsLoginUser(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.get(conf);
            }
        });
        this.emptier = new Thread(new Trash(fs, conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void stopTrashEmptier() {
        if (this.emptier != null) {
            this.emptier.interrupt();
            this.emptier = null;
        }
    }

    private void startHttpServer(Configuration conf) throws IOException {
        this.httpServer = new NameNodeHttpServer(conf, this, this.getHttpServerBindAddress(conf));
        this.httpServer.start();
        this.httpServer.setStartupProgress(startupProgress);
    }

    private void stopHttpServer() {
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while stopping httpserver", (Throwable)e);
        }
    }

    public NameNode(Configuration conf) throws IOException {
        this(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
    }

    protected NameNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        this.tracer = new Tracer.Builder("NameNode").conf(TraceUtils.wrapHadoopConf(NAMENODE_HTRACE_PREFIX, conf)).build();
        this.tracerConfigurationManager = new TracerConfigurationManager(NAMENODE_HTRACE_PREFIX, conf);
        this.conf = conf;
        try {
            NameNode.initializeGenericKeys(conf);
            this.initialize(conf);
            this.started.set(true);
            this.enterActiveState();
        }
        catch (IOException | HadoopIllegalArgumentException e) {
            this.stop();
            throw e;
        }
    }

    public void join() {
        try {
            this.rpcServer.join();
        }
        catch (InterruptedException ie) {
            LOG.info("Caught interrupted exception ", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NameNode nameNode = this;
        synchronized (nameNode) {
            if (this.stopRequested) {
                return;
            }
            this.stopRequested = true;
        }
        try {
            this.exitActiveServices();
        }
        catch (ServiceFailedException e) {
            LOG.warn("Encountered exception while exiting state ", (Throwable)e);
        }
        finally {
            this.stopCommonServices();
            if (metrics != null) {
                metrics.shutdown();
            }
            if (this.namesystem != null) {
                this.namesystem.shutdown();
            }
            if (this.nameNodeStatusBeanName != null) {
                MBeans.unregister(this.nameNodeStatusBeanName);
                this.nameNodeStatusBeanName = null;
            }
        }
        this.tracer.close();
    }

    synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    public boolean isInSafeMode() throws IOException {
        return this.namesystem.isInSafeMode();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.rpcServer.getRpcAddress();
    }

    public String getNameNodeAddressHostPortString() {
        return NetUtils.getHostPortString(this.rpcServer.getRpcAddress());
    }

    public InetSocketAddress getServiceRpcAddress() {
        InetSocketAddress serviceAddr = this.rpcServer.getServiceRpcAddress();
        return serviceAddr == null ? this.rpcServer.getRpcAddress() : serviceAddr;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpServer.getHttpsAddress();
    }

    private static boolean formatHdfs(Configuration conf, boolean force, boolean isInteractive) throws IOException {
        String clusterId;
        NameNode.initializeGenericKeys(conf);
        NameNode.checkAllowFormat(conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            InetSocketAddress socAddr = NameNode.getAddress(conf);
            SecurityUtil.login(conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", socAddr.getHostName());
        }
        if ((clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId()) == null || clusterId.equals("")) {
            clusterId = StorageInfo.newClusterID();
        }
        try {
            HdfsStorageFactory.setConfiguration(conf);
            if (force) {
                HdfsStorageFactory.formatHdfsStorageNonTransactional();
            } else {
                HdfsStorageFactory.formatHdfsStorage();
            }
            StorageInfo.storeStorageInfoToDB(clusterId, Time.now());
            UsersGroups.createSyncRow();
            NameNode.createLeaseLocks(conf);
        }
        catch (StorageException e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    @VisibleForTesting
    public static boolean formatAll(Configuration conf) throws IOException {
        String clusterId;
        LOG.warn("Formatting HopsFS and HopsYarn");
        NameNode.initializeGenericKeys(conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            InetSocketAddress socAddr = NameNode.getAddress(conf);
            SecurityUtil.login(conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", socAddr.getHostName());
        }
        if ((clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId()) == null || clusterId.equals("")) {
            clusterId = StorageInfo.newClusterID();
        }
        try {
            HdfsStorageFactory.setConfiguration(conf);
            HdfsStorageFactory.formatStorage();
            StorageInfo.storeStorageInfoToDB(clusterId, Time.now());
        }
        catch (StorageException e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    public static void checkAllowFormat(Configuration conf) throws IOException {
        if (!conf.getBoolean("dfs.namenode.support.allow.format", true)) {
            throw new IOException("The option dfs.namenode.support.allow.format is set to false for this filesystem, so it cannot be formatted. You will need to set dfs.namenode.support.allow.format parameter to true in order to format this filesystem");
        }
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE + "\n");
    }

    @VisibleForTesting
    public static HdfsServerConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsServerConstants.StartupOption.NO_OF_CONCURRENT_BLOCK_REPORTS.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.NO_OF_CONCURRENT_BLOCK_REPORTS;
                String msg = "Specify a maximum number of concurrent blocks that the NameNodes can process.";
                if (i + 1 >= argsLen) {
                    LOG.error(msg);
                    return null;
                }
                long maxBRs = 0L;
                try {
                    maxBRs = Long.parseLong(args[i + 1]);
                    if (maxBRs < 1L) {
                        LOG.error("The number should be >= 1.");
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                startOpt.setMaxConcurrentBlkReports(maxBRs);
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FORMAT;
                ++i;
                while (i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) {
                        if (++i >= argsLen) {
                            LOG.error("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag");
                            return null;
                        }
                        String clusterId = args[i];
                        if (clusterId.isEmpty() || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName()) || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                            LOG.error("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag");
                            return null;
                        }
                        startOpt.setClusterId(clusterId);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForceFormat(true);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                        startOpt.setInteractiveFormat(false);
                    }
                    ++i;
                }
                continue;
            }
            if (HdfsServerConstants.StartupOption.FORMAT_ALL.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FORMAT_ALL;
                continue;
            }
            if (HdfsServerConstants.StartupOption.GENCLUSTERID.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.GENCLUSTERID;
                continue;
            }
            if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BACKUP.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BACKUP;
                continue;
            }
            if (HdfsServerConstants.StartupOption.CHECKPOINT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.CHECKPOINT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.UPGRADE;
                if (i + 2 >= argsLen || !args[i + 1].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) continue;
                startOpt.setClusterId(args[i += 2]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLINGUPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLINGUPGRADE;
                if (++i >= argsLen) {
                    LOG.error("Must specify a rolling upgrade startup option " + HdfsServerConstants.RollingUpgradeStartupOption.getAllOptionString());
                    return null;
                }
                startOpt.setRollingUpgradeStartupOption(args[i]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsServerConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FINALIZE;
                continue;
            }
            if (HdfsServerConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.IMPORT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY;
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS;
                ++i;
                while (i < argsLen) {
                    if (HdfsServerConstants.StartupOption.NONINTERACTIVE.getName().equals(args[i])) {
                        startOpt.setInteractiveFormat(false);
                    } else if (HdfsServerConstants.StartupOption.FORCE.getName().equals(args[i])) {
                        startOpt.setForceFormat(true);
                    } else {
                        LOG.error("Invalid argument: " + args[i]);
                        return null;
                    }
                    ++i;
                }
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.RECOVER.getName().equalsIgnoreCase(cmd)) {
                if (startOpt != HdfsServerConstants.StartupOption.REGULAR) {
                    throw new RuntimeException("Can't combine -recover with other startup options.");
                }
                startOpt = HdfsServerConstants.StartupOption.RECOVER;
                while (++i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForce(1);
                        continue;
                    }
                    throw new RuntimeException("Error parsing recovery options: can't understand option \"" + args[i] + "\"");
                }
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.name());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsServerConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsServerConstants.StartupOption.REGULAR.toString()));
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        HdfsServerConstants.StartupOption startOpt;
        LOG.info("createNameNode " + Arrays.asList(argv));
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if ((startOpt = NameNode.parseArguments(argv)) == null) {
            NameNode.printUsage(System.err);
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        switch (startOpt) {
            case NO_OF_CONCURRENT_BLOCK_REPORTS: {
                HdfsVariables.setMaxConcurrentBrs(startOpt.getMaxConcurrentBlkReports(), conf);
                LOG.info("Setting concurrent block reports processing to " + startOpt.getMaxConcurrentBlkReports());
                return null;
            }
            case FORMAT: {
                boolean aborted = NameNode.formatHdfs(conf, startOpt.getForceFormat(), startOpt.getInteractiveFormat());
                ExitUtil.terminate(aborted ? 1 : 0);
                return null;
            }
            case FORMAT_ALL: {
                boolean aborted = NameNode.formatAll(conf);
                ExitUtil.terminate(aborted ? 1 : 0);
                return null;
            }
            case GENCLUSTERID: {
                System.err.println("Generating new cluster id:");
                System.out.println(StorageInfo.newClusterID());
                ExitUtil.terminate(0);
                return null;
            }
            case FINALIZE: {
                throw new UnsupportedOperationException("HOP: FINALIZE is not supported anymore");
            }
            case BOOTSTRAPSTANDBY: {
                throw new UnsupportedOperationException("HOP: BOOTSTRAPSTANDBY is not supported anymore");
            }
            case INITIALIZESHAREDEDITS: {
                throw new UnsupportedOperationException("HOP: INITIALIZESHAREDEDITS is not supported anymore");
            }
            case BACKUP: 
            case CHECKPOINT: {
                throw new UnsupportedOperationException("HOP: BACKUP/CHECKPOINT is not supported anymore");
            }
            case RECOVER: {
                new UnsupportedOperationException("Hops. Metadata recovery is not supported");
                return null;
            }
        }
        DefaultMetricsSystem.initialize("NameNode");
        return new NameNode(conf);
    }

    public static void initializeGenericKeys(Configuration conf) {
        if (conf.get("dfs.namenode.rpc-address") != null) {
            URI defaultUri = URI.create("hdfs://" + conf.get("dfs.namenode.rpc-address"));
            conf.set("fs.defaultFS", defaultUri.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting fs.defaultFS to " + defaultUri.toString());
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        if (DFSUtil.parseHelpArgument(argv, USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            StringUtils.startupShutdownMessage(NameNode.class, argv, LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to start namenode.", e);
            ExitUtil.terminate(1, e);
        }
    }

    private void enterActiveState() throws ServiceFailedException {
        try {
            this.startActiveServicesInternal();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to start active services", e);
        }
    }

    private void startActiveServicesInternal() throws IOException {
        try {
            this.namesystem.startActiveServices();
            this.startTrashEmptier(this.conf);
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
    }

    private void exitActiveServices() throws ServiceFailedException {
        try {
            this.stopActiveServicesInternal();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to stop active services", e);
        }
    }

    private void stopActiveServicesInternal() throws IOException {
        try {
            if (this.namesystem != null) {
                this.namesystem.stopActiveServices();
            }
            this.stopTrashEmptier();
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
    }

    protected synchronized void doImmediateShutdown(Throwable t) throws ExitUtil.ExitException {
        String message = "Error encountered requiring NN shutdown. Shutting down immediately.";
        try {
            LOG.error(message, t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ExitUtil.terminate(1, t);
    }

    public long getId() {
        return this.leaderElection.getCurrentId();
    }

    public LeaderElection getLeaderElectionInstance() {
        return this.leaderElection;
    }

    public boolean isLeader() {
        if (this.leaderElection != null) {
            return this.leaderElection.isLeader();
        }
        return false;
    }

    public ActiveNode getNextNamenodeToSendBlockReport(long noOfBlks, DatanodeID nodeID) throws IOException {
        if (this.leaderElection.isLeader()) {
            DatanodeDescriptor node = this.namesystem.getBlockManager().getDatanodeManager().getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                throw new IOException("ProcessReport from dead or unregistered node: " + nodeID + ". " + (node != null ? "The node is alive : " + node.isAlive : "The node is null "));
            }
            LOG.debug("NN Id: " + this.leaderElection.getCurrentId() + ") Received request to assign block report work (" + noOfBlks + " blks) ");
            ActiveNode an = this.brTrackingService.assignWork(this.leaderElection.getActiveNamenodes(), nodeID.getXferAddr(), noOfBlks);
            return an;
        }
        String msg = "NN Id: " + this.leaderElection.getCurrentId() + ") Received request to assign work (" + noOfBlks + " blks). Returning null as I am not the leader NN";
        LOG.debug(msg);
        throw new BRLoadBalancingNonLeaderException(msg);
    }

    public static boolean isNameNodeAlive(Collection<ActiveNode> activeNamenodes, long namenodeId) {
        if (activeNamenodes == null) {
            return true;
        }
        for (ActiveNode namenode : activeNamenodes) {
            if (namenode.getId() != namenodeId) continue;
            return true;
        }
        return false;
    }

    public long getLeCurrentId() {
        return this.leaderElection.getCurrentId();
    }

    public SortedActiveNodeList getActiveNameNodes() {
        return this.leaderElection.getActiveNamenodes();
    }

    private void startMDCleanerService() {
        this.mdCleaner.startMDCleanerMonitor(this.namesystem, this.leaderElection, failedSTOCleanDelay, this.slowSTOCleanDelay);
    }

    private void stopMDCleanerService() {
        this.mdCleaner.stopMDCleanerMonitor();
    }

    private void startLeaderElectionService() throws IOException {
        long leadercheckInterval = this.conf.getInt("dfs.leader.check.interval", 2000);
        int missedHeartBeatThreshold = this.conf.getInt("dfs.leader.missed.hb", 2);
        int leIncrement = this.conf.getInt("dfs.leader.tp.increment", 100);
        String rpcAddresses = "";
        rpcAddresses = this.rpcServer.getRpcAddress().getAddress().getHostAddress() + ":" + this.rpcServer.getRpcAddress().getPort() + ",";
        if (this.rpcServer.getServiceRpcAddress() != null) {
            rpcAddresses = rpcAddresses + this.rpcServer.getServiceRpcAddress().getAddress().getHostAddress() + ":" + this.rpcServer.getServiceRpcAddress().getPort();
        }
        String httpAddress = DFSUtil.getHttpPolicy(this.conf).isHttpEnabled() ? (this.httpServer.getHttpAddress().getAddress().getHostAddress().equals("0.0.0.0") ? this.rpcServer.getRpcAddress().getAddress().getHostAddress() + ":" + this.httpServer.getHttpAddress().getPort() : this.httpServer.getHttpAddress().getAddress().getHostAddress() + ":" + this.httpServer.getHttpAddress().getPort()) : (this.httpServer.getHttpsAddress().getAddress().getHostAddress().equals("0.0.0.0") ? this.rpcServer.getRpcAddress().getAddress().getHostAddress() + ":" + this.httpServer.getHttpsAddress().getPort() : this.httpServer.getHttpsAddress().getAddress().getHostAddress() + ":" + this.httpServer.getHttpsAddress().getPort());
        this.leaderElection = new LeaderElection(new HdfsLeDescriptorFactory(), leadercheckInterval, missedHeartBeatThreshold, leIncrement, httpAddress, rpcAddresses, (byte)this.conf.getInt("dfs.locationDomainId", 0));
        this.leaderElection.start();
        try {
            this.leaderElection.waitActive();
        }
        catch (InterruptedException e) {
            LOG.warn("NN was interrupted");
        }
    }

    private void createAndStartCRLFetcherService(Configuration conf) throws Exception {
        if (conf.getBoolean("ipc.server.ssl.enabled", false)) {
            if (conf.getBoolean("hops.crl.validation.enabled", false)) {
                LOG.info("Creating CertificateRevocationList Fetcher service");
                this.revocationListFetcherService = new RevocationListFetcherService();
                this.revocationListFetcherService.serviceInit(conf);
                this.revocationListFetcherService.serviceStart();
            } else {
                LOG.warn("RPC TLS is enabled but CRL validation is disabled");
            }
        }
    }

    boolean isStarted() {
        return this.started.get();
    }

    public BRTrackingService getBRTrackingService() {
        return this.brTrackingService;
    }

    @VisibleForTesting
    NameNodeRpcServer getNameNodeRpcServer() {
        return this.rpcServer;
    }

    static void createLeaseLocks(Configuration conf) throws IOException {
        final int count = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        new LightWeightRequestHandler(HDFSOperationType.CREATE_LEASE_LOCKS){

            public Object performTask() throws IOException {
                LeaseCreationLocksDataAccess da = (LeaseCreationLocksDataAccess)HdfsStorageFactory.getDataAccess(LeaseCreationLocksDataAccess.class);
                da.createLockRows(count);
                return null;
            }
        }.handle();
    }

    public static long getFailedSTOCleanDelay() {
        return failedSTOCleanDelay;
    }

    static {
        HdfsConfiguration.init();
        NAMENODE_SPECIFIC_KEYS = new String[]{"dfs.namenode.rpc-address", "dfs.namenode.rpc-bind-host", "dfs.namenode.servicerpc-address", "dfs.namenode.servicerpc-bind-host", "dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", "dfs.namenode.kerberos.internal.spnego.principal"};
        USAGE = "Usage: java NameNode [" + HdfsServerConstants.StartupOption.FORMAT.getName() + " [" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid ] | [" + HdfsServerConstants.StartupOption.FORCE.getName() + "] [" + HdfsServerConstants.StartupOption.NONINTERACTIVE.getName() + "] ] | [" + HdfsServerConstants.StartupOption.ROLLINGUPGRADE.getName() + " " + HdfsServerConstants.RollingUpgradeStartupOption.getAllOptionString() + " ] | \n\t[" + HdfsServerConstants.StartupOption.NO_OF_CONCURRENT_BLOCK_REPORTS.getName() + " concurrentBlockReports ] | [" + HdfsServerConstants.StartupOption.FORMAT_ALL.getName() + " ]";
        LOG = LoggerFactory.getLogger((String)NameNode.class.getName());
        stateChangeLog = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.StateChange");
        blockStateChangeLog = LoggerFactory.getLogger((String)"BlockStateChange");
        failedSTOCleanDelay = 0L;
        startupProgress = new StartupProgress();
    }
}

