/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.EncryptionZoneDataAccess;
import io.hops.metadata.hdfs.entity.EncryptionZone;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class EncryptionZoneContext
extends BaseEntityContext<Long, EncryptionZone> {
    private final EncryptionZoneDataAccess<EncryptionZone> dataAccess;

    public EncryptionZoneContext(EncryptionZoneDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    Long getKey(EncryptionZone encryptionZone) {
        return encryptionZone.getInodeId();
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public EncryptionZone find(FinderType<EncryptionZone> finder, Object ... params) throws TransactionContextException, StorageException {
        EncryptionZone.Finder xfinder = (EncryptionZone.Finder)finder;
        switch (xfinder) {
            case ByPrimaryKeyInContext: {
                return this.findInContextByPrimaryKey(xfinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<EncryptionZone> findList(FinderType<EncryptionZone> finder, Object ... params) throws TransactionContextException, StorageException {
        EncryptionZone.Finder xfinder = (EncryptionZone.Finder)finder;
        switch (xfinder) {
            case ByPrimaryKeyBatch: {
                return this.findByPrimaryKeyBatch(xfinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private EncryptionZone findInContextByPrimaryKey(EncryptionZone.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        Long pk = (Long)params[0];
        EncryptionZone result = null;
        if (this.contains(pk)) {
            result = (EncryptionZone)this.get(pk);
            this.hit((FinderType)finder, result, new Object[]{"pk", pk, "results", result});
        }
        return result;
    }

    private Collection<EncryptionZone> findByPrimaryKeyBatch(EncryptionZone.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        List pks = (List)params[0];
        List results = null;
        if (this.containsAll(pks)) {
            results = this.getAll(pks);
            this.hit((FinderType)finder, results, new Object[]{"pks", pks, "results", results});
        } else {
            this.aboutToAccessStorage((FinderType)finder, params);
            results = this.dataAccess.getEncryptionZoneByInodeIdBatch(pks);
            this.gotFromDB(pks, results);
            this.miss((FinderType)finder, results, new Object[]{"pks", pks, "results", results});
        }
        return results;
    }

    private void gotFromDB(List<Long> pks, List<EncryptionZone> results) {
        HashSet notFoundPks = Sets.newHashSet(pks);
        for (EncryptionZone ez : results) {
            if (ez.getZoneInfo() != null) {
                this.gotFromDB(ez);
            } else {
                this.gotFromDB(ez.getInodeId(), null);
            }
            notFoundPks.remove(ez.getInodeId());
        }
        for (Long pk : notFoundPks) {
            this.gotFromDB(pk, null);
        }
    }

    private boolean containsAll(List<Long> pks) {
        for (Long pk : pks) {
            if (this.contains(pk)) continue;
            return false;
        }
        return true;
    }

    private List<EncryptionZone> getAll(List<Long> pks) {
        ArrayList attrs = Lists.newArrayListWithExpectedSize((int)pks.size());
        for (Long pk : pks) {
            attrs.add(this.get(pk));
        }
        return attrs;
    }
}

