/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CommonConfigurationKeys;
import org.apache.hadoop.security.ssl.CRLFetcher;
import org.apache.hadoop.util.ReflectionUtils;

public class CRLFetcherFactory {
    private CRLFetcher fetcher = null;
    private static volatile CRLFetcherFactory instance;

    private CRLFetcherFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRLFetcherFactory getInstance() {
        if (instance != null) return instance;
        Class<CRLFetcherFactory> clazz = CRLFetcherFactory.class;
        synchronized (CRLFetcherFactory.class) {
            if (instance != null) return instance;
            instance = new CRLFetcherFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized CRLFetcher getCRLFetcher(Configuration conf) throws ClassNotFoundException, URISyntaxException {
        String crlFetcherClass = conf.get("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        if (this.fetcher != null) {
            return this.fetcher;
        }
        Class<?> clazz = conf.getClassByName(crlFetcherClass);
        this.fetcher = (CRLFetcher)ReflectionUtils.newInstance(clazz, conf);
        this.setInputURI(conf, this.fetcher);
        this.setOutputURI(conf, this.fetcher);
        return this.fetcher;
    }

    @VisibleForTesting
    public void clearFetcherCache() {
        this.fetcher = null;
    }

    private void setOutputURI(Configuration conf, CRLFetcher fetcher) throws URISyntaxException {
        String outputString = conf.get("hops.crl.output.file", CommonConfigurationKeys.HOPS_CRL_OUTPUT_FILE_DEFAULT);
        URI outputURI = new URI(outputString);
        if (outputURI.getScheme() == null) {
            outputURI = new URI("file://" + outputString);
        }
        fetcher.setOutputURI(outputURI);
    }

    private void setInputURI(Configuration conf, CRLFetcher fetcher) throws URISyntaxException {
        String inputURI = conf.get("hops.crl.input.uri");
        fetcher.setInputURI(new URI(inputURI));
    }
}

