/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import io.hops.leader_election.node.ActiveNode;
import io.hops.util.GroupMembership;
import io.hops.util.LiveRMsResponse;
import io.hops.util.SortedActiveRMList;
import io.hops.util.impl.pb.client.GroupMembershipPBClientImpl;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class GroupMembershipProxyService
implements Closeable {
    private static final Log LOG = LogFactory.getLog(GroupMembershipProxyService.class);
    Random random = new Random();
    SortedActiveRMList anList = null;
    private RMProxy<GroupMembership> rmProxy;
    private Class<GroupMembership> protocol;
    protected YarnConfiguration conf;
    protected String[] rmServiceIds;
    private int currentProxyIndex = 0;
    private Map<InetSocketAddress, GroupMembership> oldProxies = new HashMap<InetSocketAddress, GroupMembership>();

    public GroupMembershipProxyService(Configuration conf, RMProxy rmProxy) {
        this.conf = new YarnConfiguration(conf);
        this.rmProxy = rmProxy;
        this.protocol = GroupMembership.class;
        Collection<String> rmIds = HAUtil.getRMHAIds(conf);
        this.rmServiceIds = rmIds.toArray(new String[rmIds.size()]);
        this.currentProxyIndex = this.rmServiceIds.length - 1;
        conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
    }

    public ActiveNode getLeader() {
        this.updateActiveNodeList();
        if (this.anList == null) {
            return null;
        }
        return this.anList.getLeader();
    }

    private void updateActiveNodeList() {
        if (this.anList == null || this.anList.isEmpty()) {
            this.updateFromConfigFile();
        } else {
            this.updateFromActiveNodeList();
        }
    }

    private void updateFromActiveNodeList() {
        while (!this.anList.isEmpty()) {
            List<ActiveNode> activeNodes = this.anList.getActiveNodes();
            final ActiveNode nextNode = activeNodes.get(this.random.nextInt(activeNodes.size()));
            try {
                LiveRMsResponse response;
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                if (ugi.getRealUser() != null) {
                    ugi = ugi.getRealUser();
                }
                if ((response = ugi.doAs(new PrivilegedAction<LiveRMsResponse>(){

                    @Override
                    public LiveRMsResponse run() {
                        try {
                            GroupMembership proxy = (GroupMembership)GroupMembershipProxyService.this.oldProxies.get(nextNode.getRpcServerAddressForClients());
                            if (proxy == null) {
                                proxy = new GroupMembershipPBClientImpl(1L, nextNode.getRpcServerAddressForClients(), GroupMembershipProxyService.this.conf);
                                GroupMembershipProxyService.this.oldProxies.put(nextNode.getRpcServerAddressForClients(), proxy);
                            }
                            return proxy.getLiveRMList();
                        }
                        catch (IOException ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                        catch (YarnException ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                        return null;
                    }
                })) == null) {
                    activeNodes.remove(nextNode);
                    this.anList = new SortedActiveRMList(activeNodes);
                    continue;
                }
                this.anList = response.getLiveRMsList();
                return;
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        this.updateFromConfigFile();
    }

    private void updateFromConfigFile() {
        int tries = 0;
        while (tries < this.rmServiceIds.length) {
            this.currentProxyIndex = (this.currentProxyIndex + 1) % this.rmServiceIds.length;
            this.conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
            try {
                LiveRMsResponse response;
                LOG.info((Object)("connecting to " + this.rmServiceIds[this.currentProxyIndex]));
                final InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                if (ugi.getRealUser() != null) {
                    ugi = ugi.getRealUser();
                }
                if ((response = ugi.doAs(new PrivilegedAction<LiveRMsResponse>(){

                    @Override
                    public LiveRMsResponse run() {
                        try {
                            GroupMembership proxy = (GroupMembership)GroupMembershipProxyService.this.oldProxies.get(rmAddress);
                            if (proxy == null) {
                                proxy = (GroupMembership)RMProxy.createRMProxy((Configuration)GroupMembershipProxyService.this.conf, GroupMembershipProxyService.this.protocol, rmAddress);
                                GroupMembershipProxyService.this.oldProxies.put(rmAddress, proxy);
                            }
                            return proxy.getLiveRMList();
                        }
                        catch (IOException ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                        catch (YarnException ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                        return null;
                    }
                })) == null) {
                    LOG.info((Object)("Unable to create proxy to the ResourceManager " + this.rmServiceIds[this.currentProxyIndex]));
                    this.anList = null;
                    ++tries;
                    continue;
                }
                LOG.debug((Object)("create proxy to the ResourceManager " + this.rmServiceIds[this.currentProxyIndex]));
                this.anList = response.getLiveRMsList();
                return;
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        for (GroupMembership proxy : this.oldProxies.values()) {
            if (proxy instanceof Closeable) {
                ((Closeable)((Object)proxy)).close();
                continue;
            }
            RPC.stopProxy(proxy);
        }
    }
}

