/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Time;

class BlockPoolSlice {
    static final Log LOG = LogFactory.getLog(BlockPoolSlice.class);
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final File finalizedDir;
    private final File rbwDir;
    private final File tmpDir;
    private static String DU_CACHE_FILE = "dfsUsed";
    private volatile boolean dfsUsedSaved = false;
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final String REPLICA_CACHE_FILE = "replicas";
    private final long replicaCacheExpiry = 300000L;
    private final GetSpaceUsed dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.currentDir = new File(bpDir, "current");
        this.finalizedDir = new File(this.currentDir, "finalized");
        if (!this.finalizedDir.exists() && !this.finalizedDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + this.finalizedDir);
        }
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            FileUtil.fullyDelete(this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        boolean supportAppends = conf.getBoolean("dfs.support.append", true);
        if (this.rbwDir.exists() && !supportAppends) {
            FileUtil.fullyDelete(this.rbwDir);
        }
        if (!this.rbwDir.mkdirs() && !this.rbwDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.rbwDir.toString());
        }
        if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
        }
        this.dfsUsage = new GetSpaceUsed.Builder().setPath(bpDir).setConf(conf).setInitialUsed(this.loadDfsUsed()).build();
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                if (!BlockPoolSlice.this.dfsUsedSaved) {
                    BlockPoolSlice.this.saveDfsUsed();
                }
            }
        }, 30);
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    File getTmpDir() {
        return this.tmpDir;
    }

    void decDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(-value);
        }
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    void incDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadDfsUsed() {
        Scanner sc;
        try {
            sc = new Scanner(new File(this.currentDir, DU_CACHE_FILE), "UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedDfsUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && Time.now() - mtime < 600000L) {
                FsDatasetImpl.LOG.info((Object)("Cached dfsUsed found for " + this.currentDir + ": " + cachedDfsUsed));
                long l = cachedDfsUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    void saveDfsUsed() {
        File outFile = new File(this.currentDir, DU_CACHE_FILE);
        if (outFile.exists() && !outFile.delete()) {
            FsDatasetImpl.LOG.warn((Object)("Failed to delete old dfsUsed file in " + outFile.getParent()));
        }
        try {
            long used = this.getDfsUsed();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
                out.write(Long.toString(used) + " " + Long.toString(Time.now()));
                ((Writer)out).flush();
            }
        }
        catch (IOException ioe) {
            FsDatasetImpl.LOG.warn((Object)("Failed to write dfsUsed to " + outFile), (Throwable)ioe);
        }
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File addBlock(Block b, File f) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        if (!blockDir.exists() && !blockDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + blockDir);
        }
        File blockFile = FsDatasetImpl.moveBlockFiles(b, f, blockDir);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(b.getNumBytes() + metaFile.length());
        }
        return blockFile;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDir(this.finalizedDir);
        DiskChecker.checkDir(this.tmpDir);
        DiskChecker.checkDir(this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap) throws IOException {
        boolean success = this.readReplicasFromCache(volumeMap);
        if (!success) {
            this.addToReplicasMap(volumeMap, this.finalizedDir, true);
            this.addToReplicasMap(volumeMap, this.rbwDir, false);
        }
    }

    File recoverTempUnlinkedBlock(File unlinkedTmp) throws IOException {
        File blockFile = FsDatasetUtil.getOrigFile(unlinkedTmp);
        if (blockFile.exists()) {
            if (!unlinkedTmp.delete()) {
                throw new IOException("Unable to cleanup unlinked tmp file " + unlinkedTmp);
            }
            return null;
        }
        if (!unlinkedTmp.renameTo(blockFile)) {
            throw new IOException("Unable to rename unlinked tmp file " + unlinkedTmp);
        }
        return blockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicaToReplicasMap(Block block, ReplicaMap volumeMap, boolean isFinalized) throws IOException {
        ReplicaInfo newReplica = null;
        long blockId = block.getBlockId();
        long genStamp = block.getGenerationStamp();
        if (isFinalized) {
            newReplica = new FinalizedReplica(blockId, block.getNumBytes(), genStamp, this.volume, DatanodeUtil.idToBlockDir(this.finalizedDir, blockId));
        } else {
            File file = new File(this.rbwDir, block.getBlockName());
            boolean loadRwr = true;
            File restartMeta = new File(file.getParent() + File.pathSeparator + "." + file.getName() + ".restart");
            try (Scanner sc = null;){
                sc = new Scanner(restartMeta, "UTF-8");
                if (sc.hasNextLong() && sc.nextLong() > Time.now()) {
                    newReplica = new ReplicaBeingWritten(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile(), null, 0L);
                    loadRwr = false;
                }
                sc.close();
                if (!restartMeta.delete()) {
                    FsDatasetImpl.LOG.warn((Object)("Failed to delete restart meta file: " + restartMeta.getPath()));
                }
            }
            if (loadRwr) {
                newReplica = new ReplicaWaitingToBeRecovered(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile());
            }
        }
        ReplicaInfo oldReplica = volumeMap.get(this.bpid, newReplica.getBlockId());
        if (oldReplica == null) {
            volumeMap.add(this.bpid, newReplica);
        } else {
            FsDatasetImpl.LOG.warn((Object)("Two block files with the same block id exist on disk: " + oldReplica.getBlockFile() + " and " + newReplica.getBlockFile()));
        }
    }

    void addToReplicasMap(ReplicaMap volumeMap, File dir, boolean isFinalized) throws IOException {
        File[] files;
        for (File file : files = FileUtil.listFiles(dir)) {
            if (file.isDirectory()) {
                this.addToReplicasMap(volumeMap, file, isFinalized);
            }
            if (isFinalized && FsDatasetUtil.isUnlinkTmpFile(file) && (file = this.recoverTempUnlinkedBlock(file)) == null || !Block.isBlockFilename(file)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(files, file);
            long blockId = Block.filename2id(file.getName());
            Block block = new Block(blockId, file.length(), genStamp);
            this.addReplicaToReplicasMap(block, volumeMap, isFinalized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long validateIntegrityAndSetLength(File blockFile, long genStamp) {
        long l;
        FileInputStream blockIn;
        DataInputStream checksumIn;
        block16: {
            long l2;
            block14: {
                checksumIn = null;
                blockIn = null;
                try {
                    int checksumSize;
                    DataChecksum checksum;
                    int bytesPerChecksum;
                    long numChunks;
                    File metaFile = FsDatasetUtil.getMetaFile(blockFile, genStamp);
                    long blockFileLen = blockFile.length();
                    long metaFileLen = metaFile.length();
                    int crcHeaderLen = DataChecksum.getChecksumHeaderSize();
                    if (!blockFile.exists() || blockFileLen == 0L || !metaFile.exists() || metaFileLen < (long)crcHeaderLen) {
                        long l3 = 0L;
                        return l3;
                    }
                    checksumIn = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), HdfsConstants.IO_FILE_BUFFER_SIZE));
                    BlockMetadataHeader header = BlockMetadataHeader.readHeader(checksumIn);
                    short version = header.getVersion();
                    if (version != 1) {
                        FsDatasetImpl.LOG.warn((Object)("Wrong version (" + version + ") for metadata file " + metaFile + " ignoring ..."));
                    }
                    if ((numChunks = Math.min((blockFileLen + (long)(bytesPerChecksum = (checksum = header.getChecksum()).getBytesPerChecksum()) - 1L) / (long)bytesPerChecksum, (metaFileLen - (long)crcHeaderLen) / (long)(checksumSize = checksum.getChecksumSize()))) == 0L) {
                        l2 = 0L;
                        IOUtils.closeStream(checksumIn);
                        break block14;
                    }
                    IOUtils.skipFully(checksumIn, (numChunks - 1L) * (long)checksumSize);
                    blockIn = new FileInputStream(blockFile);
                    long lastChunkStartPos = (numChunks - 1L) * (long)bytesPerChecksum;
                    IOUtils.skipFully(blockIn, lastChunkStartPos);
                    int lastChunkSize = (int)Math.min((long)bytesPerChecksum, blockFileLen - lastChunkStartPos);
                    byte[] buf = new byte[lastChunkSize + checksumSize];
                    checksumIn.readFully(buf, lastChunkSize, checksumSize);
                    IOUtils.readFully(blockIn, buf, 0, lastChunkSize);
                    checksum.update(buf, 0, lastChunkSize);
                    long validFileLength = checksum.compare(buf, lastChunkSize) ? lastChunkStartPos + (long)lastChunkSize : lastChunkStartPos;
                    if (blockFile.length() > validFileLength) {
                        try (RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");){
                            blockRAF.setLength(validFileLength);
                        }
                    }
                    l = validFileLength;
                    IOUtils.closeStream(checksumIn);
                    break block16;
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.warn((Object)e);
                    long l4 = 0L;
                    return l4;
                }
            }
            IOUtils.closeStream(blockIn);
            return l2;
        }
        IOUtils.closeStream(blockIn);
        return l;
        finally {
            IOUtils.closeStream(checksumIn);
            IOUtils.closeStream(blockIn);
        }
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown(BlockReport blocksListToPersist) {
        this.saveReplicas(blocksListToPersist);
        this.saveDfsUsed();
        this.dfsUsedSaved = true;
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            IOUtils.cleanup(LOG, (CachingGetSpaceUsed)this.dfsUsage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readReplicasFromCache(ReplicaMap volumeMap) {
        ReplicaMap tmpReplicaMap = new ReplicaMap(this);
        File replicaFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (!replicaFile.exists()) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " doesn't exist "));
            return false;
        }
        long fileLastModifiedTime = replicaFile.lastModified();
        if (System.currentTimeMillis() > fileLastModifiedTime + 300000L) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " has gone stale"));
            if (!replicaFile.delete()) {
                LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " cannot be deleted"));
            }
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(replicaFile);
            BlockReport blocksList = BlockReport.readFrom(inputStream);
            for (BlockListAsLongs.BlockReportReplica replica : blocksList) {
                switch (replica.getState()) {
                    case FINALIZED: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, true);
                        break;
                    }
                    case RUR: 
                    case RBW: 
                    case RWR: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, false);
                        break;
                    }
                }
            }
            inputStream.close();
            for (ReplicaInfo info : tmpReplicaMap.replicas(this.bpid)) {
                volumeMap.add(this.bpid, info);
            }
            LOG.info((Object)("Successfully read replica from cache file : " + replicaFile.getPath()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.info((Object)("Exception occured while reading the replicas cache file: " + replicaFile.getPath()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!replicaFile.delete()) {
                LOG.info((Object)("Failed to delete replica cache file: " + replicaFile.getPath()));
            }
            IOUtils.closeStream(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReplicas(BlockReport blocksListToPersist) {
        if (blocksListToPersist == null || blocksListToPersist.getNumberOfBlocks() == 0) {
            return;
        }
        File tmpFile = new File(this.currentDir, "replicas.tmp");
        if (tmpFile.exists() && !tmpFile.delete()) {
            LOG.warn((Object)("Failed to delete tmp replicas file in " + tmpFile.getPath()));
            return;
        }
        File replicaCacheFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (replicaCacheFile.exists() && !replicaCacheFile.delete()) {
            LOG.warn((Object)("Failed to delete replicas file in " + replicaCacheFile.getPath()));
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tmpFile);
            blocksListToPersist.writeTo(out);
            out.close();
            Files.move((File)tmpFile, (File)replicaCacheFile);
        }
        catch (Exception e) {
            block10: {
                try {
                    LOG.warn((Object)"Failed to write replicas to cache ", (Throwable)e);
                    if (!replicaCacheFile.exists() || replicaCacheFile.delete()) break block10;
                    LOG.warn((Object)("Failed to delete replicas file: " + replicaCacheFile.getPath()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    if (tmpFile.exists() && !tmpFile.delete()) {
                        LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
                    }
                    throw throwable;
                }
            }
            IOUtils.closeStream(out);
            if (tmpFile.exists() && !tmpFile.delete()) {
                LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
            }
        }
        IOUtils.closeStream(out);
        if (tmpFile.exists() && !tmpFile.delete()) {
            LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
        }
    }
}

