/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.hops.hadoop.shaded.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinished;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private TaskAttemptFinished datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String taskStatus;
    private long finishTime;
    private String rackName;
    private String hostname;
    private String state;
    private Counters counters;
    private long startTime;

    public TaskAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long finishTime, String rackName, String hostname, String state, Counters counters, long startTs) {
        this.attemptId = id;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.finishTime = finishTime;
        this.rackName = rackName;
        this.hostname = hostname;
        this.state = state;
        this.counters = counters;
        this.startTime = startTs;
    }

    public TaskAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long finishTime, String rackName, String hostname, String state, Counters counters) {
        this(id, taskType, taskStatus, finishTime, rackName, hostname, state, counters, SystemClock.getInstance().getTime());
    }

    TaskAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskAttemptFinished();
            this.datum.setTaskid((CharSequence)new Utf8(this.attemptId.getTaskID().toString()));
            this.datum.setAttemptId((CharSequence)new Utf8(this.attemptId.toString()));
            this.datum.setTaskType((CharSequence)new Utf8(this.taskType.name()));
            this.datum.setTaskStatus((CharSequence)new Utf8(this.taskStatus));
            this.datum.setFinishTime(this.finishTime);
            if (this.rackName != null) {
                this.datum.setRackname((CharSequence)new Utf8(this.rackName));
            }
            this.datum.setHostname((CharSequence)new Utf8(this.hostname));
            this.datum.setState((CharSequence)new Utf8(this.state));
            this.datum.setCounters(EventWriter.toAvro(this.counters));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (TaskAttemptFinished)((Object)oDatum);
        this.attemptId = TaskAttemptID.forName(this.datum.getAttemptId().toString());
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.taskStatus = this.datum.getTaskStatus().toString();
        this.finishTime = this.datum.getFinishTime();
        this.rackName = this.datum.getRackname().toString();
        this.hostname = this.datum.getHostname().toString();
        this.state = this.datum.getState().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskAttemptID getAttemptId() {
        return this.attemptId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.taskStatus.toString();
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getHostname() {
        return this.hostname.toString();
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getState() {
        return this.state.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return this.getTaskId().getTaskType() == TaskType.MAP ? EventType.MAP_ATTEMPT_FINISHED : EventType.REDUCE_ATTEMPT_FINISHED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", this.getTaskType().toString());
        tEvent.addInfo("ATTEMPT_ID", this.getAttemptId() == null ? "" : this.getAttemptId().toString());
        tEvent.addInfo("FINISH_TIME", this.getFinishTime());
        tEvent.addInfo("STATUS", this.getTaskStatus());
        tEvent.addInfo("STATE", this.getState());
        tEvent.addInfo("HOSTNAME", this.getHostname());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> metrics = JobHistoryEventUtils.countersToTimelineMetric(this.getCounters(), this.finishTime);
        return metrics;
    }
}

