/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.http;

import io.hops.hadoop.shaded.javax.servlet.Filter;
import io.hops.hadoop.shaded.javax.servlet.FilterChain;
import io.hops.hadoop.shaded.javax.servlet.FilterConfig;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class XFrameOptionsFilter
implements Filter {
    public static final String X_FRAME_OPTIONS = "X-Frame-Options";
    public static final String CUSTOM_HEADER_PARAM = "xframe-options";
    private String option = "DENY";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader(X_FRAME_OPTIONS, this.option);
        chain.doFilter(req, (ServletResponse)new XFrameOptionsResponseWrapper((HttpServletResponse)res));
    }

    public void init(FilterConfig config) throws ServletException {
        String customOption = config.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customOption != null) {
            this.option = customOption;
        }
    }

    public static Map<String, String> getFilterParams(Configuration conf, String confPrefix) {
        return conf.getPropsWithPrefix(confPrefix);
    }

    public class XFrameOptionsResponseWrapper
    extends HttpServletResponseWrapper {
        public XFrameOptionsResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void addHeader(String name, String value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.setHeader(name, value);
            }
        }

        public void setDateHeader(String name, long date) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.setDateHeader(name, date);
            }
        }

        public void addDateHeader(String name, long date) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.addDateHeader(name, date);
            }
        }

        public void setIntHeader(String name, int value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.setIntHeader(name, value);
            }
        }

        public void addIntHeader(String name, int value) {
            if (!name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                super.addIntHeader(name, value);
            }
        }

        public boolean containsHeader(String name) {
            boolean contains = false;
            if (name.equals(XFrameOptionsFilter.X_FRAME_OPTIONS)) {
                return XFrameOptionsFilter.this.option != null;
            }
            super.containsHeader(name);
            return contains;
        }
    }
}

