/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.ipc.RPC;

@InterfaceAudience.Private
public class HAUtil {
    private static final Log LOG = LogFactory.getLog(HAUtil.class);
    private static final DelegationTokenSelector tokenSelector = new DelegationTokenSelector();

    private HAUtil() {
    }

    public static boolean isHAEnabled(Configuration conf, String nsId) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        if (addresses == null) {
            return false;
        }
        Map<String, InetSocketAddress> nnMap = addresses.get(nsId);
        return nnMap != null && nnMap.size() > 1;
    }

    public static String getNameNodeIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        if (ids != null && ids.length > 1) {
            return ids[1];
        }
        return null;
    }

    public static InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs + " is not a DFS.");
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress(dfsClient.getNamenode());
    }
}

