/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.sun.jersey.api.ParamException;
import io.hops.hadoop.shaded.com.sun.jersey.api.container.ContainerException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import io.hops.hadoop.shaded.javax.ws.rs.core.Response;
import io.hops.hadoop.shaded.javax.ws.rs.ext.ExceptionMapper;
import io.hops.hadoop.shaded.javax.ws.rs.ext.Provider;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    public static final Log LOG = LogFactory.getLog(ExceptionHandler.class);
    @Context
    private HttpServletResponse response;

    private static Exception toCause(Exception e) {
        Throwable t = e.getCause();
        if (e instanceof SecurityException) {
            Throwable t1;
            if (t != null && t instanceof SecretManager.InvalidToken && (t1 = t.getCause()) != null && t1 instanceof StandbyException) {
                e = (StandbyException)t1;
            }
        } else if (t != null && t instanceof Exception) {
            e = (Exception)t;
        }
        return e;
    }

    public Response toResponse(Exception e) {
        Response.Status s;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"GOT EXCEPITION", (Throwable)e);
        }
        this.response.setContentType(null);
        if (e instanceof ParamException) {
            ParamException paramexception = (ParamException)e;
            e = new IllegalArgumentException("Invalid value for webhdfs parameter \"" + paramexception.getParameterName() + "\": " + e.getCause().getMessage(), e);
        }
        if (e instanceof ContainerException) {
            e = ExceptionHandler.toCause(e);
        }
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            e = ExceptionHandler.toCause(e);
        }
        if (e instanceof SecurityException) {
            s = Response.Status.FORBIDDEN;
        } else if (e instanceof AuthorizationException) {
            s = Response.Status.FORBIDDEN;
        } else if (e instanceof FileNotFoundException) {
            s = Response.Status.NOT_FOUND;
        } else if (e instanceof IOException) {
            s = Response.Status.FORBIDDEN;
        } else if (e instanceof UnsupportedOperationException) {
            s = Response.Status.BAD_REQUEST;
        } else if (e instanceof IllegalArgumentException) {
            s = Response.Status.BAD_REQUEST;
        } else {
            LOG.warn((Object)"INTERNAL_SERVER_ERROR", (Throwable)e);
            s = Response.Status.INTERNAL_SERVER_ERROR;
        }
        String js = JsonUtil.toJsonString(e);
        return Response.status((Response.Status)s).type("application/json").entity((Object)js).build();
    }

    @VisibleForTesting
    public void initResponse(HttpServletResponse response) {
        this.response = response;
    }
}

