/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.dal.FileProvenanceDataAccess;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Objects;

public class FileProvenanceContext
extends BaseEntityContext<DBKey, FileProvenanceEntry> {
    private final FileProvenanceDataAccess<FileProvenanceEntry> dataAccess;

    public FileProvenanceContext(FileProvenanceDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void add(FileProvenanceEntry logEntry) throws TransactionContextException {
        DBKey dbKey = this.getKey(logEntry);
        if (this.get(dbKey) != null) {
            throw new RuntimeException("Conflicting logical time in the ProvenanceLogEntry");
        }
        super.add((Object)logEntry);
        this.log("provenance-log-added", new Object[]{"inodeId", logEntry.getInodeId(), "userId", logEntry.getUserId(), "appId", logEntry.getAppId(), "operation", logEntry.getOperationEnumVal()});
    }

    DBKey getKey(FileProvenanceEntry logEntry) {
        return new DBKey(logEntry.getInodeId(), logEntry.getUserId(), logEntry.getAppId(), logEntry.getTimestamp(), logEntry.getLogicalTime(), logEntry.getOperation());
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.addAll(this.getAdded());
    }

    class DBKey {
        private final long inodeId;
        private final int userId;
        private final String appId;
        private final long timestamp;
        private final long logicalTime;
        private final String operation;

        public DBKey(long inodeId, int userId, String appId, long timestamp, long logicalTime, String operation) {
            this.inodeId = inodeId;
            this.userId = userId;
            this.appId = appId;
            this.timestamp = timestamp;
            this.logicalTime = logicalTime;
            this.operation = operation;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + (int)(this.inodeId ^ this.inodeId >>> 32);
            hash = 17 * hash + this.userId;
            hash = 17 * hash + Objects.hashCode(this.appId);
            hash = 17 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DBKey other = (DBKey)obj;
            if (this.inodeId != other.inodeId) {
                return false;
            }
            if (this.userId != other.userId) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return Objects.equals(this.appId, other.appId);
        }
    }
}

