/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.filter;

import com.google.common.collect.Maps;
import io.hops.hadoop.shaded.com.google.re2j.Matcher;
import io.hops.hadoop.shaded.com.google.re2j.Pattern;
import io.hops.hadoop.shaded.org.apache.commons.configuration2.SubsetConfiguration;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Private
public abstract class AbstractPatternFilter
extends MetricsFilter {
    protected static final String INCLUDE_KEY = "include";
    protected static final String EXCLUDE_KEY = "exclude";
    protected static final String INCLUDE_TAGS_KEY = "include.tags";
    protected static final String EXCLUDE_TAGS_KEY = "exclude.tags";
    private Pattern includePattern;
    private Pattern excludePattern;
    private final Map<String, Pattern> includeTagPatterns;
    private final Map<String, Pattern> excludeTagPatterns;
    private final Pattern tagPattern = Pattern.compile((String)"^(\\w+):(.*)");

    AbstractPatternFilter() {
        this.includeTagPatterns = Maps.newHashMap();
        this.excludeTagPatterns = Maps.newHashMap();
    }

    @Override
    public void init(SubsetConfiguration conf) {
        Matcher matcher;
        String[] patternStrings;
        String patternString = conf.getString(INCLUDE_KEY);
        if (patternString != null && !patternString.isEmpty()) {
            this.setIncludePattern(this.compile(patternString));
        }
        if ((patternString = conf.getString(EXCLUDE_KEY)) != null && !patternString.isEmpty()) {
            this.setExcludePattern(this.compile(patternString));
        }
        if ((patternStrings = conf.getStringArray(INCLUDE_TAGS_KEY)) != null && patternStrings.length != 0) {
            for (String pstr : patternStrings) {
                matcher = this.tagPattern.matcher((CharSequence)pstr);
                if (!matcher.matches()) {
                    throw new MetricsException("Illegal tag pattern: " + pstr);
                }
                this.setIncludeTagPattern(matcher.group(1), this.compile(matcher.group(2)));
            }
        }
        if ((patternStrings = conf.getStringArray(EXCLUDE_TAGS_KEY)) != null && patternStrings.length != 0) {
            for (String pstr : patternStrings) {
                matcher = this.tagPattern.matcher((CharSequence)pstr);
                if (!matcher.matches()) {
                    throw new MetricsException("Illegal tag pattern: " + pstr);
                }
                this.setExcludeTagPattern(matcher.group(1), this.compile(matcher.group(2)));
            }
        }
    }

    void setIncludePattern(Pattern includePattern) {
        this.includePattern = includePattern;
    }

    void setExcludePattern(Pattern excludePattern) {
        this.excludePattern = excludePattern;
    }

    void setIncludeTagPattern(String name, Pattern pattern) {
        this.includeTagPatterns.put(name, pattern);
    }

    void setExcludeTagPattern(String name, Pattern pattern) {
        this.excludeTagPatterns.put(name, pattern);
    }

    @Override
    public boolean accepts(MetricsTag tag) {
        Pattern ipat = this.includeTagPatterns.get(tag.name());
        if (ipat != null && ipat.matcher((CharSequence)tag.value()).matches()) {
            return true;
        }
        Pattern epat = this.excludeTagPatterns.get(tag.name());
        if (epat != null && epat.matcher((CharSequence)tag.value()).matches()) {
            return false;
        }
        return this.includeTagPatterns.isEmpty() || !this.excludeTagPatterns.isEmpty();
    }

    @Override
    public boolean accepts(Iterable<MetricsTag> tags) {
        Pattern pat;
        for (MetricsTag t : tags) {
            pat = this.includeTagPatterns.get(t.name());
            if (pat == null || !pat.matcher((CharSequence)t.value()).matches()) continue;
            return true;
        }
        for (MetricsTag t : tags) {
            pat = this.excludeTagPatterns.get(t.name());
            if (pat == null || !pat.matcher((CharSequence)t.value()).matches()) continue;
            return false;
        }
        return this.includeTagPatterns.isEmpty() || !this.excludeTagPatterns.isEmpty();
    }

    @Override
    public boolean accepts(String name) {
        if (this.includePattern != null && this.includePattern.matcher((CharSequence)name).matches()) {
            return true;
        }
        if (this.excludePattern != null && this.excludePattern.matcher((CharSequence)name).matches()) {
            return false;
        }
        return this.includePattern == null || this.excludePattern != null;
    }

    protected abstract Pattern compile(String var1);
}

