/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import io.hops.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PathOutputCommitterFactory
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(PathOutputCommitterFactory.class);
    public static final String COMMITTER_FACTORY_CLASS = "mapreduce.outputcommitter.factory.class";
    public static final String COMMITTER_FACTORY_SCHEME = "mapreduce.outputcommitter.factory.scheme";
    public static final String COMMITTER_FACTORY_SCHEME_PATTERN = "mapreduce.outputcommitter.factory.scheme.%s";
    public static final String FILE_COMMITTER_FACTORY = "org.apache.hadoop.mapreduce.lib.output.FileOutputCommitterFactory";
    public static final String NAMED_COMMITTER_FACTORY = "org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory";
    public static final String NAMED_COMMITTER_CLASS = "mapreduce.outputcommitter.named.classname";
    public static final String COMMITTER_FACTORY_DEFAULT = "org.apache.hadoop.mapreduce.lib.output.FileOutputCommitterFactory";

    public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        return this.createFileOutputCommitter(outputPath, context);
    }

    protected final PathOutputCommitter createFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        LOG.debug("Creating FileOutputCommitter for path {} and context {}", (Object)outputPath, (Object)context);
        return new FileOutputCommitter(outputPath, context);
    }

    public static PathOutputCommitterFactory getCommitterFactory(Path outputPath, Configuration conf) {
        Class factory;
        String trimmedValue;
        LOG.debug("Looking for committer factory for path {}", (Object)outputPath);
        String key = COMMITTER_FACTORY_CLASS;
        if (StringUtils.isEmpty((CharSequence)conf.getTrimmed(key)) && outputPath != null) {
            String scheme = outputPath.toUri().getScheme();
            String schemeKey = String.format(COMMITTER_FACTORY_SCHEME_PATTERN, scheme);
            if (StringUtils.isNotEmpty((CharSequence)conf.getTrimmed(schemeKey))) {
                LOG.debug("Using schema-specific factory for {}", (Object)outputPath);
                key = schemeKey;
            } else {
                LOG.debug("No scheme-specific factory defined in {}", (Object)schemeKey);
            }
        }
        if (StringUtils.isEmpty((CharSequence)(trimmedValue = conf.getTrimmed(key, "")))) {
            LOG.debug("No output committer factory defined, defaulting to FileOutputCommitterFactory");
            factory = FileOutputCommitterFactory.class;
        } else {
            factory = conf.getClass(key, FileOutputCommitterFactory.class, PathOutputCommitterFactory.class);
            LOG.debug("Using OutputCommitter factory class {} from key {}", factory, (Object)key);
        }
        return ReflectionUtils.newInstance(factory, conf);
    }

    public static PathOutputCommitter createCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        return PathOutputCommitterFactory.getCommitterFactory(outputPath, context.getConfiguration()).createOutputCommitter(outputPath, context);
    }
}

