/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.hops.hadoop.shaded.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChange;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobInfoChangeEvent
implements HistoryEvent {
    private JobInfoChange datum = new JobInfoChange();

    public JobInfoChangeEvent(JobID id, long submitTime, long launchTime) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setSubmitTime(submitTime);
        this.datum.setLaunchTime(launchTime);
    }

    JobInfoChangeEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobInfoChange)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public long getSubmitTime() {
        return this.datum.getSubmitTime();
    }

    public long getLaunchTime() {
        return this.datum.getLaunchTime();
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_INFO_CHANGED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("SUBMIT_TIME", this.getSubmitTime());
        tEvent.addInfo("LAUNCH_TIME", this.getLaunchTime());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

