/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

public class ReplicaUnderRecovery
extends ReplicaInfo {
    private ReplicaInfo original;
    private long recoveryId;

    public ReplicaUnderRecovery(ReplicaInfo replica, long recoveryId) {
        super(replica.getBlockId(), replica.getNumBytes(), replica.getGenerationStamp(), replica.getVolume(), replica.getDir());
        if (replica.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replica.getState() != HdfsServerConstants.ReplicaState.RBW && replica.getState() != HdfsServerConstants.ReplicaState.RWR) {
            throw new IllegalArgumentException("Cannot recover replica: " + replica);
        }
        this.original = replica;
        this.recoveryId = recoveryId;
    }

    public ReplicaUnderRecovery(ReplicaUnderRecovery from) {
        super(from);
        this.original = from.getOriginalReplica();
        this.recoveryId = from.getRecoveryID();
    }

    public long getRecoveryID() {
        return this.recoveryId;
    }

    public void setRecoveryID(long recoveryId) {
        if (recoveryId <= this.recoveryId) {
            throw new IllegalArgumentException("The new rcovery id: " + recoveryId + " must be greater than the current one: " + this.recoveryId);
        }
        this.recoveryId = recoveryId;
    }

    public ReplicaInfo getOriginalReplica() {
        return this.original;
    }

    @Override
    public boolean isUnlinked() {
        return this.original.isUnlinked();
    }

    @Override
    public void setUnlinked() {
        this.original.setUnlinked();
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.RUR;
    }

    @Override
    public long getVisibleLength() {
        return this.original.getVisibleLength();
    }

    @Override
    public long getBytesOnDisk() {
        return this.original.getBytesOnDisk();
    }

    @Override
    public void setBlockIdNoPersistance(long blockId) {
        super.setBlockIdNoPersistance(blockId);
        this.original.setBlockIdNoPersistance(blockId);
    }

    @Override
    public void setGenerationStampNoPersistance(long gs) {
        super.setGenerationStampNoPersistance(gs);
        this.original.setGenerationStampNoPersistance(gs);
    }

    @Override
    public void setNumBytesNoPersistance(long numBytes) {
        super.setNumBytesNoPersistance(numBytes);
        this.original.setNumBytesNoPersistance(numBytes);
    }

    @Override
    public void setDir(File dir) {
        super.setDir(dir);
        this.original.setDir(dir);
    }

    @Override
    void setVolume(FsVolumeSpi vol) {
        super.setVolume(vol);
        this.original.setVolume(vol);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "\n  recoveryId=" + this.recoveryId + "\n  original=" + this.original;
    }

    public ReplicaRecoveryInfo createInfo() {
        return new ReplicaRecoveryInfo(this.original.getBlockId(), this.original.getBytesOnDisk(), this.original.getGenerationStamp(), this.original.getState());
    }
}

