/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.Client;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientHandler;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientRequest;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.config.ClientConfig;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.config.DefaultClientConfig;
import io.hops.hadoop.shaded.com.sun.jersey.api.client.filter.ClientFilter;
import io.hops.hadoop.shaded.com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import io.hops.hadoop.shaded.com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

public class TimelineConnector
extends AbstractService {
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Log LOG = LogFactory.getLog(TimelineConnector.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private SSLFactory sslFactory;
    private Client client;
    private ConnectionConfigurator connConfigurator;
    private DelegationTokenAuthenticator authenticator;
    private DelegationTokenAuthenticatedURL.Token token;
    private UserGroupInformation authUgi;
    private String doAsUser;
    @VisibleForTesting
    TimelineClientConnectionRetry connectionRetry;
    private boolean requireConnectionRetry;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        @Override
        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            TimelineConnector.setTimeouts(conn, 60000);
            return conn;
        }
    };

    public TimelineConnector(boolean requireConnectionRetry, UserGroupInformation authUgi, String doAsUser, DelegationTokenAuthenticatedURL.Token token) {
        super("TimelineConnector");
        this.requireConnectionRetry = requireConnectionRetry;
        this.authUgi = authUgi;
        this.doAsUser = doAsUser;
        this.token = token;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        if (YarnConfiguration.useHttps(conf)) {
            this.sslFactory = this.getSSLFactory(conf);
            this.connConfigurator = this.getConnConfigurator(this.sslFactory);
        } else {
            this.connConfigurator = DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
        this.authenticator = UserGroupInformation.isSecurityEnabled() ? new KerberosDelegationTokenAuthenticator() : new PseudoDelegationTokenAuthenticator();
        this.authenticator.setConnectionConfigurator(this.connConfigurator);
        this.connectionRetry = new TimelineClientConnectionRetry(conf);
        this.client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new TimelineURLConnectionFactory(this.authUgi, this.authenticator, this.connConfigurator, this.token, this.doAsUser)), (ClientConfig)cc);
        if (this.requireConnectionRetry) {
            TimelineJerseyRetryFilter retryFilter = new TimelineJerseyRetryFilter(this.connectionRetry);
            this.client.addFilter((ClientFilter)retryFilter);
        }
    }

    private ConnectionConfigurator getConnConfigurator(SSLFactory sslFactoryObj) {
        try {
            return TimelineConnector.initSslConnConfigurator(60000, sslFactoryObj);
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
    }

    private static ConnectionConfigurator initSslConnConfigurator(final int timeout, SSLFactory sslFactory) throws IOException, GeneralSecurityException {
        final SSLSocketFactory sf = sslFactory.createSSLSocketFactory();
        final HostnameVerifier hv = sslFactory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                TimelineConnector.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    protected SSLFactory getSSLFactory(Configuration conf) throws GeneralSecurityException, IOException {
        SSLFactory newSSLFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        newSSLFactory.init();
        return newSSLFactory;
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    public static URI constructResURI(Configuration conf, String address, String uri) {
        return URI.create(JOINER.join((Object)(YarnConfiguration.useHttps(conf) ? "https://" : "http://"), (Object)address, new Object[]{uri}));
    }

    DelegationTokenAuthenticatedURL getDelegationTokenAuthenticatedURL() {
        return new DelegationTokenAuthenticatedURL(this.authenticator, this.connConfigurator);
    }

    @Override
    protected void serviceStop() {
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Object operateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException, YarnException {
        TimelineClientRetryOp tokenRetryOp = this.createRetryOpForOperateDelegationToken(action);
        return this.connectionRetry.retryOn(tokenRetryOp);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    TimelineClientRetryOp createRetryOpForOperateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException {
        return new TimelineClientRetryOpForOperateDelegationToken(this.authUgi, action);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class TimelineClientRetryOpForOperateDelegationToken
    extends TimelineClientRetryOp {
        private final UserGroupInformation authUgi;
        private final PrivilegedExceptionAction<?> action;

        public TimelineClientRetryOpForOperateDelegationToken(UserGroupInformation authUgi, PrivilegedExceptionAction<?> action) {
            this.authUgi = authUgi;
            this.action = action;
        }

        @Override
        public Object run() throws IOException {
            this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return this.authUgi.doAs(this.action);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean shouldRetryOn(Exception e) {
            return e instanceof ConnectException || e instanceof SocketTimeoutException;
        }
    }

    private static class TimelineJerseyRetryFilter
    extends ClientFilter {
        private TimelineClientConnectionRetry connectionRetry;

        public TimelineJerseyRetryFilter(TimelineClientConnectionRetry connectionRetry) {
            this.connectionRetry = connectionRetry;
        }

        public ClientResponse handle(final ClientRequest cr) throws ClientHandlerException {
            TimelineClientRetryOp jerseyRetryOp = new TimelineClientRetryOp(){

                @Override
                public Object run() {
                    return this.getNext().handle(cr);
                }

                @Override
                public boolean shouldRetryOn(Exception e) {
                    return e instanceof ClientHandlerException && (e.getCause() instanceof ConnectException || e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof SocketException);
                }
            };
            try {
                return (ClientResponse)this.connectionRetry.retryOn(jerseyRetryOp);
            }
            catch (IOException e) {
                throw new ClientHandlerException("Jersey retry failed!\nMessage: " + e.getMessage());
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static class TimelineClientConnectionRetry {
        @InterfaceAudience.Private
        @VisibleForTesting
        public int maxRetries;
        @InterfaceAudience.Private
        @VisibleForTesting
        public long retryInterval;
        private boolean retried = false;

        @InterfaceAudience.Private
        @VisibleForTesting
        boolean getRetired() {
            return this.retried;
        }

        public TimelineClientConnectionRetry(Configuration conf) {
            Preconditions.checkArgument((conf.getInt("yarn.timeline-service.client.max-retries", 30) >= -1 ? 1 : 0) != 0, (String)"%s property value should be greater than or equal to -1", (Object[])new Object[]{"yarn.timeline-service.client.max-retries"});
            Preconditions.checkArgument((conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L) > 0L ? 1 : 0) != 0, (String)"%s property value should be greater than zero", (Object[])new Object[]{"yarn.timeline-service.client.retry-interval-ms"});
            this.maxRetries = conf.getInt("yarn.timeline-service.client.max-retries", 30);
            this.retryInterval = conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L);
        }

        public Object retryOn(TimelineClientRetryOp op) throws RuntimeException, IOException {
            int leftRetries = this.maxRetries;
            this.retried = false;
            while (true) {
                try {
                    return op.run();
                }
                catch (IOException | RuntimeException e) {
                    if (leftRetries != 0) {
                        if (!op.shouldRetryOn(e)) {
                            throw e;
                        }
                        this.logException(e, leftRetries);
                        if (leftRetries > 0) {
                            --leftRetries;
                        }
                        this.retried = true;
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)"Client retry sleep interrupted! ");
                        }
                        continue;
                    }
                    throw new RuntimeException("Failed to connect to timeline server. Connection retries limit exceeded. The posted timeline event may be missing");
                }
                break;
            }
        }

        private void logException(Exception e, int leftRetries) {
            if (leftRetries > 0) {
                LOG.info((Object)("Exception caught by TimelineClientConnectionRetry, will try " + leftRetries + " more time(s).\nMessage: " + e.getMessage()));
            } else {
                LOG.info((Object)("ConnectionException caught by TimelineClientConnectionRetry, will keep retrying.\nMessage: " + e.getMessage()));
            }
        }
    }

    private static class TimelineURLConnectionFactory
    implements HttpURLConnectionFactory {
        private DelegationTokenAuthenticator authenticator;
        private UserGroupInformation authUgi;
        private ConnectionConfigurator connConfigurator;
        private DelegationTokenAuthenticatedURL.Token token;
        private String doAsUser;

        public TimelineURLConnectionFactory(UserGroupInformation authUgi, DelegationTokenAuthenticator authenticator, ConnectionConfigurator connConfigurator, DelegationTokenAuthenticatedURL.Token token, String doAsUser) {
            this.authUgi = authUgi;
            this.authenticator = authenticator;
            this.connConfigurator = connConfigurator;
            this.token = token;
            this.doAsUser = doAsUser;
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return new DelegationTokenAuthenticatedURL(this.authenticator, this.connConfigurator).openConnection(url, this.token, this.doAsUser);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (AuthenticationException ae) {
                throw new IOException(ae);
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static abstract class TimelineClientRetryOp {
        public abstract Object run() throws IOException;

        public abstract boolean shouldRetryOn(Exception var1);
    }
}

