/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.ShutdownHookManager;

public final class KeyManagersReloaderThreadPool {
    public static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final int THREAD_POOL_SIZE = 10;
    private final ScheduledExecutorService scheduler;
    private final boolean isForTesting;
    private final List<ScheduledFuture> scheduledTasks;
    private static volatile KeyManagersReloaderThreadPool _INSTANCE;

    private KeyManagersReloaderThreadPool(boolean isForTesting) {
        this.isForTesting = isForTesting;
        this.scheduledTasks = new CopyOnWriteArrayList<ScheduledFuture>();
        this.scheduler = Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Client certificate reloader Thread #%d").build());
        ShutdownHookManager.get().addShutdownHook(new ShutdownHook(), 5);
    }

    public static KeyManagersReloaderThreadPool getInstance() {
        return KeyManagersReloaderThreadPool.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManagersReloaderThreadPool getInstance(boolean isForTesting) {
        if (_INSTANCE != null) return _INSTANCE;
        Class<KeyManagersReloaderThreadPool> clazz = KeyManagersReloaderThreadPool.class;
        synchronized (KeyManagersReloaderThreadPool.class) {
            if (_INSTANCE != null) return _INSTANCE;
            _INSTANCE = new KeyManagersReloaderThreadPool(isForTesting);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    public ScheduledFuture scheduleTask(Runnable task, long period, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduledTask = this.scheduler.scheduleAtFixedRate(task, 0L, period, timeUnit);
        if (this.isForTesting) {
            this.scheduledTasks.add(scheduledTask);
        }
        return scheduledTask;
    }

    public void clearListOfTasks() {
        this.scheduledTasks.clear();
    }

    public List<ScheduledFuture> getListOfTasks() {
        return this.scheduledTasks;
    }

    @VisibleForTesting
    public static void clearThreadPool() {
        _INSTANCE = null;
    }

    private class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            KeyManagersReloaderThreadPool.this.scheduler.shutdownNow();
        }
    }
}

