/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.security.token.block;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.entity.Variable;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.util.Time;

public class NameNodeBlockTokenSecretManager
extends BlockTokenSecretManager {
    private Namesystem namesystem;

    public NameNodeBlockTokenSecretManager(long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm, Namesystem namesystem) throws IOException {
        super(true, keyUpdateInterval, tokenLifetime, blockPoolId, encryptionAlgorithm);
        this.namesystem = namesystem;
    }

    @Override
    public synchronized boolean updateKeys() throws IOException {
        if (!this.isMaster) {
            return false;
        }
        if (this.isLeader()) {
            LOG.info((Object)"Updating block keys");
            return this.updateBlockKeys();
        }
        this.getAllKeysAndSync();
        this.removeExpiredKeys();
        return true;
    }

    protected boolean updateKeysParent() throws IOException {
        return super.updateKeys();
    }

    public void initKeys() throws IOException {
        do {
            if (this.isLeader()) {
                this.addBlockKeys();
                return;
            }
            this.getAllKeysAndSync();
        } while (this.currentKey.getExpiryDate() <= Time.now() + 2L * this.keyUpdateInterval + this.tokenLifetime);
    }

    private void addBlockKeys() throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_BLOCK_TOKENS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.BlockTokenKeys, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                HdfsVariables.updateBlockTokenKeys(NameNodeBlockTokenSecretManager.this.currentKey, NameNodeBlockTokenSecretManager.this.nextKey);
                return null;
            }
        }.handle();
    }

    private synchronized void getAllKeysAndSync() throws IOException {
        Collection<BlockKey> storedKeys = this.getAllKeys();
        if (storedKeys != null) {
            for (BlockKey key : storedKeys) {
                this.allKeys.put(key.getKeyId(), key);
                if (key.isCurrKey()) {
                    this.currentKey = key;
                    continue;
                }
                if (!key.isNextKey()) continue;
                this.nextKey = key;
            }
        }
    }

    private Collection<BlockKey> getAllKeys() throws IOException {
        return HdfsVariables.getAllBlockTokenKeysByIDLW().values();
    }

    private boolean updateBlockKeys() throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_BLOCK_KEYS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.BlockTokenKeys, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                Map<Integer, BlockKey> keys = HdfsVariables.getAllBlockTokenKeysByType();
                if (keys.isEmpty()) {
                    if (BlockTokenSecretManager.LOG.isDebugEnabled()) {
                        BlockTokenSecretManager.LOG.debug((Object)"keys is not generated yet to be updated");
                    }
                    return false;
                }
                NameNodeBlockTokenSecretManager.this.currentKey = keys.get(BlockKey.KeyType.CurrKey.ordinal());
                NameNodeBlockTokenSecretManager.this.nextKey = keys.get(BlockKey.KeyType.NextKey.ordinal());
                int previousKeyId = NameNodeBlockTokenSecretManager.this.currentKey.getKeyId();
                NameNodeBlockTokenSecretManager.this.updateKeysParent();
                HdfsVariables.updateBlockTokenKeys(NameNodeBlockTokenSecretManager.this.currentKey, NameNodeBlockTokenSecretManager.this.nextKey, (BlockKey)NameNodeBlockTokenSecretManager.this.allKeys.get(previousKeyId));
                return true;
            }
        }.handle();
    }

    private boolean isLeader() {
        if (this.namesystem != null) {
            return this.namesystem.isLeader();
        }
        return false;
    }
}

