/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Block
implements Writable,
Comparable<Block> {
    public static final String BLOCK_FILE_PREFIX = "blk_";
    public static final String METADATA_EXTENSION = ".meta";
    public static final Pattern blockFilePattern;
    public static final Pattern metaFilePattern;
    public static final Pattern metaOrBlockFilePattern;
    private static long NON_EXISTING_BLK_ID;
    private long blockId;
    private long numBytes;
    private long generationStamp;

    public static boolean isBlockFilename(File f) {
        String name = f.getName();
        return blockFilePattern.matcher(name).matches();
    }

    public static long filename2id(String name) {
        Matcher m = blockFilePattern.matcher(name);
        return m.matches() ? Long.parseLong(m.group(1)) : 0L;
    }

    public static boolean isMetaFilename(String name) {
        return metaFilePattern.matcher(name).matches();
    }

    public static File metaToBlockFile(File metaFile) {
        return new File(metaFile.getParent(), metaFile.getName().substring(0, metaFile.getName().lastIndexOf(95)));
    }

    public static long getGenerationStamp(String metaFile) {
        Matcher m = metaFilePattern.matcher(metaFile);
        return m.matches() ? Long.parseLong(m.group(2)) : 0L;
    }

    public static long getBlockId(String metaOrBlockFile) {
        Matcher m = metaOrBlockFilePattern.matcher(metaOrBlockFile);
        return m.matches() ? Long.parseLong(m.group(1)) : 0L;
    }

    public Block() {
        this(NON_EXISTING_BLK_ID, 0L, 0L);
    }

    public Block(long blkid, long len, long generationStamp) {
        this.setNoPersistance(blkid, len, generationStamp);
    }

    public Block(long blkid) {
        this(blkid, 0L, 0L);
    }

    public Block(Block blk) {
        this(blk.blockId, blk.numBytes, blk.generationStamp);
    }

    public void setNoPersistance(long blkid, long len, long genStamp) {
        this.blockId = blkid;
        this.numBytes = len;
        this.generationStamp = genStamp;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockIdNoPersistance(long bid) {
        this.blockId = bid;
    }

    public String getBlockName() {
        return BLOCK_FILE_PREFIX + String.valueOf(this.blockId);
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytesNoPersistance(long len) {
        this.numBytes = len;
    }

    public long getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStampNoPersistance(long stamp) {
        this.generationStamp = stamp;
    }

    public String toString() {
        return this.getBlockName() + "_" + this.getGenerationStamp();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.writeHelper(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.readHelper(in);
    }

    final void writeHelper(DataOutput out) throws IOException {
        out.writeLong(this.blockId);
        out.writeLong(this.numBytes);
        out.writeLong(this.generationStamp);
    }

    final void readHelper(DataInput in) throws IOException {
        this.blockId = in.readLong();
        this.numBytes = in.readLong();
        this.generationStamp = in.readLong();
        if (this.numBytes < 0L) {
            throw new IOException("Unexpected block size: " + this.numBytes);
        }
    }

    public void writeId(DataOutput out) throws IOException {
        out.writeLong(this.blockId);
        out.writeLong(this.generationStamp);
    }

    public void readId(DataInput in) throws IOException {
        this.blockId = in.readLong();
        this.generationStamp = in.readLong();
    }

    @Override
    public int compareTo(Block b) {
        return this.blockId < b.blockId ? -1 : (this.blockId > b.blockId ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Block)) {
            return false;
        }
        return this.compareTo((Block)o) == 0;
    }

    public static boolean matchingIdAndGenStamp(Block a, Block b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.blockId == b.blockId && a.generationStamp == b.generationStamp;
    }

    public int hashCode() {
        return (int)(this.blockId ^ this.blockId >>> 32);
    }

    static {
        WritableFactories.setFactory(Block.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new Block();
            }
        });
        blockFilePattern = Pattern.compile("blk_(-??\\d++)$");
        metaFilePattern = Pattern.compile("blk_(-??\\d++)_(\\d++)\\.meta$");
        metaOrBlockFilePattern = Pattern.compile("blk_(-??\\d++)(_(\\d++)\\.meta)?$");
        NON_EXISTING_BLK_ID = Long.MIN_VALUE;
    }
}

