/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Joiner;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.entity.Variable;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class StorageInfo {
    public static final Log LOG = LogFactory.getLog(StorageInfo.class);
    public static final int DEFAULT_ROW_ID = 0;
    protected String blockpoolID = "";
    private static StorageInfo storageInfo = null;
    public int layoutVersion;
    public int namespaceID;
    public String clusterID;
    public long cTime;
    protected final HdfsServerConstants.NodeType storageType;
    protected static final String STORAGE_FILE_VERSION = "VERSION";

    public StorageInfo(HdfsServerConstants.NodeType type) {
        this(0, 0, "", 0L, type, "");
    }

    public StorageInfo(int layoutV, int nsID, String cid, long cT, HdfsServerConstants.NodeType type, String bpid) {
        this.layoutVersion = layoutV;
        this.clusterID = cid;
        this.namespaceID = nsID;
        this.cTime = cT;
        this.storageType = type;
        this.blockpoolID = bpid;
    }

    public StorageInfo(StorageInfo from) {
        this(from.layoutVersion, from.namespaceID, from.clusterID, from.cTime, from.storageType, from.getBlockPoolId());
    }

    public StorageInfo(StorageInfo from, long cTime) {
        this(from.layoutVersion, from.namespaceID, from.clusterID, cTime, from.storageType, from.getBlockPoolId());
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public int getNamespaceID() {
        return this.namespaceID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public long getCTime() {
        return this.cTime;
    }

    public void setStorageInfo(StorageInfo from) {
        this.layoutVersion = from.layoutVersion;
        this.clusterID = from.clusterID;
        this.namespaceID = from.namespaceID;
        this.cTime = from.cTime;
    }

    public boolean versionSupportsFederation(Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> map) {
        return LayoutVersion.supports(map, LayoutVersion.Feature.FEDERATION, this.layoutVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lv=").append(this.layoutVersion).append(";cid=").append(this.clusterID).append(";nsid=").append(this.namespaceID).append(";c=").append(this.cTime);
        return sb.toString();
    }

    public String toColonSeparatedString() {
        return Joiner.on((String)":").join((Object)this.layoutVersion, (Object)this.namespaceID, new Object[]{this.cTime, this.clusterID});
    }

    public static StorageInfo getStorageInfoFromDB() throws IOException {
        if (storageInfo == null) {
            storageInfo = (StorageInfo)new HopsTransactionalRequestHandler(HDFSOperationType.GET_STORAGE_INFO){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getVariableLock(Variable.Finder.StorageInfo, TransactionLockTypes.LockType.WRITE));
                }

                public Object performTask() throws StorageException, IOException {
                    return HdfsVariables.getStorageInfo();
                }
            }.handle();
        }
        return storageInfo;
    }

    public static void storeStorageInfoToDB(final String clusterId, final long cTime) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_STORAGE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.StorageInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                Configuration conf = new Configuration();
                String bpid = StorageInfo.newBlockPoolID();
                storageInfo = new StorageInfo(HdfsConstants.NAMENODE_LAYOUT_VERSION, conf.getInt("dfs.name.space.id", 911), clusterId, cTime, HdfsServerConstants.NodeType.NAME_NODE, bpid);
                HdfsVariables.setStorageInfo(storageInfo);
                LOG.info((Object)("Added new entry to storage info. nsid:dfs.name.space.id CID:" + clusterId + " pbid:" + bpid));
                return null;
            }
        }.handle();
    }

    public static void updateStorageInfoToDB(final StorageInfo sInfo, final long cTime) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_STORAGE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.StorageInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                storageInfo = new StorageInfo(sInfo, cTime);
                HdfsVariables.setStorageInfo(storageInfo);
                LOG.info((Object)("Added new entry to storage info. nsid:dfs.name.space.id CID:" + sInfo.clusterID + " pbid:" + sInfo.blockpoolID));
                return null;
            }
        }.handle();
    }

    public String getBlockPoolId() {
        return this.blockpoolID;
    }

    static String newBlockPoolID() throws UnknownHostException {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException e) {
            System.out.println("Could not find ip address of \"default\" inteface.");
            throw e;
        }
        int rand = DFSUtil.getSecureRandom().nextInt(Integer.MAX_VALUE);
        String bpid = "BP-" + rand + "-" + ip + "-" + Time.now();
        return bpid;
    }

    public static String newClusterID() {
        return "CID-" + UUID.randomUUID().toString();
    }

    public int getDefaultRowId() {
        return 0;
    }

    public void setServiceLayoutVersion(int lv) {
        this.layoutVersion = lv;
    }

    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setLayoutVersion(props, sd);
        this.setNamespaceID(props, sd);
        this.setcTime(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
        this.checkStorageType(props, sd);
    }

    protected void checkStorageType(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        if (this.storageType == null) {
            return;
        }
        HdfsServerConstants.NodeType type = HdfsServerConstants.NodeType.valueOf(StorageInfo.getProperty(props, sd, "storageType"));
        if (!this.storageType.equals((Object)type)) {
            throw new InconsistentFSStateException(sd.root, "Incompatible node types: storageType=" + (Object)((Object)this.storageType) + " but StorageDirectory type=" + (Object)((Object)type));
        }
    }

    protected void setcTime(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        this.cTime = Long.parseLong(StorageInfo.getProperty(props, sd, "cTime"));
    }

    protected void setClusterId(Properties props, int layoutVersion, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        if (LayoutVersion.supports(this.getServiceLayoutFeatureMap(), LayoutVersion.Feature.FEDERATION, layoutVersion)) {
            String cid = StorageInfo.getProperty(props, sd, "clusterID");
            if (!(this.clusterID.equals("") || cid.equals("") || this.clusterID.equals(cid))) {
                throw new InconsistentFSStateException(sd.getRoot(), "cluster Id is incompatible with others.");
            }
            this.clusterID = cid;
        }
    }

    protected void setLayoutVersion(Properties props, Storage.StorageDirectory sd) throws IncorrectVersionException, InconsistentFSStateException {
        int lv = Integer.parseInt(StorageInfo.getProperty(props, sd, "layoutVersion"));
        if (lv < this.getServiceLayoutVersion()) {
            throw new IncorrectVersionException(this.getServiceLayoutVersion(), lv, "storage directory " + sd.root.getAbsolutePath());
        }
        this.layoutVersion = lv;
    }

    protected void setNamespaceID(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        int nsId = Integer.parseInt(StorageInfo.getProperty(props, sd, "namespaceID"));
        if (this.namespaceID != 0 && nsId != 0 && this.namespaceID != nsId) {
            throw new InconsistentFSStateException(sd.root, "namespaceID is incompatible with others.");
        }
        this.namespaceID = nsId;
    }

    public int getServiceLayoutVersion() {
        return this.storageType == HdfsServerConstants.NodeType.DATA_NODE ? HdfsConstants.DATANODE_LAYOUT_VERSION : HdfsConstants.NAMENODE_LAYOUT_VERSION;
    }

    public Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> getServiceLayoutFeatureMap() {
        return this.storageType == HdfsServerConstants.NodeType.DATA_NODE ? DataNodeLayoutVersion.FEATURES : NameNodeLayoutVersion.FEATURES;
    }

    static String getProperty(Properties props, Storage.StorageDirectory sd, String name) throws InconsistentFSStateException {
        String property = props.getProperty(name);
        if (property == null) {
            throw new InconsistentFSStateException(sd.root, "file VERSION has " + name + " missing.");
        }
        return property;
    }

    public HdfsServerConstants.NodeType getStorageType() {
        return this.storageType;
    }
}

