/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.dal.FileProvXAttrBufferDataAccess;
import io.hops.metadata.hdfs.entity.FileProvXAttrBufferEntry;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Objects;

public class FileProvXAttrBufferContext
extends BaseEntityContext<Key, FileProvXAttrBufferEntry> {
    private final FileProvXAttrBufferDataAccess<FileProvXAttrBufferEntry> dataAccess;

    public FileProvXAttrBufferContext(FileProvXAttrBufferDataAccess<FileProvXAttrBufferEntry> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void add(FileProvXAttrBufferEntry entry) throws TransactionContextException {
        super.add((Object)entry);
        this.log("provenance-log-added", new Object[]{"inodeId", entry.getInodeId(), "namespace", entry.getNamespace(), "name", entry.getName(), "inodeLogicalTime", entry.getINodeLogicalTime()});
    }

    Key getKey(FileProvXAttrBufferEntry entry) {
        return new Key(entry.getInodeId(), entry.getNamespace(), entry.getName(), entry.getINodeLogicalTime());
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.addAll(this.getAdded());
    }

    class Key {
        long inodeId;
        byte namespace;
        String name;
        long inodeLogicalTime;

        public Key(long inodeId, byte namespace, String name, long inodeLogicalTime) {
            this.inodeId = inodeId;
            this.namespace = namespace;
            this.name = name;
            this.inodeLogicalTime = this.inodeLogicalTime;
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (int)(this.inodeId ^ this.inodeId >>> 32);
            hash = 89 * hash + this.namespace;
            hash = 89 * hash + Objects.hashCode(this.name);
            hash = 89 * hash + (int)(this.inodeLogicalTime ^ this.inodeLogicalTime >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.inodeId != other.inodeId) {
                return false;
            }
            if (this.namespace != other.namespace) {
                return false;
            }
            if (this.inodeLogicalTime != other.inodeLogicalTime) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }

        public String toString() {
            return "Key{inodeId=" + this.inodeId + ", namespace=" + this.namespace + ", name=" + this.name + ", inodeLogicalTime=" + this.inodeLogicalTime + '}';
        }
    }
}

