/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuotaUpdateContext
extends BaseEntityContext<Integer, QuotaUpdate> {
    private final QuotaUpdateDataAccess<QuotaUpdate> dataAccess;
    private final Map<Long, List<QuotaUpdate>> inodeIdToQuotaUpdates = new HashMap<Long, List<QuotaUpdate>>();

    public QuotaUpdateContext(QuotaUpdateDataAccess<QuotaUpdate> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(QuotaUpdate quotaUpdate) throws TransactionContextException {
        super.update((Object)quotaUpdate);
        if (this.isLogTraceEnabled()) {
            this.log("added-quotaUpdate", new Object[]{"id", quotaUpdate.getId(), "inodeId", quotaUpdate.getInodeId(), "dsDeltea", quotaUpdate.getStorageSpaceDelta(), "nsDelta", quotaUpdate.getNamespaceDelta()});
        }
    }

    public void remove(QuotaUpdate quotaUpdate) throws TransactionContextException {
        if (quotaUpdate != null) {
            super.remove((Object)quotaUpdate);
            if (this.isLogTraceEnabled()) {
                this.log("removed-quotaUpdate", new Object[]{"id", quotaUpdate});
            }
        }
    }

    public QuotaUpdate find(FinderType<QuotaUpdate> finder, Object ... params) throws TransactionContextException, StorageException {
        QuotaUpdate.Finder qFinder = (QuotaUpdate.Finder)finder;
        switch (qFinder) {
            case ByKey: {
                return this.findByKey(qFinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public Collection<QuotaUpdate> findList(FinderType<QuotaUpdate> finder, Object ... params) throws TransactionContextException, StorageException {
        QuotaUpdate.Finder qFinder = (QuotaUpdate.Finder)finder;
        switch (qFinder) {
            case ByINodeId: {
                return this.findByINodeId(qFinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        ArrayList modified = new ArrayList(this.getModified());
        modified.addAll(this.getAdded());
        this.dataAccess.prepare(modified, this.getRemoved());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.inodeIdToQuotaUpdates.clear();
    }

    Integer getKey(QuotaUpdate quotaUpdate) {
        return quotaUpdate.getId();
    }

    private List<QuotaUpdate> findByINodeId(QuotaUpdate.Finder qFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        int limit = (Integer)params[1];
        List result = null;
        if (this.inodeIdToQuotaUpdates.containsKey(inodeId)) {
            result = this.inodeIdToQuotaUpdates.get(inodeId);
            this.hit((FinderType)qFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)qFinder, params);
            result = this.dataAccess.findByInodeId(inodeId, limit);
            this.gotFromDB(inodeId, result);
            this.miss((FinderType)qFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private QuotaUpdate findByKey(QuotaUpdate.Finder qFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int id = (Integer)params[0];
        long inodeId = (Long)params[1];
        this.aboutToAccessStorage((FinderType)qFinder, params);
        QuotaUpdate result = this.dataAccess.findByKey(id, inodeId);
        this.gotFromDB(inodeId, result);
        this.miss((FinderType)qFinder, result, new Object[]{"id", id});
        return result;
    }

    private void gotFromDB(long inodeId, List<QuotaUpdate> quotaUpdates) {
        this.gotFromDB(quotaUpdates);
        this.inodeIdToQuotaUpdates.put(inodeId, quotaUpdates);
    }

    private void gotFromDB(long inodeId, QuotaUpdate quotaUpdate) {
        this.gotFromDB(quotaUpdate);
        List<QuotaUpdate> list = this.inodeIdToQuotaUpdates.get(inodeId);
        if (list == null) {
            list = new ArrayList<QuotaUpdate>();
            this.inodeIdToQuotaUpdates.put(inodeId, list);
        }
        list.add(quotaUpdate);
    }
}

