/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.org.apache.commons.codec.binary.Hex;
import java.io.Serializable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;

@InterfaceAudience.Private
public class FileEncryptionInfo
implements Serializable {
    private static final long serialVersionUID = 359316995L;
    private final CipherSuite cipherSuite;
    private final CryptoProtocolVersion version;
    private final byte[] edek;
    private final byte[] iv;
    private final String keyName;
    private final String ezKeyVersionName;

    public FileEncryptionInfo(CipherSuite suite, CryptoProtocolVersion version, byte[] edek, byte[] iv, String keyName, String ezKeyVersionName) {
        Preconditions.checkNotNull((Object)((Object)suite));
        Preconditions.checkNotNull((Object)((Object)version));
        Preconditions.checkNotNull((Object)edek);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)ezKeyVersionName);
        Preconditions.checkArgument((iv.length == suite.getAlgorithmBlockSize() ? 1 : 0) != 0, (Object)"Unexpected IV length");
        this.cipherSuite = suite;
        this.version = version;
        this.edek = edek;
        this.iv = iv;
        this.keyName = keyName;
        this.ezKeyVersionName = ezKeyVersionName;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CryptoProtocolVersion getCryptoProtocolVersion() {
        return this.version;
    }

    public byte[] getEncryptedDataEncryptionKey() {
        return this.edek;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEzKeyVersionName() {
        return this.ezKeyVersionName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("cipherSuite: " + (Object)((Object)this.cipherSuite));
        builder.append(", cryptoProtocolVersion: " + (Object)((Object)this.version));
        builder.append(", edek: " + Hex.encodeHexString((byte[])this.edek));
        builder.append(", iv: " + Hex.encodeHexString((byte[])this.iv));
        builder.append(", keyName: " + this.keyName);
        builder.append(", ezKeyVersionName: " + this.ezKeyVersionName);
        builder.append("}");
        return builder.toString();
    }

    public String toStringStable() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("cipherSuite: " + (Object)((Object)this.cipherSuite));
        builder.append(", cryptoProtocolVersion: " + (Object)((Object)this.version));
        builder.append(", edek: " + Hex.encodeHexString((byte[])this.edek));
        builder.append(", iv: " + Hex.encodeHexString((byte[])this.iv));
        builder.append(", keyName: " + this.keyName);
        builder.append(", ezKeyVersionName: " + this.ezKeyVersionName);
        builder.append("}");
        return builder.toString();
    }
}

