/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import io.hops.hadoop.shaded.com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TokenPBImpl
extends Token {
    private SecurityProtos.TokenProto proto = SecurityProtos.TokenProto.getDefaultInstance();
    private SecurityProtos.TokenProto.Builder builder = null;
    private boolean viaProto = false;
    private ByteBuffer identifier;
    private ByteBuffer password;

    public TokenPBImpl() {
        this.builder = SecurityProtos.TokenProto.newBuilder();
    }

    public TokenPBImpl(SecurityProtos.TokenProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized SecurityProtos.TokenProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((TokenPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    protected final ByteBuffer convertFromProtoFormat(ByteString byteString) {
        return ProtoUtils.convertFromProtoFormat(byteString);
    }

    protected final ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        return ProtoUtils.convertToProtoFormat(byteBuffer);
    }

    private synchronized void mergeLocalToBuilder() {
        if (this.identifier != null) {
            this.builder.setIdentifier(this.convertToProtoFormat(this.identifier));
        }
        if (this.password != null) {
            this.builder.setPassword(this.convertToProtoFormat(this.password));
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = SecurityProtos.TokenProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized ByteBuffer getIdentifier() {
        SecurityProtos.TokenProtoOrBuilder p;
        SecurityProtos.TokenProtoOrBuilder tokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.identifier != null) {
            return this.identifier;
        }
        if (!p.hasIdentifier()) {
            return null;
        }
        this.identifier = this.convertFromProtoFormat(p.getIdentifier());
        return this.identifier;
    }

    @Override
    public synchronized void setIdentifier(ByteBuffer identifier) {
        this.maybeInitBuilder();
        if (identifier == null) {
            this.builder.clearIdentifier();
        }
        this.identifier = identifier;
    }

    @Override
    public synchronized ByteBuffer getPassword() {
        SecurityProtos.TokenProtoOrBuilder p;
        SecurityProtos.TokenProtoOrBuilder tokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.password != null) {
            return this.password;
        }
        if (!p.hasPassword()) {
            return null;
        }
        this.password = this.convertFromProtoFormat(p.getPassword());
        return this.password;
    }

    @Override
    public synchronized void setPassword(ByteBuffer password) {
        this.maybeInitBuilder();
        if (password == null) {
            this.builder.clearPassword();
        }
        this.password = password;
    }

    @Override
    public synchronized String getKind() {
        SecurityProtos.TokenProtoOrBuilder p;
        SecurityProtos.TokenProtoOrBuilder tokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasKind()) {
            return null;
        }
        return p.getKind();
    }

    @Override
    public synchronized void setKind(String kind) {
        this.maybeInitBuilder();
        if (kind == null) {
            this.builder.clearKind();
            return;
        }
        this.builder.setKind(kind);
    }

    @Override
    public synchronized String getService() {
        SecurityProtos.TokenProtoOrBuilder p;
        SecurityProtos.TokenProtoOrBuilder tokenProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasService()) {
            return null;
        }
        return p.getService();
    }

    @Override
    public synchronized void setService(String service) {
        this.maybeInitBuilder();
        if (service == null) {
            this.builder.clearService();
            return;
        }
        this.builder.setService(service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Token { ");
        sb.append("kind: ").append(this.getKind()).append(", ");
        sb.append("service: ").append(this.getService()).append(" }");
        return sb.toString();
    }
}

