/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLogToolkit;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.core.IsNot;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class TxnLogToolkitTest {
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private File mySnapDir;

    @Before
    public void setUp() throws IOException {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
        File snapDir = new File(testData, "invalidsnap");
        this.mySnapDir = ClientBase.createTmpDir();
        FileUtils.copyDirectory((File)snapDir, (File)this.mySnapDir);
    }

    @After
    public void tearDown() throws IOException {
        System.setOut(System.out);
        System.setErr(System.err);
        this.mySnapDir.setWritable(true);
        FileUtils.deleteDirectory((File)this.mySnapDir);
    }

    @Test
    public void testDumpMode() throws Exception {
        File logfile = new File(new File(this.mySnapDir, "version-2"), "log.274");
        TxnLogToolkit lt = new TxnLogToolkit(false, false, logfile.toString(), true);
        lt.dump(null);
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitException.class)
    public void testInitMissingFile() throws FileNotFoundException, TxnLogToolkit.TxnLogToolkitException {
        File logfile = new File("this_file_should_not_exists");
        TxnLogToolkit lt = new TxnLogToolkit(false, false, logfile.toString(), true);
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitException.class)
    public void testInitWithRecoveryFileExists() throws IOException, TxnLogToolkit.TxnLogToolkitException {
        File logfile = new File(new File(this.mySnapDir, "version-2"), "log.274");
        File recoveryFile = new File(new File(this.mySnapDir, "version-2"), "log.274.fixed");
        recoveryFile.createNewFile();
        TxnLogToolkit lt = new TxnLogToolkit(true, false, logfile.toString(), true);
    }

    @Test
    public void testDumpWithCrcError() throws Exception {
        File logfile = new File(new File(this.mySnapDir, "version-2"), "log.42");
        TxnLogToolkit lt = new TxnLogToolkit(false, false, logfile.toString(), true);
        lt.dump(null);
        String output = this.outContent.toString();
        Pattern p = Pattern.compile("^CRC ERROR.*session 0x8061fac5ddeb0000 cxid 0x0 zxid 0x8800000002 createSession 30000$", 8);
        java.util.regex.Matcher m = p.matcher(output);
        Assert.assertTrue((String)("Output doesn't indicate CRC error for the broken session id: " + output), (boolean)m.find());
    }

    @Test
    public void testRecoveryFixBrokenFile() throws Exception {
        File logfile = new File(new File(this.mySnapDir, "version-2"), "log.42");
        TxnLogToolkit lt = new TxnLogToolkit(true, false, logfile.toString(), true);
        lt.dump(null);
        String output = this.outContent.toString();
        Assert.assertThat((Object)output, (Matcher)JUnitMatchers.containsString((String)"CRC FIXED"));
        this.outContent.reset();
        logfile = new File(new File(this.mySnapDir, "version-2"), "log.42.fixed");
        lt = new TxnLogToolkit(false, false, logfile.toString(), true);
        lt.dump(null);
        output = this.outContent.toString();
        Assert.assertThat((Object)output, IsNot.not(JUnitMatchers.containsString((String)"CRC ERROR")));
    }

    @Test
    public void testRecoveryInteractiveMode() throws Exception {
        File logfile = new File(new File(this.mySnapDir, "version-2"), "log.42");
        TxnLogToolkit lt = new TxnLogToolkit(true, false, logfile.toString(), false);
        lt.dump(new Scanner("y\n"));
        String output = this.outContent.toString();
        Assert.assertThat((Object)output, (Matcher)JUnitMatchers.containsString((String)"CRC ERROR"));
        this.outContent.reset();
        logfile = new File(new File(this.mySnapDir, "version-2"), "log.42.fixed");
        lt = new TxnLogToolkit(false, false, logfile.toString(), true);
        lt.dump(null);
        output = this.outContent.toString();
        Assert.assertThat((Object)output, IsNot.not(JUnitMatchers.containsString((String)"CRC ERROR")));
    }
}

