/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Learner;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class LearnerTest
extends ZKTestCase {
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));

    private static void recursiveDelete(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            dir.delete();
        }
        for (File child : dir.listFiles()) {
            LearnerTest.recursiveDelete(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void syncTest() throws Exception {
        File tmpFile = File.createTempFile("test", ".dir", testData);
        tmpFile.delete();
        try {
            FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpFile, tmpFile);
            SimpleLearner sl = new SimpleLearner(ftsl);
            long startZxid = sl.zk.getLastProcessedZxid();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive(baos);
            sl.leaderOs = BinaryOutputArchive.getArchive(new ByteArrayOutputStream());
            sl.bufferedOutput = new BufferedOutputStream(System.out);
            sl.sock = new Socket();
            QuorumPacket qp = new QuorumPacket(15, 0L, null, null);
            oa.writeRecord(qp, null);
            sl.zk.getZKDatabase().serializeSnapshot(oa);
            oa.writeString("BenWasHere", "signature");
            TxnHeader hdr = new TxnHeader(0L, 0, 0L, 0L, 1);
            CreateTxn txn = new CreateTxn("/foo", new byte[0], new ArrayList<ACL>(), false, sl.zk.getZKDatabase().getNode((String)"/").stat.getCversion());
            ByteArrayOutputStream tbaos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(tbaos);
            hdr.serialize(boa, "hdr");
            txn.serialize(boa, "txn");
            tbaos.close();
            qp = new QuorumPacket(2, 1L, tbaos.toByteArray(), null);
            oa.writeRecord(qp, null);
            sl.leaderIs = BinaryInputArchive.getArchive(new ByteArrayInputStream(baos.toByteArray()));
            try {
                sl.syncWithLeader(3L);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            sl.zk.shutdown();
            sl = new SimpleLearner(ftsl);
            Assert.assertEquals((long)startZxid, (long)sl.zk.getLastProcessedZxid());
        }
        finally {
            LearnerTest.recursiveDelete(tmpFile);
        }
    }

    class SimpleLearner
    extends Learner {
        SimpleLearner(FileTxnSnapLog ftsl) throws IOException {
            this.self = QuorumPeer.testingQuorumPeer();
            this.zk = new SimpleLearnerZooKeeperServer(ftsl, this.self);
            ((SimpleLearnerZooKeeperServer)this.zk).learner = this;
        }
    }

    class SimpleLearnerZooKeeperServer
    extends LearnerZooKeeperServer {
        boolean startupCalled;
        Learner learner;

        public SimpleLearnerZooKeeperServer(FileTxnSnapLog ftsl, QuorumPeer self) throws IOException {
            super(ftsl, 2000, 2000, 2000, null, new ZKDatabase(ftsl), self);
        }

        @Override
        public Learner getLearner() {
            return this.learner;
        }

        @Override
        public void startup() {
            this.startupCalled = true;
        }
    }
}

